/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.model;

import com.android.tools.idea.layoutinspector.model.DrawViewNode;
import com.android.tools.idea.layoutinspector.model.DrawViewNodeKt;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.ui.RenderSettings;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J8\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/layoutinspector/model/DrawViewImage;", "Lcom/android/tools/idea/layoutinspector/model/DrawViewNode;", "image", "Ljava/awt/Image;", "owner", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "deviceClip", "Ljava/awt/Shape;", "(Ljava/awt/Image;Lcom/android/tools/idea/layoutinspector/model/ViewNode;Ljava/awt/Shape;)V", "getImage", "()Ljava/awt/Image;", "canCollapse", "", "treeSettings", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "paint", "", "g2", "Ljava/awt/Graphics2D;", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "paintBorder", "isSelected", "isHovered", "viewSettings", "Lcom/android/tools/idea/layoutinspector/ui/RenderSettings;", "intellij.android.layout-inspector"})
public final class DrawViewImage
extends DrawViewNode {
    @NotNull
    private final Image image;
    @Nullable
    private final Shape deviceClip;

    public DrawViewImage(@NotNull Image image, @NotNull ViewNode owner, @Nullable Shape deviceClip) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner, null);
        this.image = image;
        this.deviceClip = deviceClip;
    }

    public /* synthetic */ DrawViewImage(Image image, ViewNode viewNode, Shape shape, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            shape = null;
        }
        this(image, viewNode, shape);
    }

    @VisibleForTesting
    @NotNull
    public final Image getImage() {
        return this.image;
    }

    @Override
    public boolean canCollapse(@NotNull TreeSettings treeSettings2) {
        Intrinsics.checkNotNullParameter((Object)treeSettings2, (String)"treeSettings");
        return true;
    }

    @Override
    public void paint(@NotNull Graphics2D g2, @NotNull InspectorModel model2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Shape shape = this.deviceClip;
        if (shape != null) {
            Shape it = shape;
            boolean bl = false;
            g2.clip(this.deviceClip);
        }
        Rectangle bounds = this.getBounds().getBounds();
        UIUtil.drawImage((Graphics)g2, (Image)this.image, (Rectangle)new Rectangle(Math.max(bounds.x, 0), Math.max(bounds.y, 0), bounds.width + Math.min(bounds.x, 0), bounds.height + Math.min(bounds.y, 0)), (Rectangle)new Rectangle(0, 0, this.image.getWidth(null), this.image.getHeight(null)), null);
    }

    @Override
    public void paintBorder(@NotNull Graphics2D g2, boolean isSelected, boolean isHovered, @NotNull InspectorModel model2, @NotNull RenderSettings viewSettings, @NotNull TreeSettings treeSettings2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
        Intrinsics.checkNotNullParameter((Object)treeSettings2, (String)"treeSettings");
        if (isSelected || isHovered) {
            g2.setColor(DrawViewNodeKt.access$getEMPHASIZED_LINE_OUTLINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getEmphasizedImageLineOutlineStroke(viewSettings.getScaleFraction()));
            g2.draw(this.getBounds());
        }
        if (isSelected) {
            g2.setColor(DrawViewNodeKt.access$getSELECTED_LINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getSelectedImageLineStroke(viewSettings.getScaleFraction()));
        } else if (isHovered) {
            g2.setColor(DrawViewNodeKt.access$getEMPHASIZED_LINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getEmphasizedImageLineStroke(viewSettings.getScaleFraction()));
        } else {
            g2.setColor(DrawViewNodeKt.access$getNORMAL_LINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getNormalImageLineStroke(viewSettings.getScaleFraction()));
        }
        g2.draw(this.getBounds());
    }
}

