/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.model;

import com.android.tools.idea.layoutinspector.model.ComposeViewNode;
import com.android.tools.idea.layoutinspector.model.DrawViewNode;
import com.android.tools.idea.layoutinspector.model.DrawViewNodeKt;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.RecompositionData;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.ui.RenderSettings;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J8\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/layoutinspector/model/DrawViewChild;", "Lcom/android/tools/idea/layoutinspector/model/DrawViewNode;", "owner", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "(Lcom/android/tools/idea/layoutinspector/model/ViewNode;)V", "drawWhenCollapsed", "", "getDrawWhenCollapsed", "()Z", "canCollapse", "treeSettings", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "children", "Lkotlin/sequences/Sequence;", "access", "Lcom/android/tools/idea/layoutinspector/model/ViewNode$ReadAccess;", "computeLabelPosition", "Lkotlin/Triple;", "", "border", "Ljava/awt/Shape;", "textWidth", "heatmapColor", "Ljava/awt/Color;", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "highlightCount", "viewSettings", "Lcom/android/tools/idea/layoutinspector/ui/RenderSettings;", "highlightColor", "paint", "", "g2", "Ljava/awt/Graphics2D;", "paintBorder", "isSelected", "isHovered", "intellij.android.layout-inspector"})
public final class DrawViewChild
extends DrawViewNode {
    public DrawViewChild(@NotNull ViewNode owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner, null);
    }

    @Override
    public boolean canCollapse(@NotNull TreeSettings treeSettings2) {
        Intrinsics.checkNotNullParameter((Object)treeSettings2, (String)"treeSettings");
        return !this.getUnfilteredOwner().isInComponentTree(treeSettings2);
    }

    @Override
    public boolean getDrawWhenCollapsed() {
        return false;
    }

    @Override
    public void paint(@NotNull Graphics2D g2, @NotNull InspectorModel model2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
    }

    @Override
    public void paintBorder(@NotNull Graphics2D g2, boolean isSelected, boolean isHovered, @NotNull InspectorModel model2, @NotNull RenderSettings viewSettings, @NotNull TreeSettings treeSettings2) {
        boolean showHighlight;
        boolean showCount;
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
        Intrinsics.checkNotNullParameter((Object)treeSettings2, (String)"treeSettings");
        ViewNode viewNode = this.findFilteredOwner(treeSettings2);
        if (viewNode == null) {
            return;
        }
        ViewNode owner = viewNode;
        if (isSelected || isHovered) {
            g2.setColor(DrawViewNodeKt.access$getEMPHASIZED_LINE_OUTLINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getEmphasizedLineOutlineStroke(viewSettings.getScaleFraction()));
            if (viewSettings.getDrawBorders()) {
                g2.draw(this.getBounds());
            }
            if (viewSettings.getDrawUntransformedBounds()) {
                g2.draw(owner.getLayoutBounds());
            }
        }
        float labelX = 0.0f;
        float countX = 0.0f;
        float labelY = 0.0f;
        float borderWidth = 0.0f;
        ComposeViewNode composeView = owner instanceof ComposeViewNode ? (ComposeViewNode)owner : null;
        Object object = composeView;
        int composeCount = object != null && (object = ((ComposeViewNode)object).getRecompositions()) != null ? ((RecompositionData)object).getCount() : 0;
        Object object2 = composeView;
        float highlightCount = object2 != null && (object2 = ((ComposeViewNode)object2).getRecompositions()) != null ? ((RecompositionData)object2).getHighlightCount() : 0.0f;
        boolean bl = showCount = isSelected && treeSettings2.getShowRecompositions() && composeCount > 0;
        boolean bl2 = treeSettings2.getShowRecompositions() && highlightCount > 0.0f && !(model2.getMaxHighlight() == 0.0f) ? true : (showHighlight = false);
        if (isSelected && viewSettings.getDrawLabel()) {
            g2.setFont(g2.getFont().deriveFont(DrawViewNodeKt.getLabelFontSize(viewSettings.getScaleFraction())));
            FontMetrics fontMetrics = g2.getFontMetrics();
            float textWidth = fontMetrics.stringWidth(owner.getUnqualifiedName());
            float countWidth = showCount ? (float)fontMetrics.stringWidth(String.valueOf(composeCount)) : 0.0f;
            Shape border = viewSettings.getDrawBorders() || !viewSettings.getDrawUntransformedBounds() ? this.getBounds() : (Shape)owner.getLayoutBounds();
            float textHeight = fontMetrics.getMaxAscent();
            borderWidth = textHeight * 0.3f;
            Triple<Float, Float, Float> position = this.computeLabelPosition(border, textWidth);
            labelX = ((Number)position.getFirst()).floatValue();
            countX = ((Number)position.getSecond()).floatValue() - countWidth - 2.0f * borderWidth;
            labelY = ((Number)position.getThird()).floatValue();
            showCount = showCount && labelX + textWidth + 2.0f * borderWidth < countX - 2.0f * borderWidth;
            g2.draw(new Rectangle2D.Float(labelX, labelY - textHeight - 2.0f * borderWidth, textWidth + 2.0f * borderWidth, textHeight + 2.0f * borderWidth));
            if (showCount) {
                g2.draw(new Rectangle2D.Float(countX, labelY - textHeight - 2.0f * borderWidth, countWidth + 2.0f * borderWidth, textHeight + 2.0f * borderWidth));
            }
            g2.setColor(DrawViewNodeKt.access$getSELECTED_LINE_COLOR$p());
            float emphasizedBorderThickness = DrawViewNodeKt.getEmphasizedBorderThickness(viewSettings.getScaleFraction());
            g2.fill(new Rectangle2D.Float(labelX - emphasizedBorderThickness / 2.0f, labelY - textHeight - 2.0f * borderWidth - emphasizedBorderThickness / 2.0f, textWidth + 2.0f * borderWidth + emphasizedBorderThickness, textHeight + 2.0f * borderWidth + emphasizedBorderThickness));
            if (showCount) {
                g2.fill(new Rectangle2D.Float(countX - emphasizedBorderThickness / 2.0f, labelY - textHeight - 2.0f * borderWidth - emphasizedBorderThickness / 2.0f, countWidth + 2.0f * borderWidth + emphasizedBorderThickness, textHeight + 2.0f * borderWidth + emphasizedBorderThickness));
            }
        }
        if (isSelected) {
            g2.setColor(DrawViewNodeKt.access$getSELECTED_LINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getSelectedLineStroke(viewSettings.getScaleFraction()));
        } else if (isHovered) {
            g2.setColor(DrawViewNodeKt.access$getEMPHASIZED_LINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getEmphasizedLineStroke(viewSettings.getScaleFraction()));
        } else if (showHighlight) {
            g2.setColor(this.highlightColor(model2, highlightCount, viewSettings));
            g2.setStroke(DrawViewNodeKt.access$getNormalLineStroke(viewSettings.getScaleFraction()));
        } else {
            g2.setColor(treeSettings2.getShowRecompositions() ? DrawViewNodeKt.access$getFAINT_LINE_COLOR$p() : DrawViewNodeKt.access$getNORMAL_LINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getNormalLineStroke(viewSettings.getScaleFraction()));
        }
        if (viewSettings.getDrawBorders() || isHovered || showHighlight || isSelected && !viewSettings.getDrawUntransformedBounds()) {
            g2.draw(this.getBounds());
        }
        if (viewSettings.getDrawUntransformedBounds()) {
            g2.draw(owner.getLayoutBounds());
        }
        if (isSelected && viewSettings.getDrawLabel()) {
            g2.setColor(Color.WHITE);
            g2.drawString(owner.getUnqualifiedName(), labelX + borderWidth, labelY - borderWidth - DrawViewNodeKt.getEmphasizedBorderThickness(viewSettings.getScaleFraction()) / 2.0f);
            if (showCount) {
                g2.drawString(String.valueOf(composeCount), countX + borderWidth, labelY - borderWidth - DrawViewNodeKt.getEmphasizedBorderThickness(viewSettings.getScaleFraction()) / 2.0f);
            }
        }
        if (showHighlight) {
            Rectangle2D rect = this.getBounds().getBounds2D();
            g2.setPaint(new GradientPaint((float)rect.getX(), (float)rect.getY(), this.heatmapColor(model2, highlightCount, viewSettings), (float)(rect.getX() + rect.getWidth()), (float)(rect.getY() + rect.getHeight()), this.heatmapColor(model2, 0.0f, viewSettings)));
            g2.fill(this.getBounds());
        }
    }

    private final Color highlightColor(InspectorModel model2, float highlightCount, RenderSettings viewSettings) {
        Color baseColor = new Color(viewSettings.getHighlightColor());
        int alpha = RangesKt.coerceIn((int)((int)(highlightCount * 255.0f / model2.getMaxHighlight())), (int)32, (int)255);
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
    }

    private final Color heatmapColor(InspectorModel model2, float highlightCount, RenderSettings viewSettings) {
        Color baseColor = new Color(viewSettings.getHighlightColor());
        int alpha = RangesKt.coerceIn((int)((int)(highlightCount * 192.0f / model2.getMaxHighlight())), (int)8, (int)192);
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
    }

    private final Triple<Float, Float, Float> computeLabelPosition(Shape border, float textWidth) {
        float minY = (float)border.getBounds().getMinY();
        float minSlope = Float.MAX_VALUE;
        float[] nextPoint = new float[6];
        PathIterator pathIter = border.getPathIterator(null);
        pathIter.currentSegment(nextPoint);
        float prevX = 0.0f;
        float prevY = 0.0f;
        float leastSlopedSideWidth = 0.0f;
        float topLeftY = 0.0f;
        float xLeft = 0.0f;
        float xRight = 0.0f;
        while (true) {
            float slope;
            prevX = nextPoint[0];
            prevY = nextPoint[1];
            pathIter.next();
            if (pathIter.isDone()) break;
            pathIter.currentSegment(nextPoint);
            if (!(prevY == minY) && !(nextPoint[1] == minY) || (double)Math.abs(prevX - nextPoint[0]) < 0.001 || !(Math.abs(slope = (nextPoint[1] - prevY) / (nextPoint[0] - prevX)) < Math.abs(minSlope))) continue;
            xLeft = Math.min(nextPoint[0], prevX);
            xRight = Math.max(nextPoint[0], prevX);
            minSlope = slope;
            leastSlopedSideWidth = Math.abs(nextPoint[0] - prevX);
            topLeftY = nextPoint[0] < prevX ? nextPoint[1] : prevY;
        }
        float connectionWidth = Math.min(leastSlopedSideWidth, textWidth) / 2.0f;
        return new Triple((Object)Float.valueOf(xLeft), (Object)Float.valueOf(xRight), (Object)Float.valueOf(minSlope * connectionWidth + topLeftY));
    }

    @Override
    @NotNull
    public Sequence<DrawViewNode> children(@NotNull ViewNode.ReadAccess access) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        ViewNode.ReadAccess $this$children_u24lambda_u2d0 = access;
        boolean bl = false;
        return CollectionsKt.asSequence((Iterable)$this$children_u24lambda_u2d0.getDrawChildren(this.getUnfilteredOwner()));
    }
}

