/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.metrics.statistics;

import com.android.tools.idea.layoutinspector.model.ComposeViewNode;
import com.android.tools.idea.layoutinspector.model.RecompositionData;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorCompose;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0006\u0010!\u001a\u00020\u001dJ\u0014\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u0010\u0010&\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010'\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0006\u0010(\u001a\u00020\u001dJ\u0016\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/layoutinspector/metrics/statistics/ComposeStatistics;", "", "()V", "componentTreeClicks", "", "framesWithRecompositionColorBlue", "framesWithRecompositionColorGreen", "framesWithRecompositionColorOrange", "framesWithRecompositionColorPurple", "framesWithRecompositionColorRed", "framesWithRecompositionColorYellow", "framesWithRecompositionCountsOn", "goToSourceFromPropertyValueClicks", "imageClicks", "maxRecompositions", "Lcom/android/tools/idea/layoutinspector/model/RecompositionData;", "recompositionHighlightColor", "getRecompositionHighlightColor", "()I", "setRecompositionHighlightColor", "(I)V", "resetRecompositionCountsClicks", "showRecompositions", "", "getShowRecompositions", "()Z", "setShowRecompositions", "(Z)V", "frameReceived", "", "gotoSourceFromPropertyValue", "view", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "resetRecompositionCountsClick", "save", "dataSupplier", "Lkotlin/Function0;", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorCompose$Builder;", "selectionMadeFromComponentTree", "selectionMadeFromImage", "start", "updateRecompositionStats", "recompositions", "maxHighlight", "", "intellij.android.layout-inspector"})
public final class ComposeStatistics {
    private int imageClicks;
    private int componentTreeClicks;
    private int goToSourceFromPropertyValueClicks;
    @NotNull
    private final RecompositionData maxRecompositions = new RecompositionData(0, 0, 0.0f, 4, null);
    private int resetRecompositionCountsClicks;
    private boolean showRecompositions;
    private int recompositionHighlightColor = 0xFF0000;
    private int framesWithRecompositionCountsOn;
    private int framesWithRecompositionColorRed;
    private int framesWithRecompositionColorBlue;
    private int framesWithRecompositionColorGreen;
    private int framesWithRecompositionColorYellow;
    private int framesWithRecompositionColorPurple;
    private int framesWithRecompositionColorOrange;

    public final boolean getShowRecompositions() {
        return this.showRecompositions;
    }

    public final void setShowRecompositions(boolean bl) {
        this.showRecompositions = bl;
    }

    public final int getRecompositionHighlightColor() {
        return this.recompositionHighlightColor;
    }

    public final void setRecompositionHighlightColor(int n) {
        this.recompositionHighlightColor = n;
    }

    public final void start() {
        this.showRecompositions = false;
        this.recompositionHighlightColor = 0xFF0000;
        this.imageClicks = 0;
        this.componentTreeClicks = 0;
        this.goToSourceFromPropertyValueClicks = 0;
        this.framesWithRecompositionCountsOn = 0;
        this.framesWithRecompositionColorRed = 0;
        this.framesWithRecompositionColorBlue = 0;
        this.framesWithRecompositionColorGreen = 0;
        this.framesWithRecompositionColorYellow = 0;
        this.framesWithRecompositionColorPurple = 0;
        this.framesWithRecompositionColorOrange = 0;
    }

    public final void save(@NotNull Function0<DynamicLayoutInspectorCompose.Builder> dataSupplier) {
        Intrinsics.checkNotNullParameter(dataSupplier, (String)"dataSupplier");
        if (this.imageClicks > 0 || this.componentTreeClicks > 0 || this.goToSourceFromPropertyValueClicks > 0 || !this.maxRecompositions.isEmpty() || this.resetRecompositionCountsClicks > 0 || this.framesWithRecompositionCountsOn > 0) {
            DynamicLayoutInspectorCompose.Builder it = (DynamicLayoutInspectorCompose.Builder)dataSupplier.invoke();
            boolean bl = false;
            it.setKotlinReflectionAvailable(true);
            it.setImageClicks(this.imageClicks);
            it.setComponentTreeClicks(this.componentTreeClicks);
            it.setGoToSourceFromPropertyValueClicks(this.goToSourceFromPropertyValueClicks);
            it.setMaxRecompositionCount(this.maxRecompositions.getCount());
            it.setMaxRecompositionSkips(this.maxRecompositions.getSkips());
            it.setMaxRecompositionHighlight(this.maxRecompositions.getHighlightCount());
            it.setRecompositionResetClicks(this.resetRecompositionCountsClicks);
            it.setFramesWithRecompositionCountsOn(this.framesWithRecompositionCountsOn);
            it.setFramesWithRecompositionColorRed(this.framesWithRecompositionColorRed);
            it.setFramesWithRecompositionColorBlue(this.framesWithRecompositionColorBlue);
            it.setFramesWithRecompositionColorGreen(this.framesWithRecompositionColorGreen);
            it.setFramesWithRecompositionColorYellow(this.framesWithRecompositionColorYellow);
            it.setFramesWithRecompositionColorPurple(this.framesWithRecompositionColorPurple);
            it.setFramesWithRecompositionColorOrange(this.framesWithRecompositionColorOrange);
        }
    }

    public final void selectionMadeFromImage(@Nullable ViewNode view) {
        if (view instanceof ComposeViewNode) {
            int n = this.imageClicks;
            this.imageClicks = n + 1;
        }
    }

    public final void selectionMadeFromComponentTree(@Nullable ViewNode view) {
        if (view instanceof ComposeViewNode) {
            int n = this.componentTreeClicks;
            this.componentTreeClicks = n + 1;
        }
    }

    public final void gotoSourceFromPropertyValue(@Nullable ViewNode view) {
        if (view instanceof ComposeViewNode) {
            int n = this.goToSourceFromPropertyValueClicks;
            this.goToSourceFromPropertyValueClicks = n + 1;
        }
    }

    public final void updateRecompositionStats(@NotNull RecompositionData recompositions, float maxHighlight) {
        Intrinsics.checkNotNullParameter((Object)recompositions, (String)"recompositions");
        this.maxRecompositions.maxOf(recompositions);
        this.maxRecompositions.setHighlightCount(Math.max(this.maxRecompositions.getHighlightCount(), maxHighlight));
    }

    public final void resetRecompositionCountsClick() {
        int n = this.resetRecompositionCountsClicks;
        this.resetRecompositionCountsClicks = n + 1;
    }

    public final void frameReceived() {
        if (!this.showRecompositions) {
            return;
        }
        int n = this.framesWithRecompositionCountsOn;
        this.framesWithRecompositionCountsOn = n + 1;
        switch (this.recompositionHighlightColor) {
            case 0xFF0000: {
                int n2 = this.framesWithRecompositionColorRed;
                this.framesWithRecompositionColorRed = n2 + 1;
                break;
            }
            case 5218019: {
                int n3 = this.framesWithRecompositionColorBlue;
                this.framesWithRecompositionColorBlue = n3 + 1;
                break;
            }
            case 4690757: {
                int n4 = this.framesWithRecompositionColorGreen;
                this.framesWithRecompositionColorGreen = n4 + 1;
                break;
            }
            case 16762477: {
                int n5 = this.framesWithRecompositionColorYellow;
                this.framesWithRecompositionColorYellow = n5 + 1;
                break;
            }
            case 8851604: {
                int n6 = this.framesWithRecompositionColorPurple;
                this.framesWithRecompositionColorPurple = n6 + 1;
                break;
            }
            case 14787382: {
                int n7 = this.framesWithRecompositionColorOrange;
                this.framesWithRecompositionColorOrange = n7 + 1;
            }
        }
    }
}

