/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorMetrics;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientLauncher;
import com.android.tools.idea.layoutinspector.ui.DeviceViewPanel;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/layoutinspector/LayoutInspectorToolWindowManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "deviceViewPanel", "Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel;", "clientLauncher", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanel;Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher;)V", "stopInspectors", "Lkotlin/Function0;", "", "wasWindowVisible", "", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher;Lkotlin/jvm/functions/Function0;Z)V", "stateChanged", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "intellij.android.layout-inspector"})
public final class LayoutInspectorToolWindowManagerListener
implements ToolWindowManagerListener {
    @NotNull
    private final Project project;
    @NotNull
    private final InspectorClientLauncher clientLauncher;
    @NotNull
    private final Function0<Unit> stopInspectors;
    private boolean wasWindowVisible;

    @VisibleForTesting
    public LayoutInspectorToolWindowManagerListener(@NotNull Project project, @NotNull InspectorClientLauncher clientLauncher, @NotNull Function0<Unit> stopInspectors2, boolean wasWindowVisible) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)clientLauncher, (String)"clientLauncher");
        Intrinsics.checkNotNullParameter(stopInspectors2, (String)"stopInspectors");
        this.project = project;
        this.clientLauncher = clientLauncher;
        this.stopInspectors = stopInspectors2;
        this.wasWindowVisible = wasWindowVisible;
    }

    public /* synthetic */ LayoutInspectorToolWindowManagerListener(Project project, InspectorClientLauncher inspectorClientLauncher, Function0 function0, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(project, inspectorClientLauncher, (Function0<Unit>)function0, bl);
    }

    public LayoutInspectorToolWindowManagerListener(@NotNull Project project, @NotNull ToolWindow toolWindow, final @NotNull DeviceViewPanel deviceViewPanel2, @NotNull InspectorClientLauncher clientLauncher) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)deviceViewPanel2, (String)"deviceViewPanel");
        Intrinsics.checkNotNullParameter((Object)clientLauncher, (String)"clientLauncher");
        this(project, clientLauncher, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                deviceViewPanel2.stopInspectors();
            }
        }), toolWindow.isVisible());
    }

    public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
        Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Layout Inspector");
        if (toolWindow == null) {
            return;
        }
        ToolWindow window2 = toolWindow;
        boolean isWindowVisible = window2.isVisible();
        boolean windowVisibilityChanged = isWindowVisible != this.wasWindowVisible;
        this.wasWindowVisible = isWindowVisible;
        if (windowVisibilityChanged) {
            if (isWindowVisible) {
                LayoutInspectorMetrics.INSTANCE.logEvent(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.OPEN);
            } else if (this.clientLauncher.getActiveClient().isConnected()) {
                MessageType messageType = MessageType.INFO;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
                toolWindowManager.notifyByBalloon("Layout Inspector", messageType, "<b>Layout Inspection</b> is running in the background.<br>\nYou can either <a href=\"stop\">stop</a> it, or leave it running and resume your session later.", null, new HyperlinkListener(this){
                    final /* synthetic */ LayoutInspectorToolWindowManagerListener this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                        if (Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                            LayoutInspectorToolWindowManagerListener.access$getStopInspectors$p(this.this$0).invoke();
                        }
                    }
                });
            }
            this.clientLauncher.setEnabled(isWindowVisible);
        }
    }

    public static final /* synthetic */ Function0 access$getStopInspectors$p(LayoutInspectorToolWindowManagerListener $this) {
        return $this.stopInspectors;
    }
}

