/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.layoutinspector.LayoutInspectorLaunchTask;
import com.android.tools.idea.layoutinspector.LayoutInspectorLaunchTaskContributor;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.DebugViewAttributes;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/layoutinspector/LayoutInspectorLaunchTaskContributor;", "Lcom/android/tools/idea/run/AndroidLaunchTaskContributor;", "()V", "model", "", "Lcom/android/ddmlib/IDevice;", "getModel", "(Lcom/android/ddmlib/IDevice;)Ljava/lang/String;", "getTask", "Lcom/android/tools/idea/layoutinspector/LayoutInspectorLaunchTask;", "applicationId", "configuration", "Lcom/android/tools/idea/run/AndroidRunConfigurationBase;", "device", "executor", "Lcom/intellij/execution/Executor;", "intellij.android.layout-inspector"})
public final class LayoutInspectorLaunchTaskContributor
implements AndroidLaunchTaskContributor {
    @Override
    @NotNull
    public LayoutInspectorLaunchTask getTask(@NotNull String applicationId2, @NotNull AndroidRunConfigurationBase configuration, @NotNull IDevice device2, @NotNull Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        return new LayoutInspectorLaunchTask(configuration, applicationId2, this){
            final /* synthetic */ AndroidRunConfigurationBase $configuration;
            final /* synthetic */ String $applicationId;
            final /* synthetic */ LayoutInspectorLaunchTaskContributor this$0;
            {
                this.$configuration = $configuration;
                this.$applicationId = $applicationId;
                this.this$0 = $receiver;
            }

            @NotNull
            public String getId() {
                return "Layout Inspector";
            }

            @NotNull
            public String getDescription() {
                return "Launching Layout Inspector";
            }

            public int getDuration() {
                return 2;
            }

            @NotNull
            public LaunchResult run(@NotNull LaunchContext launchContext) {
                Intrinsics.checkNotNullParameter((Object)launchContext, (String)"launchContext");
                if (this.$configuration.INSPECTION_WITHOUT_ACTIVITY_RESTART && launchContext.getDevice().getVersion().getApiLevel() >= 29) {
                    Project project = this.$configuration.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
                    this.enableDebugViewAttributes(project, this.$applicationId, launchContext);
                }
                LaunchResult launchResult = LaunchResult.success();
                Intrinsics.checkNotNullExpressionValue((Object)launchResult, (String)"success()");
                return launchResult;
            }

            private final void enableDebugViewAttributes(Project project, String packageName2, LaunchContext launchContext) {
                IDevice iDevice = launchContext.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"launchContext.device");
                IDevice device2 = iDevice;
                DeviceDescriptor descriptor2 = new DeviceDescriptor(this.this$0, device2){
                    @NotNull
                    private final String manufacturer;
                    @NotNull
                    private final String model;
                    @NotNull
                    private final String serial;
                    private final boolean isEmulator;
                    private final int apiLevel;
                    @NotNull
                    private final String version;
                    @NotNull
                    private final String codename;
                    {
                        this.manufacturer = "";
                        this.model = LayoutInspectorLaunchTaskContributor.access$getModel($receiver, $device);
                        String string = $device.getSerialNumber();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.serialNumber");
                        this.serial = string;
                        this.isEmulator = $device.isEmulator();
                        this.apiLevel = $device.getVersion().getApiLevel();
                        this.version = "";
                        this.codename = "";
                    }

                    @NotNull
                    public String getManufacturer() {
                        return this.manufacturer;
                    }

                    @NotNull
                    public String getModel() {
                        return this.model;
                    }

                    @NotNull
                    public String getSerial() {
                        return this.serial;
                    }

                    public boolean isEmulator() {
                        return this.isEmulator;
                    }

                    public int getApiLevel() {
                        return this.apiLevel;
                    }

                    @NotNull
                    public String getVersion() {
                        return this.version;
                    }

                    @NotNull
                    public String getCodename() {
                        return this.codename;
                    }
                };
                ProcessDescriptor process2 = new ProcessDescriptor(descriptor2, packageName2){
                    @NotNull
                    private final DeviceDescriptor device;
                    @NotNull
                    private final String abiCpuArch;
                    @NotNull
                    private final String name;
                    @NotNull
                    private final String packageName;
                    private final boolean isRunning;
                    private final int pid;
                    private final long streamId;
                    {
                        this.device = $descriptor;
                        this.abiCpuArch = "";
                        this.name = $packageName;
                        this.packageName = $packageName;
                        this.isRunning = true;
                    }

                    @NotNull
                    public DeviceDescriptor getDevice() {
                        return this.device;
                    }

                    @NotNull
                    public String getAbiCpuArch() {
                        return this.abiCpuArch;
                    }

                    @NotNull
                    public String getName() {
                        return this.name;
                    }

                    @NotNull
                    public String getPackageName() {
                        return this.packageName;
                    }

                    public boolean isRunning() {
                        return this.isRunning;
                    }

                    public int getPid() {
                        return this.pid;
                    }

                    public long getStreamId() {
                        return this.streamId;
                    }
                };
                DebugViewAttributes debugViewAttributes = DebugViewAttributes.Companion.getInstance();
                if (debugViewAttributes.set(project, process2)) {
                    launchContext.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(launchContext, debugViewAttributes, project, process2){
                        final /* synthetic */ LaunchContext $launchContext;
                        final /* synthetic */ DebugViewAttributes $debugViewAttributes;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ getTask.enableDebugViewAttributes.process.1 $process;
                        {
                            this.$launchContext = $launchContext;
                            this.$debugViewAttributes = $debugViewAttributes;
                            this.$project = $project;
                            this.$process = $process;
                        }

                        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            if (!Intrinsics.areEqual((Object)event.getSource(), (Object)this.$launchContext.getLaunchStatus().getProcessHandler())) {
                                this.$launchContext.getLaunchStatus().getProcessHandler().addProcessListener((ProcessListener)this);
                            } else if (!((Boolean)this.$debugViewAttributes.getUsePerDeviceSettings().invoke()).booleanValue()) {
                                this.$debugViewAttributes.clear(this.$project, this.$process);
                            }
                        }
                    });
                }
            }
        };
    }

    private final String getModel(IDevice $this$model) {
        String string;
        String string2;
        if ($this$model.isEmulator()) {
            String string3;
            String it = string3 = $this$model.getAvdName();
            boolean bl = false;
            CharSequence charSequence = it;
            string2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string3 : null;
        } else {
            String string4 = $this$model.getProperty("ro.product.model");
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                string2 = StringUtil.capitalizeWords((String)it, (boolean)true);
            } else {
                string2 = string = null;
            }
        }
        if (string2 == null) {
            string = "Unknown";
        }
        return string;
    }

    public static final /* synthetic */ String access$getModel(LayoutInspectorLaunchTaskContributor $this, IDevice $receiver) {
        return $this.getModel($receiver);
    }
}

