/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.tools.idea.concurrency.AndroidExecutors;
import com.android.tools.idea.layoutinspector.LayoutInspectorToolWindowFactoryKt;
import com.android.tools.idea.layoutinspector.common.MostRecentExecutor;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.pipeline.ComponentTreeData;
import com.android.tools.idea.layoutinspector.pipeline.DisconnectedClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientLauncher;
import com.android.tools.idea.layoutinspector.pipeline.TreeLoader;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorErrorInfo;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rB7\b\u0002\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0001H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0013\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006("}, d2={"Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "", "launcher", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher;", "layoutInspectorModel", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "treeSettings", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "executor", "Ljava/util/concurrent/Executor;", "(Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLauncher;Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;Ljava/util/concurrent/Executor;)V", "client", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "(Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;)V", "currentClientAccessor", "Lkotlin/Function0;", "isSnapshot", "", "(Lkotlin/jvm/functions/Function0;Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;ZLjava/util/concurrent/Executor;)V", "currentClient", "getCurrentClient", "()Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "()Z", "latestLoadTime", "Ljava/util/concurrent/atomic/AtomicLong;", "getLayoutInspectorModel", "()Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "recentExecutor", "Lcom/android/tools/idea/layoutinspector/common/MostRecentExecutor;", "getTreeSettings", "()Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "clientChanged", "", "loadComponentTree", "event", "logError", "error", "", "updateConnection", "Companion", "intellij.android.layout-inspector"})
public final class LayoutInspector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<InspectorClient> currentClientAccessor;
    @NotNull
    private final InspectorModel layoutInspectorModel;
    @NotNull
    private final TreeSettings treeSettings;
    private final boolean isSnapshot;
    @NotNull
    private final Executor executor;
    @NotNull
    private final AtomicLong latestLoadTime;
    @NotNull
    private final MostRecentExecutor recentExecutor;

    private LayoutInspector(Function0<? extends InspectorClient> currentClientAccessor, InspectorModel layoutInspectorModel, TreeSettings treeSettings2, boolean isSnapshot, Executor executor2) {
        this.currentClientAccessor = currentClientAccessor;
        this.layoutInspectorModel = layoutInspectorModel;
        this.treeSettings = treeSettings2;
        this.isSnapshot = isSnapshot;
        this.executor = executor2;
        this.latestLoadTime = new AtomicLong(-1L);
        this.recentExecutor = new MostRecentExecutor(this.executor);
    }

    /* synthetic */ LayoutInspector(Function0 function0, InspectorModel inspectorModel, TreeSettings treeSettings2, boolean bl, Executor executor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            executor2 = AndroidExecutors.Companion.getInstance().getWorkerThreadExecutor();
        }
        this((Function0<? extends InspectorClient>)function0, inspectorModel, treeSettings2, bl, executor2);
    }

    @NotNull
    public final InspectorModel getLayoutInspectorModel() {
        return this.layoutInspectorModel;
    }

    @NotNull
    public final TreeSettings getTreeSettings() {
        return this.treeSettings;
    }

    public final boolean isSnapshot() {
        return this.isSnapshot;
    }

    @NotNull
    public final InspectorClient getCurrentClient() {
        return (InspectorClient)this.currentClientAccessor.invoke();
    }

    public LayoutInspector(final @NotNull InspectorClientLauncher launcher, @NotNull InspectorModel layoutInspectorModel, @NotNull TreeSettings treeSettings2, @NotNull Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)layoutInspectorModel, (String)"layoutInspectorModel");
        Intrinsics.checkNotNullParameter((Object)treeSettings2, (String)"treeSettings");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        this((Function0<? extends InspectorClient>)((Function0)new Function0<InspectorClient>(){

            @NotNull
            public final InspectorClient invoke() {
                return launcher.getActiveClient();
            }
        }), layoutInspectorModel, treeSettings2, false, executor2);
        launcher.addClientChangedListener((Function1<? super InspectorClient, Unit>)((Function1)new Function1<InspectorClient, Unit>((Object)this){

            public final void invoke(@NotNull InspectorClient p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LayoutInspector)this.receiver).clientChanged(p0);
            }
        }));
    }

    public /* synthetic */ LayoutInspector(InspectorClientLauncher inspectorClientLauncher, InspectorModel inspectorModel, TreeSettings treeSettings2, Executor executor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            executor2 = AndroidExecutors.Companion.getInstance().getWorkerThreadExecutor();
        }
        this(inspectorClientLauncher, inspectorModel, treeSettings2, executor2);
    }

    public LayoutInspector(final @NotNull InspectorClient client2, @NotNull InspectorModel layoutInspectorModel, @NotNull TreeSettings treeSettings2) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)layoutInspectorModel, (String)"layoutInspectorModel");
        Intrinsics.checkNotNullParameter((Object)treeSettings2, (String)"treeSettings");
        this((Function0)new Function0<InspectorClient>(){

            @NotNull
            public final InspectorClient invoke() {
                return client2;
            }
        }, layoutInspectorModel, treeSettings2, true, null, 16, null);
        this.clientChanged(client2);
    }

    private final void clientChanged(InspectorClient client2) {
        if (client2 != DisconnectedClient.INSTANCE) {
            client2.registerErrorCallback((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

                public final void invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    LayoutInspector.access$logError((LayoutInspector)this.receiver, p0);
                }
            }));
            client2.registerTreeEventCallback((Function1<Object, Unit>)((Function1)new Function1<Object, Unit>((Object)this){

                public final void invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    LayoutInspector.access$loadComponentTree((LayoutInspector)this.receiver, p0);
                }
            }));
            client2.registerStateCallback((Function1<? super InspectorClient.State, Unit>)((Function1)new Function1<InspectorClient.State, Unit>(this, client2){
                final /* synthetic */ LayoutInspector this$0;
                final /* synthetic */ InspectorClient $client;
                {
                    this.this$0 = $receiver;
                    this.$client = $client;
                    super(1);
                }

                public final void invoke(@NotNull InspectorClient.State state2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
                    if (state2 == InspectorClient.State.CONNECTED) {
                        LayoutInspector.access$updateConnection(this.this$0, this.$client);
                    }
                }
            }));
            client2.registerConnectionTimeoutCallback((Function1<? super DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit>)((Function1)new Function1<DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit>(this){
                final /* synthetic */ LayoutInspector this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull DynamicLayoutInspectorErrorInfo.AttachErrorState state2) {
                    Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
                    this.this$0.getLayoutInspectorModel().fireAttachStateEvent(state2);
                }
            }));
            client2.getStats().start();
        } else {
            this.layoutInspectorModel.updateConnection(DisconnectedClient.INSTANCE);
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ LayoutInspector this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void run() {
                    if (this.this$0.getCurrentClient() == DisconnectedClient.INSTANCE) {
                        InspectorModel.update$default(this.this$0.getLayoutInspectorModel(), null, CollectionsKt.emptyList(), 0, null, 8, null);
                    }
                }
            });
        }
    }

    private final void updateConnection(InspectorClient client2) {
        this.layoutInspectorModel.updateConnection(client2);
        client2.getStats().setCurrentModeIsLive(client2.isCapturing());
        client2.getStats().setHideSystemNodes(this.treeSettings.getHideSystemNodes());
        client2.getStats().setShowRecompositions(this.treeSettings.getShowRecompositions());
    }

    private final void loadComponentTree(Object event) {
        this.recentExecutor.execute(new Runnable(this, event){
            final /* synthetic */ LayoutInspector this$0;
            final /* synthetic */ Object $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                long time2 = System.currentTimeMillis();
                TreeLoader treeLoader2 = this.this$0.getCurrentClient().getTreeLoader();
                List<?> allIds = treeLoader2.getAllWindowIds(this.$event);
                ComponentTreeData componentTreeData = treeLoader2.loadComponentTree(this.$event, this.this$0.getLayoutInspectorModel().getResourceLookup(), this.this$0.getCurrentClient().getProcess());
                if (componentTreeData == null) {
                    return;
                }
                ComponentTreeData data2 = componentTreeData;
                this.this$0.getCurrentClient().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.PARSED_COMPONENT_TREE);
                this.this$0.getCurrentClient().addDynamicCapabilities(data2.getDynamicCapabilities());
                if (allIds != null) {
                    AtomicLong atomicLong = LayoutInspector.access$getLatestLoadTime$p(this.this$0);
                    LayoutInspector layoutInspector = this.this$0;
                    AtomicLong atomicLong2 = atomicLong;
                    synchronized (atomicLong2) {
                        boolean bl = false;
                        if (LayoutInspector.access$getLatestLoadTime$p(layoutInspector).get() > time2) {
                            return;
                        }
                        LayoutInspector.access$getLatestLoadTime$p(layoutInspector).set(time2);
                        if (layoutInspector.getCurrentClient().getState().compareTo((Enum)InspectorClient.State.CONNECTED) <= 0) {
                            layoutInspector.getLayoutInspectorModel().update(data2.getWindow(), allIds, data2.getGeneration(), (Function0<Unit>)((Function0)new Function0<Unit>(layoutInspector){
                                final /* synthetic */ LayoutInspector this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.getCurrentClient().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.MODEL_UPDATED);
                                }
                            }));
                        }
                        if (layoutInspector.getCurrentClient().getState().compareTo((Enum)InspectorClient.State.CONNECTED) > 0) {
                            layoutInspector.getLayoutInspectorModel().clear();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        });
    }

    private final void logError(String error) {
        block0: {
            Logger.getInstance((String)LayoutInspector.class.getCanonicalName()).warn(error);
            InspectorBannerService inspectorBannerService = InspectorBannerService.Companion.getInstance(this.layoutInspectorModel.getProject());
            if (inspectorBannerService == null) break block0;
            InspectorBannerService.setNotification$default(inspectorBannerService, error, null, 2, null);
        }
    }

    public static final /* synthetic */ void access$logError(LayoutInspector $this, String error) {
        $this.logError(error);
    }

    public static final /* synthetic */ void access$loadComponentTree(LayoutInspector $this, Object event) {
        $this.loadComponentTree(event);
    }

    public static final /* synthetic */ void access$updateConnection(LayoutInspector $this, InspectorClient client2) {
        $this.updateConnection(client2);
    }

    public static final /* synthetic */ AtomicLong access$getLatestLoadTime$p(LayoutInspector $this) {
        return $this.latestLoadTime;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/layoutinspector/LayoutInspector$Companion;", "", "()V", "get", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "component", "Ljava/awt/Component;", "intellij.android.layout-inspector"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LayoutInspector get(@NotNull Component component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            return (LayoutInspector)DataManager.getInstance().getDataContext(component2).getData(LayoutInspectorToolWindowFactoryKt.getLAYOUT_INSPECTOR_DATA_KEY());
        }

        @Nullable
        public final LayoutInspector get(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return (LayoutInspector)event.getData(LayoutInspectorToolWindowFactoryKt.getLAYOUT_INSPECTOR_DATA_KEY());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

