/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.model;

import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.android.tools.idea.lang.databinding.model.PsiModelMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u001f\u001a\u00020\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\b\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/lang/databinding/model/PsiModelMethod;", "Lcom/android/tools/idea/lang/databinding/model/PsiModelMember;", "containingClass", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "(Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;Lcom/intellij/psi/PsiMethod;)V", "getContainingClass", "()Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "isAbstract", "", "()Z", "isProtected", "isPublic", "isStatic", "isVarArgs", "isVoid", "name", "", "getName", "()Ljava/lang/String;", "parameterTypes", "", "getParameterTypes", "()[Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "parameterTypes$delegate", "Lkotlin/Lazy;", "getPsiMethod", "()Lcom/intellij/psi/PsiMethod;", "returnType", "getReturnType", "acceptsArguments", "args", "", "Companion", "intellij.android.lang-databinding"})
public final class PsiModelMethod
implements PsiModelMember {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiModelClass containingClass;
    @NotNull
    private final PsiMethod psiMethod;
    @NotNull
    private final Lazy parameterTypes$delegate;
    private final boolean isVoid;
    private final boolean isPublic;
    private final boolean isProtected;
    private final boolean isStatic;
    private final boolean isAbstract;
    private final boolean isVarArgs;

    public PsiModelMethod(@NotNull PsiModelClass containingClass, @NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        this.containingClass = containingClass;
        this.psiMethod = psiMethod;
        this.parameterTypes$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<PsiModelClass[]>(this){
            final /* synthetic */ PsiModelMethod this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PsiModelClass[] invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                PsiParameter[] psiParameterArray = this.this$0.getPsiMethod().getParameterList().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"psiMethod.parameterList.parameters");
                Object[] objectArray = psiParameterArray;
                PsiModelMethod psiModelMethod = this.this$0;
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PsiParameter psiParameter = (PsiParameter)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    PsiType psiType = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"it.type");
                    collection2.add(new PsiModelClass(psiType, psiModelMethod.getContainingClass().getMode()));
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PsiModelClass[] psiModelClassArray = thisCollection$iv.toArray(new PsiModelClass[0]);
                if (psiModelClassArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                return psiModelClassArray;
            }
        }));
        this.isVoid = Intrinsics.areEqual((Object)PsiType.VOID, (Object)this.psiMethod.getReturnType());
        this.isPublic = this.psiMethod.hasModifierProperty("public");
        this.isProtected = this.psiMethod.hasModifierProperty("protected");
        this.isStatic = this.psiMethod.hasModifierProperty("static");
        this.isAbstract = this.psiMethod.hasModifierProperty("abstract");
        this.isVarArgs = this.psiMethod.isVarArgs();
    }

    @Override
    @NotNull
    public PsiModelClass getContainingClass() {
        return this.containingClass;
    }

    @NotNull
    public final PsiMethod getPsiMethod() {
        return this.psiMethod;
    }

    @NotNull
    public final PsiModelClass[] getParameterTypes() {
        Lazy lazy = this.parameterTypes$delegate;
        return (PsiModelClass[])lazy.getValue();
    }

    @NotNull
    public final String getName() {
        String string = this.psiMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiMethod.name");
        return string;
    }

    @Nullable
    public final PsiModelClass getReturnType() {
        PsiModelClass psiModelClass;
        PsiType psiType = this.psiMethod.getReturnType();
        if (psiType != null) {
            PsiType it = psiType;
            boolean bl = false;
            PsiType psiType2 = this.getContainingClass().getSubstitutor().substitute(it);
            Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"containingClass.substitutor.substitute(it)");
            psiModelClass = new PsiModelClass(psiType2, this.getContainingClass().getMode());
        } else {
            psiModelClass = null;
        }
        return psiModelClass;
    }

    public final boolean isVoid() {
        return this.isVoid;
    }

    public final boolean isPublic() {
        return this.isPublic;
    }

    public final boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    public final boolean isVarArgs() {
        return this.isVarArgs;
    }

    public final boolean acceptsArguments(@NotNull List<PsiModelClass> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (!this.isVarArgs && args.size() != this.getParameterTypes().length || this.isVarArgs && args.size() < this.getParameterTypes().length - 1) {
            return false;
        }
        boolean parametersMatch = true;
        for (int i = 0; i < args.size() && parametersMatch; ++i) {
            PsiModelClass parameterType = this.getParameterTypes()[RangesKt.coerceAtMost((int)i, (int)ArraysKt.getLastIndex((Object[])this.getParameterTypes()))];
            PsiModelClass arg = args.get(i).getUnwrapped();
            if (parameterType.isIncomplete()) {
                parameterType = parameterType.erasure();
            }
            if (parameterType.isAssignableFrom(arg)) continue;
            parametersMatch = false;
        }
        return parametersMatch;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/lang/databinding/model/PsiModelMethod$Companion;", "", "()V", "betterMatchWithArguments", "Lcom/android/tools/idea/lang/databinding/model/PsiModelMethod;", "args", "", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "thisMethod", "thatMethod", "intellij.android.lang-databinding"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PsiModelMethod betterMatchWithArguments(@NotNull List<PsiModelClass> args, @NotNull PsiModelMethod thisMethod, @NotNull PsiModelMethod thatMethod) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)thisMethod, (String)"thisMethod");
            Intrinsics.checkNotNullParameter((Object)thatMethod, (String)"thatMethod");
            int n = args.size();
            for (int i = 0; i < n; ++i) {
                boolean thatStricterOrEqual;
                PsiModelClass thatParameterType;
                PsiModelClass arg = args.get(i).getUnwrapped();
                PsiModelClass thisParameterType = thisMethod.getParameterTypes()[Integer.min(i, thisMethod.getParameterTypes().length)];
                if (Intrinsics.areEqual((Object)thisParameterType, (Object)(thatParameterType = thatMethod.getParameterTypes()[Integer.min(i, thatMethod.getParameterTypes().length)]))) continue;
                if (Intrinsics.areEqual((Object)thisParameterType, (Object)arg)) {
                    return thisMethod;
                }
                if (Intrinsics.areEqual((Object)thatParameterType, (Object)arg)) {
                    return thatMethod;
                }
                boolean thisStricterOrEqual = thatParameterType.isAssignableFrom(thisParameterType);
                if (thisStricterOrEqual == (thatStricterOrEqual = thisParameterType.isAssignableFrom(thatParameterType))) continue;
                return thisStricterOrEqual ? thisMethod : thatMethod;
            }
            return thisMethod;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

