/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.completion;

import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.lang.databinding.DataBindingCompletionSupport;
import com.android.tools.idea.lang.databinding.completion.DataBindingCompletionSupportImpl;
import com.android.tools.idea.lang.databinding.completion.DataBindingCompletionUtilKt;
import com.android.tools.idea.lang.databinding.config.DbFileType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Query;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.Import;
import org.jetbrains.android.dom.layout.Layout;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0003\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/lang/databinding/completion/DataBindingCompletionSupportImpl;", "Lcom/android/tools/idea/lang/databinding/DataBindingCompletionSupport;", "()V", "addCompletions", "", "params", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "resultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "fillAliases", "packagePrefix", "", "originalPosition", "Lcom/intellij/psi/PsiElement;", "module", "Lcom/intellij/openapi/module/Module;", "originalParent", "fillClassNames", "getClassReferenceElement", "Lcom/intellij/codeInsight/completion/JavaPsiClassReferenceElement;", "alias", "referenceClass", "Lcom/intellij/psi/PsiClass;", "getRealContainingFile", "Lcom/intellij/psi/PsiFile;", "file", "Companion", "intellij.android.lang-databinding"})
public final class DataBindingCompletionSupportImpl
implements DataBindingCompletionSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void addCompletions(@NotNull CompletionParameters params2, @NotNull CompletionResultSet resultSet) {
        PsiElement originalPosition;
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        PsiElement psiElement = originalPosition = params2.getOriginalPosition();
        Object object = psiElement != null ? psiElement.getParent() : null;
        if (object == null) {
            return;
        }
        PsiElement originalParent = object;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalParent);
        if (module2 == null) {
            return;
        }
        Module module3 = module2;
        if (this.getRealContainingFile(originalParent.getContainingFile()) == null) {
            return;
        }
        String packagePrefix = DataBindingCompletionSupportImpl.Companion.getPackagePrefix(originalParent, params2.getOffset());
        this.fillAliases(resultSet, packagePrefix, originalPosition, module3, originalParent);
        this.fillClassNames(resultSet, packagePrefix, module3);
    }

    /*
     * WARNING - void declaration
     */
    private final void fillAliases(CompletionResultSet resultSet, String packagePrefix, PsiElement originalPosition, Module module2, PsiElement originalParent) {
        PsiFile containingFile = this.getRealContainingFile(originalParent.getContainingFile());
        if (!(containingFile instanceof XmlFile)) {
            return;
        }
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Project project2 = project;
        DomManager domManager = DomManager.getDomManager((Project)project2);
        Class[] classArray = new Class[]{PsiFile.class};
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, XmlTag.class, (boolean)false, (Class[])classArray);
        if (domManager.getDomElement(tag) instanceof Import) {
            return;
        }
        DomFileElement domFileElement = domManager.getFileElement((XmlFile)containingFile, Layout.class);
        if (domFileElement == null) {
            return;
        }
        DomFileElement file2 = domFileElement;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        GlobalSearchScope moduleScope = ProjectSystemUtil.getModuleSystem(module2).getResolveScope(ScopeType.MAIN);
        for (Data data2 : ((Layout)file2.getRootElement()).getDataElements()) {
            void $this$forEach$iv;
            String type;
            String alias;
            Object v4;
            Object element$iv2;
            PsiClass aClass;
            Import import_2;
            block8: {
                if (((CharSequence)packagePrefix).length() == 0) {
                    for (Import import_2 : data2.getImports()) {
                        String alias2;
                        XmlAttributeValue type2;
                        if (DataBindingUtil.getAlias(import_2) == null || import_2.getType().getXmlAttributeValue() == null) continue;
                        String string = type2.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.value");
                        String typeValue = StringsKt.replace$default((String)string, (char)'$', (char)'.', (boolean)false, (int)4, null);
                        aClass = facade.findClass(typeValue, moduleScope);
                        if (aClass == null) continue;
                        resultSet.addElement((LookupElement)this.getClassReferenceElement(alias2, aClass));
                    }
                    continue;
                }
                String possibleAlias = StringsKt.substringBefore$default((String)packagePrefix, (char)'.', null, (int)2, null);
                List<Import> list2 = data2.getImports();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"data.imports");
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Import import_3 = (Import)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)DataBindingUtil.getAlias(import_3), (Object)possibleAlias)) continue;
                    v4 = element$iv2;
                    break block8;
                }
                v4 = null;
            }
            if ((Import)v4 == null || import_2.getType().getStringValue() == null) continue;
            Intrinsics.checkNotNull((Object)DataBindingUtil.getAlias(import_2));
            String fqcn = StringsKt.replaceFirst$default((String)packagePrefix, (String)alias, (String)type, (boolean)false, (int)4, null);
            PsiClass psiClass = facade.findClass(fqcn, moduleScope);
            if (psiClass == null) continue;
            aClass = psiClass;
            PsiClass[] psiClassArray = aClass.getInnerClasses();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"aClass.innerClasses");
            element$iv2 = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])psiClassArray), (Function1)fillAliases.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                PsiClass innerClass = (PsiClass)element$iv3;
                boolean bl = false;
                String string = innerClass.getName();
                Intrinsics.checkNotNull((Object)string);
                Intrinsics.checkNotNullExpressionValue((Object)innerClass, (String)"innerClass");
                resultSet.addElement((LookupElement)this.getClassReferenceElement(string, innerClass));
            }
        }
    }

    private final void fillClassNames(CompletionResultSet resultSet, String packagePrefix, Module module2) {
        block7: {
            CharSequence $this$forEach$iv;
            GlobalSearchScope moduleScope;
            PsiPackage rootPackage;
            Project project;
            block6: {
                Project project2 = module2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
                project = project2;
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
                rootPackage = javaPsiFacade.findPackage(packagePrefix);
                moduleScope = ProjectSystemUtil.getModuleSystem(module2).getResolveScope(ScopeType.MAIN);
                if (rootPackage != null) break block6;
                PsiClass outerClass = javaPsiFacade.findClass(packagePrefix, moduleScope);
                if (outerClass == null) break block7;
                PsiClass[] psiClassArray = outerClass.getInnerClasses();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"outerClass.innerClasses");
                for (PsiClass innerClass : psiClassArray) {
                    resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement(innerClass));
                }
                break block7;
            }
            PsiPackage[] psiPackageArray = rootPackage.getSubPackages(moduleScope);
            Intrinsics.checkNotNullExpressionValue((Object)psiPackageArray, (String)"rootPackage.getSubPackages(moduleScope)");
            Sequence outerClass = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])psiPackageArray), (Function1)((Function1)new Function1<PsiPackage, Boolean>(moduleScope){
                final /* synthetic */ GlobalSearchScope $moduleScope;
                {
                    this.$moduleScope = $moduleScope;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(PsiPackage pkg) {
                    boolean bl;
                    PsiPackage[] psiPackageArray = pkg.getSubPackages(this.$moduleScope);
                    Intrinsics.checkNotNullExpressionValue((Object)psiPackageArray, (String)"pkg.getSubPackages(moduleScope)");
                    if (!(!(((Object[])psiPackageArray).length == 0))) {
                        PsiClass[] psiClassArray = pkg.getClasses(this.$moduleScope);
                        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"pkg.getClasses(moduleScope)");
                        if (!(!(((Object[])psiClassArray).length == 0))) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            })), (Function1)fillClassNames.2.INSTANCE);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                PsiPackage pkg = (PsiPackage)element$iv;
                boolean bl = false;
                LookupElementBuilder lookupElementBuilder = LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)pkg));
                Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"createWithIcon(pkg)");
                TailType tailType = TailType.DOT;
                Intrinsics.checkNotNullExpressionValue((Object)tailType, (String)"DOT");
                resultSet.addElement((LookupElement)DataBindingCompletionUtilKt.withTypeDecorator(lookupElementBuilder, tailType));
            }
            $this$forEach$iv = rootPackage.getName();
            if ($this$forEach$iv == null || $this$forEach$iv.length() == 0) {
                Query query = AllClassesSearch.search((SearchScope)((SearchScope)moduleScope), (Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(moduleScope, project)");
                Query query2 = query;
                Iterable $this$forEach$iv2 = (Iterable)query2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    PsiClass psiClass = (PsiClass)element$iv;
                    boolean bl = false;
                    resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement(psiClass));
                }
            } else {
                PsiClass[] psiClassArray = rootPackage.getClasses(moduleScope);
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"rootPackage.getClasses(moduleScope)");
                for (PsiClass psiClass : psiClassArray) {
                    resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement(psiClass));
                }
            }
        }
    }

    @Contract(value="!null -> !null; null -> null")
    private final PsiFile getRealContainingFile(PsiFile file2) {
        PsiFile psiFile = file2;
        if (Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getFileElementType() : null), (Object)((Object)DbFileType.INSTANCE))) {
            PsiFile psiFile2 = file2;
            return psiFile2 != null && (psiFile2 = psiFile2.getContext()) != null ? psiFile2.getContainingFile() : null;
        }
        return file2;
    }

    private final JavaPsiClassReferenceElement getClassReferenceElement(String alias, PsiClass referenceClass) {
        JavaPsiClassReferenceElement element2 = new JavaPsiClassReferenceElement(referenceClass);
        element2.setForcedPresentableName(alias);
        element2.setInsertHandler((InsertHandler)getClassReferenceElement.1.INSTANCE);
        return element2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/lang/databinding/completion/DataBindingCompletionSupportImpl$Companion;", "", "()V", "getPackagePrefix", "", "context", "Lcom/intellij/psi/PsiElement;", "offset", "", "text", "", "intellij.android.lang-databinding"})
    public static final class Companion {
        private Companion() {
        }

        private final String getPackagePrefix(PsiElement context2, int offset) {
            CharSequence charSequence = context2.getContainingFile().getViewProvider().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"context.containingFile.viewProvider.contents");
            return this.getPackagePrefix(charSequence, offset);
        }

        @VisibleForTesting
        @NotNull
        public final String getPackagePrefix(@NotNull CharSequence text2, int offset) {
            String string;
            String startToOffset;
            int lastPeriodIndex;
            int startIndex;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            for (startIndex = offset; startIndex > 0; --startIndex) {
                char c = text2.charAt(startIndex - 1);
                boolean bl = false;
                if (!(Character.isJavaIdentifierPart(c) || c == '.')) break;
            }
            if ((lastPeriodIndex = StringsKt.lastIndexOf$default((CharSequence)(startToOffset = ((Object)text2.subSequence(startIndex, offset)).toString()), (char)'.', (int)0, (boolean)false, (int)6, null)) > 0) {
                String string2 = startToOffset.substring(0, lastPeriodIndex);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string = "";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

