/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.agsl;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.lang.agsl.AgslLanguage;
import com.android.tools.idea.lang.agsl.psi.AgslGlslIdentifier;
import com.android.tools.idea.lang.agsl.psi.AgslReservedKeyword;
import com.android.tools.idea.lang.agsl.psi.AgslUnsupportedKeyword;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/lang/agsl/AgslAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.android.lang"})
public final class AgslAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!((Boolean)StudioFlags.AGSL_LANGUAGE_SUPPORT.get()).booleanValue()) {
            return;
        }
        PsiElement psiElement = element2;
        if (psiElement instanceof AgslUnsupportedKeyword) {
            holder.newAnnotation(HighlightSeverity.ERROR, "`" + ((AgslUnsupportedKeyword)element2).getText() + "` is not allowed in " + AgslLanguage.Companion.getPRIVATE_AGSL_LANGUAGE().getDisplayName()).create();
        } else if (psiElement instanceof AgslReservedKeyword) {
            holder.newAnnotation(HighlightSeverity.ERROR, "`" + ((AgslReservedKeyword)element2).getText() + "` is a reserved future keyword").create();
        } else if (psiElement instanceof AgslGlslIdentifier) {
            holder.newAnnotation(HighlightSeverity.ERROR, "GLSL predefined variables (`gl_*`) are not allowed in " + AgslLanguage.Companion.getPRIVATE_AGSL_LANGUAGE().getDisplayName()).create();
        }
    }
}

