/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instrumentation.threading;

import com.android.tools.idea.instrumentation.threading.ThreadingCheckerHookImpl;
import com.android.tools.idea.instrumentation.threading.ThreadingViolationNotifier;
import com.android.tools.idea.instrumentation.threading.ThreadingViolationNotifierImpl;
import com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerHook;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/instrumentation/threading/ThreadingCheckerHookImpl;", "Lcom/android/tools/instrumentation/threading/agent/callback/ThreadingCheckerHook;", "threadingViolationNotifier", "Lcom/android/tools/idea/instrumentation/threading/ThreadingViolationNotifier;", "(Lcom/android/tools/idea/instrumentation/threading/ThreadingViolationNotifier;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "threadingViolations", "Ljava/util/concurrent/ConcurrentMap;", "", "Ljava/util/concurrent/atomic/AtomicLong;", "getThreadingViolations$annotations", "()V", "getThreadingViolations", "()Ljava/util/concurrent/ConcurrentMap;", "recordViolation", "", "warningMessage", "shouldLogErrors", "", "shouldSuppressNotifications", "verifyOnUiThread", "verifyOnWorkerThread", "intellij.android.threading-checker"})
public final class ThreadingCheckerHookImpl
implements ThreadingCheckerHook {
    @NotNull
    private final ThreadingViolationNotifier threadingViolationNotifier;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentMap<String, AtomicLong> threadingViolations;

    public ThreadingCheckerHookImpl(@NotNull ThreadingViolationNotifier threadingViolationNotifier) {
        Intrinsics.checkNotNullParameter((Object)threadingViolationNotifier, (String)"threadingViolationNotifier");
        this.threadingViolationNotifier = threadingViolationNotifier;
        ThreadingCheckerHookImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(ThreadingCheckerHookImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        this.logger = logger2;
        this.threadingViolations = new ConcurrentHashMap();
    }

    public /* synthetic */ ThreadingCheckerHookImpl(ThreadingViolationNotifier threadingViolationNotifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            threadingViolationNotifier = new ThreadingViolationNotifierImpl();
        }
        this(threadingViolationNotifier);
    }

    @NotNull
    public final ConcurrentMap<String, AtomicLong> getThreadingViolations() {
        return this.threadingViolations;
    }

    @VisibleForTesting
    public static /* synthetic */ void getThreadingViolations$annotations() {
    }

    public void verifyOnUiThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.recordViolation("Threading violation: methods annotated with @UiThread should be called on the UI thread");
    }

    public void verifyOnWorkerThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.recordViolation("Threading violation: methods annotated with @WorkerThread should not be called on the UI thread");
    }

    private final void recordViolation(String warningMessage) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int annotatedMethodIndex = 4;
        String methodSignature = stackTrace[annotatedMethodIndex].getClassName() + "#" + stackTrace[annotatedMethodIndex].getMethodName();
        long violationCount2 = this.threadingViolations.computeIfAbsent(methodSignature, recordViolation.violationCount.1.INSTANCE).incrementAndGet();
        String loggedStackTrace2 = Stream.of(Arrays.copyOf(stackTrace, stackTrace.length)).skip(annotatedMethodIndex).map(recordViolation.loggedStackTrace.1.INSTANCE).collect(Collectors.joining("\n  "));
        String message2 = warningMessage + "\nViolating method: " + methodSignature + "\nStack trace:\n" + loggedStackTrace2;
        if (this.shouldLogErrors()) {
            this.logger.error(message2);
        } else {
            this.logger.warn(message2);
        }
        if (violationCount2 == 1L && !this.shouldSuppressNotifications()) {
            this.threadingViolationNotifier.notify(warningMessage, methodSignature);
        }
    }

    private final boolean shouldLogErrors() {
        return StringsKt.equals((String)System.getProperty("android.studio.instrumentation.threading.log-errors", "false"), (String)"true", (boolean)true);
    }

    private final boolean shouldSuppressNotifications() {
        return StringsKt.equals((String)System.getProperty("android.studio.instrumentation.threading.suppress-notifications", "false"), (String)"true", (boolean)true);
    }

    public ThreadingCheckerHookImpl() {
        this(null, 1, null);
    }
}

