/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.instantapp.InstantAppUrlFinder;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantApps {
    @NotNull
    public static List<Module> findFeatureModules(@NotNull AndroidFacet facet2) {
        return AndroidProjectInfo.getInstance(facet2.getModule().getProject()).getAllModulesOfProjectType(5);
    }

    @Nullable
    public static Module findBaseFeature(@NotNull AndroidFacet facet2) {
        return InstantApps.findBaseFeature(InstantApps.findFeatureModules(facet2));
    }

    @Nullable
    public static Module findBaseFeature(@NotNull Project project) {
        return InstantApps.findBaseFeature(AndroidProjectInfo.getInstance(project).getAllModulesOfProjectType(5));
    }

    @Nullable
    private static Module findBaseFeature(@NotNull List<Module> featureModules) {
        Module baseFeature = null;
        for (Module module2 : featureModules) {
            AndroidModel androidModel = AndroidModel.get(module2);
            if (androidModel == null || !androidModel.isBaseSplit()) continue;
            baseFeature = module2;
            break;
        }
        return baseFeature;
    }

    @NotNull
    public static String getDefaultInstantAppUrl(@NotNull AndroidFacet facet2) {
        String defaultUrl = "";
        List<Module> featureModules = InstantApps.findFeatureModules(facet2);
        for (Module module2 : featureModules) {
            String foundUrl = new InstantAppUrlFinder(module2).getDefaultUrl();
            if (!StringUtil.isNotEmpty((String)foundUrl)) continue;
            defaultUrl = foundUrl;
            break;
        }
        return defaultUrl;
    }

    public static boolean isInstantAppApplicationModule(@NotNull AndroidFacet androidFacet) {
        return androidFacet.getProperties().PROJECT_TYPE == 4;
    }

    public static boolean isPostO(IDevice device2) {
        AndroidVersion version2 = device2.getVersion();
        return version2.compareTo(25, "O") >= 0;
    }
}

