/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.imports;

import com.android.tools.idea.imports.AndroidMavenImportIntentionAction;
import com.android.tools.idea.imports.MavenImportUtilsKt;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/imports/AndroidMavenImportFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "className", "", "artifact", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getArtifact", "()Ljava/lang/String;", "getClassName", "getVersion", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "intellij.android.core"})
public final class AndroidMavenImportFix
implements LocalQuickFix {
    @NotNull
    private final String className;
    @NotNull
    private final String artifact;
    @Nullable
    private final String version;

    public AndroidMavenImportFix(@NotNull String className, @NotNull String artifact2, @Nullable String version2) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)artifact2, (String)"artifact");
        this.className = className;
        this.artifact = artifact2;
        this.version = version2;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final String getArtifact() {
        return this.artifact;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{MavenImportUtilsKt.flagPreview(this.artifact, this.version)};
        String string = AndroidBundle.message("android.suggested.dependency.action.name.prefix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.suggest\u2026eview(artifact, version))");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = AndroidBundle.message("android.suggested.dependency.action.family.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.suggest\u2026ency.action.family.name\")");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement element2 = descriptor2.getEndElement();
        AndroidMavenImportIntentionAction action2 = new AndroidMavenImportIntentionAction();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
        action2.perform(project, element2, this.artifact, null, true);
    }
}

