/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.ui;

import com.android.tools.idea.fileTypes.AndroidIconProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VariantCheckboxTreeCellRenderer
extends CheckboxTree.CheckboxTreeCellRenderer {
    protected void appendVariant(@NotNull String variant2) {
        ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
        textRenderer.append(variant2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        textRenderer.setIcon(StudioIcons.Misc.PROJECT_SYSTEM_VARIANT);
    }

    protected void appendModule(@NotNull Module module2, @Nullable String variant2) {
        ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
        textRenderer.append(module2.getName());
        textRenderer.setIcon(AndroidIconProvider.getModuleIcon(module2));
        if (StringUtil.isNotEmpty((String)variant2)) {
            textRenderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            textRenderer.append("(" + variant2 + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }
}

