/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.gradle.util.ui.ToolWindowAlikePanel;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.ui.VariantCheckboxTreeCellRenderer;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConflictResolutionDialog
extends DialogWrapper {
    private final JPanel myPanel;
    private final ConflictTree myTree;

    ConflictResolutionDialog(@NotNull Conflict conflict2) {
        super(conflict2.getSource().getProject());
        this.setTitle("Resolve Variant Selection Conflict");
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)400));
        this.init();
        VariantCheckboxTreeCellRenderer renderer2 = new VariantCheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                if (value2 instanceof DefaultMutableTreeNode) {
                    Object data2 = ((DefaultMutableTreeNode)value2).getUserObject();
                    if (data2 instanceof String) {
                        this.appendVariant((String)data2);
                    }
                    if (data2 instanceof Module) {
                        this.appendModule((Module)data2, null);
                    }
                }
            }
        };
        CheckedTreeNode root = new CheckedTreeNode(null);
        this.myTree = new ConflictTree(renderer2, root);
        this.myTree.setRootVisible(false);
        ArrayList variants = Lists.newArrayList(conflict2.getVariants());
        Collections.sort(variants);
        for (String variant2 : variants) {
            CheckedTreeNode variantNode = new CheckedTreeNode((Object)variant2);
            variantNode.setChecked(false);
            root.add((MutableTreeNode)variantNode);
            ArrayList<Module> dependents = new ArrayList<Module>();
            for (Conflict.AffectedModule affected : conflict2.getModulesExpectingVariant(variant2)) {
                Module module2 = affected.getTarget();
                dependents.add(module2);
            }
            if (dependents.size() > 1) {
                Collections.sort(dependents, ModuleTypeComparator.INSTANCE);
            }
            for (Module dependent : dependents) {
                DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(dependent);
                variantNode.add((MutableTreeNode)moduleNode);
            }
        }
        this.myTree.expandAll();
        JXLabel descriptionLabel = new JXLabel();
        descriptionLabel.setLineWrap(true);
        String sourceName = conflict2.getSource().getName();
        Object text2 = "The conflict cannot be automatically solved.\n";
        text2 = (String)text2 + String.format("Module '%1$s' has variant '%2$s' selected, but multiple modules require different variants.", sourceName, conflict2.getSelectedVariant());
        descriptionLabel.setText((String)text2);
        descriptionLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 5, 2));
        this.myPanel.add((Component)descriptionLabel, "North");
        String title = String.format("Variants in '%1$s' and their dependents", sourceName);
        this.myPanel.add((Component)ToolWindowAlikePanel.createTreePanel(title, (JTree)((Object)this.myTree)), "Center");
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    protected Action[] createActions() {
        return super.createActions();
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmpty((String)this.getSelectedVariant())) {
            return new ValidationInfo("Please choose the variant to set");
        }
        return null;
    }

    @Nullable
    String getSelectedVariant() {
        return this.myTree.getSelectedVariant();
    }

    private static class ConflictTree
    extends CheckboxTree {
        @NotNull
        final CheckedTreeNode myRoot;

        ConflictTree(@NotNull CheckboxTree.CheckboxTreeCellRenderer cellRenderer2, @NotNull CheckedTreeNode root) {
            super(cellRenderer2, root);
            this.myRoot = root;
        }

        @Nullable
        String getSelectedVariant() {
            Enumeration moduleNodes = this.myRoot.children();
            while (moduleNodes.hasMoreElements()) {
                CheckedTreeNode node;
                Object child = moduleNodes.nextElement();
                if (!(child instanceof CheckedTreeNode) || !(node = (CheckedTreeNode)child).isChecked()) continue;
                return node.getUserObject().toString();
            }
            return null;
        }

        void expandAll() {
            TreeUtil.expandAll((JTree)((Object)this));
        }

        public DefaultTreeModel getModel() {
            return (DefaultTreeModel)super.getModel();
        }

        protected void onNodeStateChanged(CheckedTreeNode node) {
            if (!node.isChecked()) {
                return;
            }
            Enumeration moduleNodes = this.myRoot.children();
            while (moduleNodes.hasMoreElements()) {
                Object child = moduleNodes.nextElement();
                if (child == node || !(child instanceof CheckedTreeNode)) continue;
                CheckedTreeNode childNode = (CheckedTreeNode)child;
                childNode.setChecked(false);
            }
        }
    }
}

