/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.module.Module;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Conflict {
    @NotNull
    private final Module mySource;
    @NotNull
    private final String mySelectedVariant;
    @NotNull
    private final Multimap<String, AffectedModule> myAffectedModulesByExpectedVariant = ArrayListMultimap.create();
    @NotNull
    private final List<AffectedModule> myAffectedModules = new ArrayList<AffectedModule>();
    private boolean myResolved;

    public Conflict(@NotNull Module source, @NotNull String selectedVariant) {
        this.mySource = source;
        this.mySelectedVariant = selectedVariant;
    }

    public void addAffectedModule(@NotNull Module target2, @NotNull String expectedVariant) {
        AffectedModule affected = new AffectedModule(this, target2, expectedVariant);
        this.myAffectedModules.add(affected);
        this.myAffectedModulesByExpectedVariant.put((Object)expectedVariant, (Object)affected);
    }

    @NotNull
    public Collection<String> getVariants() {
        return this.myAffectedModulesByExpectedVariant.keySet();
    }

    @NotNull
    public Collection<AffectedModule> getModulesExpectingVariant(@NotNull String variant2) {
        return this.myAffectedModulesByExpectedVariant.get((Object)variant2);
    }

    @NotNull
    public Module getSource() {
        return this.mySource;
    }

    @NotNull
    public String getSelectedVariant() {
        return this.mySelectedVariant;
    }

    @NotNull
    public List<AffectedModule> getAffectedModules() {
        return this.myAffectedModules;
    }

    public void refreshStatus() {
        int selectedVariantCount = 0;
        block0: for (String variant2 : this.myAffectedModulesByExpectedVariant.keySet()) {
            for (AffectedModule affected : this.getModulesExpectingVariant(variant2)) {
                if (!affected.isSelected()) continue;
                ++selectedVariantCount;
                continue block0;
            }
        }
        this.setResolved(selectedVariantCount <= 1);
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public void setResolved(boolean resolved) {
        this.myResolved = resolved;
    }

    public String toString() {
        Object text2 = String.format("Module '%1$s' has variant '%2$s' selected, but", this.mySource.getName(), this.mySelectedVariant);
        ArrayList expectedVariants = Lists.newArrayList(this.getVariants());
        if (expectedVariants.size() == 1) {
            String expectedVariant = (String)expectedVariants.get(0);
            Collection<AffectedModule> modules2 = this.getModulesExpectingVariant(expectedVariant);
            String moduleNames2 = Conflict.getModuleNames(modules2);
            String format = modules2.size() == 1 ? " the module '%1$s' depends on variant '%2$s'" : " the modules %1$s depend on variant '%2$s'";
            text2 = (String)text2 + String.format(format, moduleNames2, expectedVariant);
        } else {
            Collections.sort(expectedVariants);
            for (String expectedVariant : expectedVariants) {
                Collection<AffectedModule> modules3 = this.getModulesExpectingVariant(expectedVariant);
                String moduleNames3 = Conflict.getModuleNames(modules3);
                text2 = (String)text2 + "\n- ";
                String format = modules3.size() == 1 ? "Module '%1$s' depends on variant '%2$s'" : "Modules %1$s depend on variant '%2$s'";
                text2 = (String)text2 + String.format(format, moduleNames3, expectedVariant);
            }
        }
        return text2;
    }

    @NotNull
    private static String getModuleNames(@NotNull Collection<AffectedModule> modules2) {
        if (modules2.size() == 1) {
            AffectedModule module2 = (AffectedModule)ContainerUtil.getFirstItem(modules2);
            assert (module2 != null);
            return "'" + module2.getTarget().getName() + "'";
        }
        ArrayList<CallSite> names = new ArrayList<CallSite>();
        for (AffectedModule module3 : modules2) {
            names.add((CallSite)((Object)("'" + module3.getTarget().getName() + "'")));
        }
        Collections.sort(names);
        return ((Object)names).toString();
    }

    public static class AffectedModule {
        @NotNull
        private final Conflict myConflict;
        @NotNull
        private final Module myTarget;
        @NotNull
        private final String myExpectedVariant;
        private boolean mySelected = true;

        AffectedModule(@NotNull Conflict conflict2, @NotNull Module target2, @NotNull String expectedVariant) {
            this.myConflict = conflict2;
            this.myTarget = target2;
            this.myExpectedVariant = expectedVariant;
        }

        @NotNull
        public Conflict getConflict() {
            return this.myConflict;
        }

        @NotNull
        public Module getTarget() {
            return this.myTarget;
        }

        @NotNull
        public String getExpectedVariant() {
            return this.myExpectedVariant;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
            this.myConflict.refreshStatus();
        }
    }
}

