/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public final class GradleProjects {
    private GradleProjects() {
    }

    public static void executeProjectChanges(@NotNull Project project, @NotNull Runnable changes) {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            if (!project.isDisposed()) {
                changes.run();
            }
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (!project.isDisposed()) {
                ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
            }
        }));
    }

    public static boolean isOfflineBuildModeEnabled(@NotNull Project project) {
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    public static boolean canImportAsGradleProject(@NotNull VirtualFile importSource) {
        VirtualFile target2 = ProjectImportUtil.findGradleTarget(importSource);
        return target2 != null && ("gradle".equals(target2.getExtension()) || target2.getName().endsWith("gradle.kts"));
    }
}

