/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.util.StudioPathManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedDistributionPaths {
    @NotNull
    public static EmbeddedDistributionPaths getInstance() {
        return (EmbeddedDistributionPaths)ApplicationManager.getApplication().getService(EmbeddedDistributionPaths.class);
    }

    @NotNull
    public List<File> findAndroidStudioLocalMavenRepoPaths() {
        if (!((Boolean)StudioFlags.USE_DEVELOPMENT_OFFLINE_REPOS.get()).booleanValue() && !GuiTestingService.isInTestingMode()) {
            return ImmutableList.of();
        }
        return EmbeddedDistributionPaths.doFindAndroidStudioLocalMavenRepoPaths();
    }

    @VisibleForTesting
    @NotNull
    static List<File> doFindAndroidStudioLocalMavenRepoPaths() {
        ArrayList<File> repoPaths = new ArrayList<File>();
        String studioCustomRepo = System.getenv("STUDIO_CUSTOM_REPO");
        if (studioCustomRepo != null) {
            try {
                Path customRepoPath = Paths.get(studioCustomRepo, new String[0]).toRealPath(new LinkOption[0]);
                if (!Files.isDirectory(customRepoPath, new LinkOption[0])) {
                    throw new IllegalArgumentException("Invalid path in STUDIO_CUSTOM_REPO environment variable");
                }
                repoPaths.add(customRepoPath.toFile());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid path in STUDIO_CUSTOM_REPO environment variable", e);
            }
        }
        if (StudioPathManager.isRunningFromSources()) {
            ArrayList<Object> repoCandidates = new ArrayList<Object>();
            if (studioCustomRepo == null) {
                repoCandidates.add("out/repo");
            }
            repoCandidates.add("out/studio/repo");
            repoCandidates.add("prebuilts/tools/common/m2/repository");
            repoCandidates.add(System.getProperty("java.io.tmpdir") + "/offline-maven-repo");
            repoCandidates.add("../maven/repository");
            for (String string : repoCandidates) {
                Path candidateDir = StudioPathManager.resolvePathFromSourcesRoot((String)string);
                if (!Files.isDirectory(candidateDir, new LinkOption[0])) continue;
                repoPaths.add(candidateDir.toFile());
            }
        }
        return ImmutableList.copyOf(repoPaths);
    }

    @NotNull
    public File findEmbeddedProfilerTransform() {
        if (StudioPathManager.isRunningFromSources()) {
            return StudioPathManager.resolvePathFromSourcesRoot((String)"bazel-bin/tools/base/profiler/transform/profilers-transform.jar").toFile();
        }
        return new File(PathManager.getHomePath(), "plugins/android/resources/profilers-transform.jar");
    }

    @Nullable
    public File findEmbeddedGradleDistributionPath() {
        Path distribution;
        if (StudioPathManager.isRunningFromSources() && Files.isDirectory(distribution = StudioPathManager.resolvePathFromSourcesRoot((String)"tools/external/gradle"), new LinkOption[0])) {
            return distribution.toFile();
        }
        return null;
    }

    @Nullable
    public File findEmbeddedGradleDistributionFile(@NotNull String gradleVersion2) {
        File distributionPath = this.findEmbeddedGradleDistributionPath();
        if (distributionPath != null) {
            File allDistributionFile = new File(distributionPath, "gradle-" + gradleVersion2 + "-all.zip");
            if (allDistributionFile.isFile() && allDistributionFile.exists()) {
                return allDistributionFile;
            }
            File binDistributionFile = new File(distributionPath, "gradle-" + gradleVersion2 + "-bin.zip");
            if (binDistributionFile.isFile() && binDistributionFile.exists()) {
                return binDistributionFile;
            }
        }
        return null;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(EmbeddedDistributionPaths.class);
    }

    @Nullable
    private static File getDefaultRootDirPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File rootDirPath = new File(ideHomePath, "gradle");
        return rootDirPath.isDirectory() ? rootDirPath : null;
    }

    @Nullable
    public Path tryToGetEmbeddedJdkPath() {
        try {
            return this.getEmbeddedJdkPath();
        }
        catch (Throwable t) {
            Logger.getInstance(EmbeddedDistributionPaths.class).warn("Failed to find a valid embedded JDK", t);
            return null;
        }
    }

    @NotNull
    public Path getEmbeddedJdkPath() {
        if (StudioPathManager.isRunningFromSources()) {
            if (System.getProperty("android.test.embedded.jdk") != null) {
                Path jdkDir = Paths.get(System.getProperty("android.test.embedded.jdk"), new String[0]);
                return jdkDir;
            }
            String embeddedJdkPath = System.getProperty("embedded.jdk.path", "prebuilts/studio/jdk/jdk17").trim();
            Path jdkDir = EmbeddedDistributionPaths.getJdkRootPathFromSourcesRoot(embeddedJdkPath);
            try {
                Path wellKnownJdkFile = jdkDir.resolve("release");
                jdkDir = wellKnownJdkFile.toRealPath(new LinkOption[0]).getParent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return jdkDir;
        }
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        Path jdkRootPath = Paths.get(ideHomePath, "jbr");
        return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
    }

    @NotNull
    public static Path getJdkRootPathFromSourcesRoot(String embeddedJdkPath) {
        Path jdkRootPath = StudioPathManager.resolvePathFromSourcesRoot((String)embeddedJdkPath);
        if (SystemInfo.isWindows) {
            jdkRootPath = embeddedJdkPath.endsWith("jdk") ? jdkRootPath.resolve("win64") : jdkRootPath.resolve("win");
        } else if (SystemInfo.isLinux) {
            jdkRootPath = jdkRootPath.resolve("linux");
        } else if (SystemInfo.isMac) {
            jdkRootPath = jdkRootPath.resolve("mac");
        }
        Path jdkDir = EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
        return jdkDir;
    }

    @NotNull
    private static Path getSystemSpecificJdkPath(Path jdkRootPath) {
        if (SystemInfo.isMac) {
            jdkRootPath = jdkRootPath.resolve("Contents/Home");
        }
        if (!Files.isDirectory(jdkRootPath, new LinkOption[0])) {
            throw new Error(String.format("Incomplete or corrupted installation - \"%s\" directory does not exist", jdkRootPath));
        }
        return jdkRootPath;
    }

    @NotNull
    private static String getIdeHomePath() {
        return FileUtil.toSystemDependentName((String)PathManager.getHomePath());
    }
}

