/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApkFileUnit;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicAppUtils {
    @Nullable
    public static Module getBaseFeature(@NotNull Module module2) {
        return ProjectSystemUtil.getModuleSystem(module2).getBaseFeatureModule();
    }

    @NotNull
    public static List<Module> getFeatureModulesDependingOnFeature(@NotNull Module featureModule) {
        if (!((Boolean)StudioFlags.SUPPORT_FEATURE_ON_FEATURE_DEPS.get()).booleanValue()) {
            return ImmutableList.of();
        }
        return DynamicAppUtils.selectFeatureModules(DynamicAppUtils.removeModulesIntheSameGradleProject(ModuleManager.getInstance((Project)featureModule.getProject()).getModuleDependentModules(ModuleSystemUtil.getMainModule(featureModule)).stream(), featureModule));
    }

    @NotNull
    public static List<Module> getFeatureModuleDependenciesForFeature(@NotNull Module featureModule) {
        if (!((Boolean)StudioFlags.SUPPORT_FEATURE_ON_FEATURE_DEPS.get()).booleanValue()) {
            return ImmutableList.of();
        }
        return DynamicAppUtils.selectFeatureModules(DynamicAppUtils.removeModulesIntheSameGradleProject(Stream.of(ModuleRootManager.getInstance((Module)ModuleSystemUtil.getMainModule(featureModule)).getDependencies()), featureModule));
    }

    @NotNull
    public static Stream<Module> removeModulesIntheSameGradleProject(@NotNull Stream<Module> modules2, @NotNull Module moduleOfProjectToRemove) {
        return modules2.filter(m -> ModuleSystemUtil.getHolderModule(m) != ModuleSystemUtil.getHolderModule(moduleOfProjectToRemove));
    }

    public static boolean useSelectApksFromBundleBuilder(@NotNull Module module2, boolean alwaysDeployApkFromBundle, boolean deployForTests, @Nullable AndroidVersion minTargetDeviceVersion) {
        AndroidModuleSystem moduleSystem;
        AndroidModuleSystem.Type type;
        if (alwaysDeployApkFromBundle) {
            return true;
        }
        if (minTargetDeviceVersion != null && minTargetDeviceVersion.getFeatureLevel() < 21 && !ProjectSystemUtil.getModuleSystem(module2).getDynamicFeatureModules().isEmpty()) {
            return true;
        }
        return deployForTests && (type = (moduleSystem = ProjectSystemUtil.getModuleSystem(module2)).getType()) == AndroidModuleSystem.Type.TYPE_DYNAMIC_FEATURE;
    }

    @NotNull
    public static List<Module> getDependentInstantFeatureModules(@NotNull Module module2) {
        return ProjectSystemUtil.getModuleSystem(module2).getDynamicFeatureModules().stream().filter(it -> {
            AndroidModel model2 = AndroidModel.get(it);
            return model2 != null && model2.isInstantAppCompatible();
        }).collect(Collectors.toList());
    }

    public static boolean isFeatureEnabled(@NotNull List<String> myDisabledFeatures, @NotNull ApkFileUnit apkFileUnit) {
        return myDisabledFeatures.stream().noneMatch(m -> DynamicAppUtils.featureNameEquals(apkFileUnit, m));
    }

    public static boolean featureNameEquals(@NotNull ApkFileUnit apkFileUnit, @NotNull String featureName) {
        return StringUtil.equals((CharSequence)featureName.replace('-', '_'), (CharSequence)apkFileUnit.getModuleName());
    }

    @NotNull
    private static List<Module> selectFeatureModules(Stream<Module> moduleStream) {
        return moduleStream.map(ModuleSystemUtil::getHolderModule).distinct().filter(module2 -> {
            AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module2);
            AndroidModuleSystem.Type type = moduleSystem.getType();
            return type == AndroidModuleSystem.Type.TYPE_FEATURE || type == AndroidModuleSystem.Type.TYPE_DYNAMIC_FEATURE;
        }).collect(Collectors.toList());
    }
}

