/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDependencyCollection;
import com.android.tools.idea.gradle.structure.model.PsJarDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryKey;
import com.android.tools.idea.gradle.structure.model.PsLibraryKeyKt;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.google.common.collect.LinkedListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b2\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\tB\r\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0002H\u0004\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0003H\u0004\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u001fH\u0004J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00020\u00112\u0006\u0010(\u001a\u00020\u000eH\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010\u00112\u0006\u0010*\u001a\u00020\u0017H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010\u00112\u0006\u0010+\u001a\u00020\u000eH\u0016J \u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010\u00112\b\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00030\u00112\u0006\u0010/\u001a\u00020\u000eH\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u001fH\u0016J\u0010\u00103\u001a\u00020\u001f2\u0006\u0010 \u001a\u000204H\u0016J\u0006\u00105\u001a\u00020\u001fR*\u0010\f\u001a\u001e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00018\u00028\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R*\u0010\u0016\u001a\u001e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00170\u0017\u0012\f\u0012\n \u000f*\u0004\u0018\u00018\u00018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0018\u001a\u001e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00018\u00038\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00030\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0013R\u0016\u0010\n\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00066"}, d2={"Lcom/android/tools/idea/gradle/structure/model/PsDependencyCollectionBase;", "ModuleT", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "LibraryDependencyT", "Lcom/android/tools/idea/gradle/structure/model/PsLibraryDependency;", "JarDependencyT", "Lcom/android/tools/idea/gradle/structure/model/PsJarDependency;", "ModuleDependencyT", "Lcom/android/tools/idea/gradle/structure/model/PsModuleDependency;", "Lcom/android/tools/idea/gradle/structure/model/PsDependencyCollection;", "parent", "(Lcom/android/tools/idea/gradle/structure/model/PsModule;)V", "jarDependenciesByPath", "Lcom/google/common/collect/LinkedListMultimap;", "", "kotlin.jvm.PlatformType", "jars", "", "getJars", "()Ljava/util/List;", "libraries", "getLibraries", "libraryDependenciesBySpec", "Lcom/android/tools/idea/gradle/structure/model/PsLibraryKey;", "moduleDependenciesByGradlePath", "modules", "getModules", "getParent", "()Lcom/android/tools/idea/gradle/structure/model/PsModule;", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "addJarDependency", "", "dependency", "(Lcom/android/tools/idea/gradle/structure/model/PsJarDependency;)V", "addLibraryDependency", "(Lcom/android/tools/idea/gradle/structure/model/PsLibraryDependency;)V", "addModuleDependency", "(Lcom/android/tools/idea/gradle/structure/model/PsModuleDependency;)V", "clear", "findJarDependencies", "filePath", "findLibraryDependencies", "libraryKey", "compactNotation", "group", "name", "findModuleDependencies", "gradlePath", "isEmpty", "", "onCleared", "onDependencyAdded", "Lcom/android/tools/idea/gradle/structure/model/PsBaseDependency;", "reindex", "intellij.android.projectSystem.gradle.psd"})
public abstract class PsDependencyCollectionBase<ModuleT extends PsModule, LibraryDependencyT extends PsLibraryDependency, JarDependencyT extends PsJarDependency, ModuleDependencyT extends PsModuleDependency>
implements PsDependencyCollection<ModuleT, LibraryDependencyT, JarDependencyT, ModuleDependencyT> {
    @NotNull
    private final ModuleT parent;
    @NotNull
    private final LinkedListMultimap<PsLibraryKey, LibraryDependencyT> libraryDependenciesBySpec;
    @NotNull
    private final LinkedListMultimap<String, JarDependencyT> jarDependenciesByPath;
    @NotNull
    private final LinkedListMultimap<String, ModuleDependencyT> moduleDependenciesByGradlePath;

    public PsDependencyCollectionBase(@NotNull ModuleT parent2) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        this.parent = parent2;
        LinkedListMultimap linkedListMultimap = LinkedListMultimap.create();
        Intrinsics.checkNotNull((Object)linkedListMultimap);
        this.libraryDependenciesBySpec = linkedListMultimap;
        LinkedListMultimap linkedListMultimap2 = LinkedListMultimap.create();
        Intrinsics.checkNotNull((Object)linkedListMultimap2);
        this.jarDependenciesByPath = linkedListMultimap2;
        LinkedListMultimap linkedListMultimap3 = LinkedListMultimap.create();
        Intrinsics.checkNotNull((Object)linkedListMultimap3);
        this.moduleDependenciesByGradlePath = linkedListMultimap3;
    }

    @Override
    @NotNull
    public ModuleT getParent() {
        return this.parent;
    }

    @Override
    public boolean isEmpty() {
        return this.moduleDependenciesByGradlePath.isEmpty() && this.libraryDependenciesBySpec.isEmpty() && this.jarDependenciesByPath.isEmpty();
    }

    @Override
    @NotNull
    public List<LibraryDependencyT> getLibraries() {
        List list2 = this.libraryDependenciesBySpec.values();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"libraryDependenciesBySpec.values()");
        return list2;
    }

    @Override
    @NotNull
    public List<JarDependencyT> getJars() {
        List list2 = this.jarDependenciesByPath.values();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"jarDependenciesByPath.values()");
        return list2;
    }

    @Override
    @NotNull
    public List<ModuleDependencyT> getModules() {
        List list2 = this.moduleDependenciesByGradlePath.values();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"moduleDependenciesByGradlePath.values()");
        return list2;
    }

    @Override
    @NotNull
    public List<ModuleDependencyT> findModuleDependencies(@NotNull String gradlePath) {
        Intrinsics.checkNotNullParameter((Object)gradlePath, (String)"gradlePath");
        List list2 = this.moduleDependenciesByGradlePath.get((Object)gradlePath);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"moduleDependenciesByGradlePath[gradlePath]");
        return CollectionsKt.toList((Iterable)list2);
    }

    @Override
    @NotNull
    public List<JarDependencyT> findJarDependencies(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        List list2 = this.jarDependenciesByPath.get((Object)filePath);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"jarDependenciesByPath[filePath]");
        return CollectionsKt.toList((Iterable)list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LibraryDependencyT> findLibraryDependencies(@NotNull String compactNotation) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)compactNotation, (String)"compactNotation");
        PsArtifactDependencySpec psArtifactDependencySpec = PsArtifactDependencySpec.Companion.create(compactNotation);
        if (psArtifactDependencySpec == null) {
            return CollectionsKt.emptyList();
        }
        PsArtifactDependencySpec spec = psArtifactDependencySpec;
        String string = spec.getGroup();
        if (string == null) {
            string = "";
        }
        List list2 = this.libraryDependenciesBySpec.get((Object)new PsLibraryKey(string, spec.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"libraryDependenciesBySpe\u2026up.orEmpty(), spec.name)]");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsLibraryDependency it = (PsLibraryDependency)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getSpec(), (Object)spec)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public void onDependencyAdded(@NotNull PsBaseDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
    }

    public void onCleared() {
    }

    @Override
    @NotNull
    public List<LibraryDependencyT> findLibraryDependencies(@Nullable String group2, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = group2;
        if (string == null) {
            string = "";
        }
        List list2 = this.libraryDependenciesBySpec.get((Object)new PsLibraryKey(string, name));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"libraryDependenciesBySpe\u2026y(group.orEmpty(), name)]");
        return CollectionsKt.toList((Iterable)list2);
    }

    @Override
    @NotNull
    public List<LibraryDependencyT> findLibraryDependencies(@NotNull PsLibraryKey libraryKey) {
        Intrinsics.checkNotNullParameter((Object)libraryKey, (String)"libraryKey");
        List list2 = this.libraryDependenciesBySpec.get((Object)libraryKey);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"libraryDependenciesBySpec[libraryKey]");
        return CollectionsKt.toList((Iterable)list2);
    }

    protected final void addLibraryDependency(@NotNull LibraryDependencyT dependency) {
        Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
        this.libraryDependenciesBySpec.put((Object)PsLibraryKeyKt.toLibraryKey(dependency.getSpec()), dependency);
        this.onDependencyAdded((PsBaseDependency)dependency);
    }

    protected final void addJarDependency(@NotNull JarDependencyT dependency) {
        Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
        this.jarDependenciesByPath.put((Object)dependency.getFilePath(), dependency);
        this.onDependencyAdded((PsBaseDependency)dependency);
    }

    protected final void addModuleDependency(@NotNull ModuleDependencyT dependency) {
        Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
        this.moduleDependenciesByGradlePath.put((Object)dependency.getGradlePath(), dependency);
        this.onDependencyAdded((PsBaseDependency)dependency);
    }

    protected final void clear() {
        this.libraryDependenciesBySpec.clear();
        this.moduleDependenciesByGradlePath.clear();
        this.jarDependenciesByPath.clear();
        this.onCleared();
    }

    public final void reindex() {
        PsBaseDependency it;
        List list2 = this.libraryDependenciesBySpec.values();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"libraryDependenciesBySpec.values()");
        List libraryDependencies = CollectionsKt.toList((Iterable)list2);
        List list3 = this.jarDependenciesByPath.values();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"jarDependenciesByPath.values()");
        List jarDependencies = CollectionsKt.toList((Iterable)list3);
        List list4 = this.moduleDependenciesByGradlePath.values();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"moduleDependenciesByGradlePath.values()");
        List moduleDependencies = CollectionsKt.toList((Iterable)list4);
        this.libraryDependenciesBySpec.clear();
        Iterable $this$forEach$iv = libraryDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsLibraryDependency)element$iv;
            boolean bl = false;
            this.libraryDependenciesBySpec.put((Object)PsLibraryKeyKt.toLibraryKey(it.getSpec()), (Object)it);
        }
        this.jarDependenciesByPath.clear();
        $this$forEach$iv = jarDependencies;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsJarDependency)element$iv;
            boolean bl = false;
            this.jarDependenciesByPath.put((Object)it.getFilePath(), (Object)it);
        }
        this.moduleDependenciesByGradlePath.clear();
        $this$forEach$iv = moduleDependencies;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsModuleDependency)element$iv;
            boolean bl = false;
            this.moduleDependenciesByGradlePath.put((Object)it.getGradlePath(), (Object)it);
        }
    }
}

