/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies.android;

import com.android.tools.idea.gradle.model.IdeArtifactName;
import java.util.Objects;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Configuration {
    static final Configuration MAIN = new Configuration("Main", IdeArtifactName.MAIN);
    static final Configuration ANDROID_TEST = new Configuration(AndroidBundle.message("android.test.run.configuration.type.name", new Object[0]), IdeArtifactName.ANDROID_TEST);
    static final Configuration UNIT_TEST = new Configuration("Local Unit Tests", IdeArtifactName.UNIT_TEST);
    static final Configuration TEST_FIXTURES = new Configuration("Android Test Fixtures", IdeArtifactName.TEST_FIXTURES);
    @NotNull
    private final String myName;
    @Nullable
    private final IdeArtifactName myArtifactName;

    Configuration(@NotNull String name, @Nullable IdeArtifactName artifactName) {
        this.myName = name;
        this.myArtifactName = artifactName;
    }

    @NotNull
    String getName() {
        return this.myName;
    }

    @Nullable
    IdeArtifactName getArtifactName() {
        return this.myArtifactName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return Objects.equals(this.myName, that.myName) && Objects.equals((Object)this.myArtifactName, (Object)that.myArtifactName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myName, this.myArtifactName});
    }

    public String toString() {
        return this.myName;
    }
}

