/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.tools.idea.gradle.structure.daemon.PsAnalyzerDaemon;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.quickfix.SdkIndexLinkQuickFix;
import com.android.tools.idea.projectsystem.gradle.IdeGooglePlaySdkIndex;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\"\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createIndexIssue", "Lcom/android/tools/idea/gradle/structure/model/PsGeneralIssue;", "message", "", "groupId", "artifactId", "versionString", "mainPath", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "severity", "Lcom/android/tools/idea/gradle/structure/model/PsIssue$Severity;", "getSdkIndexIssueFor", "dependencySpec", "Lcom/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec;", "libraryPath", "parentModuleRootDir", "Ljava/io/File;", "intellij.android.projectSystem.gradle.psd"})
public final class PsAnalyzerDaemonKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final PsGeneralIssue getSdkIndexIssueFor(@NotNull PsArtifactDependencySpec dependencySpec, @NotNull PsPath libraryPath, @Nullable File parentModuleRootDir) {
        Intrinsics.checkNotNullParameter((Object)dependencySpec, (String)"dependencySpec");
        Intrinsics.checkNotNullParameter((Object)libraryPath, (String)"libraryPath");
        IdeGooglePlaySdkIndex sdkIndex = IdeGooglePlaySdkIndex.INSTANCE;
        String string = dependencySpec.getGroup();
        if (string == null) {
            return null;
        }
        String groupId = string;
        String string2 = dependencySpec.getVersion();
        if (string2 == null) {
            return null;
        }
        String versionString = string2;
        String artifactId = dependencySpec.getName();
        if (sdkIndex.isLibraryNonCompliant(groupId, artifactId, versionString, parentModuleRootDir)) {
            String message2 = sdkIndex.generatePolicyMessage(groupId, artifactId, versionString);
            return PsAnalyzerDaemonKt.createIndexIssue(message2, groupId, artifactId, versionString, libraryPath, PsIssue.Severity.ERROR);
        }
        boolean isBlocking = sdkIndex.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        if (isBlocking) {
            if (sdkIndex.hasLibraryCriticalIssues(groupId, artifactId, versionString, parentModuleRootDir)) {
                String message3 = sdkIndex.generateBlockingCriticalMessage(groupId, artifactId, versionString);
                return PsAnalyzerDaemonKt.createIndexIssue(message3, groupId, artifactId, versionString, libraryPath, PsIssue.Severity.ERROR);
            }
            if (sdkIndex.isLibraryOutdated(groupId, artifactId, versionString, parentModuleRootDir)) {
                String message4 = sdkIndex.generateBlockingOutdatedMessage(groupId, artifactId, versionString);
                return PsAnalyzerDaemonKt.createIndexIssue(message4, groupId, artifactId, versionString, libraryPath, PsIssue.Severity.ERROR);
            }
        } else {
            if (sdkIndex.isLibraryOutdated(groupId, artifactId, versionString, parentModuleRootDir)) {
                String message5 = sdkIndex.generateOutdatedMessage(groupId, artifactId, versionString);
                return PsAnalyzerDaemonKt.createIndexIssue(message5, groupId, artifactId, versionString, libraryPath, PsIssue.Severity.WARNING);
            }
            if (sdkIndex.hasLibraryCriticalIssues(groupId, artifactId, versionString, parentModuleRootDir)) {
                String message6 = sdkIndex.generateCriticalMessage(groupId, artifactId, versionString);
                return PsAnalyzerDaemonKt.createIndexIssue(message6, groupId, artifactId, versionString, libraryPath, PsIssue.Severity.INFO);
            }
        }
        return null;
    }

    private static final PsGeneralIssue createIndexIssue(String message2, String groupId, String artifactId, String versionString, PsPath mainPath, PsIssue.Severity severity) {
        IdeGooglePlaySdkIndex sdkIndex = IdeGooglePlaySdkIndex.INSTANCE;
        String url = sdkIndex.getSdkUrl(groupId, artifactId);
        List fixes = url != null ? CollectionsKt.listOf((Object)new SdkIndexLinkQuickFix("View details on Google Play SDK Index", url, groupId, artifactId, versionString, null, null, 96, null)) : CollectionsKt.emptyList();
        PsIssueType psIssueType = PsIssueType.PLAY_SDK_INDEX_ISSUE;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PLAY_SDK_INDEX_ISSUE");
        return new PsGeneralIssue(message2, "", mainPath, psIssueType, severity, fixes);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger2 = Logger.getInstance(PsAnalyzerDaemon.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(PsAnalyzerDaemon::class.java)");
        LOG = logger2;
    }
}

