/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDeclaredDependenciesTableModel;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.intellij.openapi.Disposable;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclaredDependenciesTableView<T extends PsBaseDependency>
extends TableView<T>
implements Disposable {
    @NotNull
    private final PsContext myContext;
    private KeyEventDispatcher myKeyEventDispatcher;

    public DeclaredDependenciesTableView(@NotNull AbstractDeclaredDependenciesTableModel<T> model2, @NotNull PsContext context2) {
        super(model2);
        this.myContext = context2;
        this.getSelectionModel().setSelectionMode(2);
        this.addHyperlinkFunctionality();
        this.setRowHeight(JBUI.scale((int)24));
        this.setDragEnabled(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        new TableSpeedSearch((JTable)((Object)this), (o, cell) -> {
            PsBaseDependency dependency = (PsBaseDependency)model2.getItem(cell.getRow());
            if (dependency != null) {
                return AbstractDeclaredDependenciesTableModel.displayTextOf(dependency, context2.getUiSettings());
            }
            return o == null || o instanceof Boolean ? "" : o.toString();
        });
    }

    protected void processMouseEvent(MouseEvent e) {
        PsModuleDependency dependency;
        int id2 = e.getID();
        if (id2 == 501 && (dependency = this.getIfHyperlink(e)) != null) {
            String name = dependency.getName();
            this.myContext.setSelectedModule(name, (Object)this);
            return;
        }
        super.processMouseEvent(e);
    }

    @Nullable
    private PsModuleDependency getIfHyperlink(@NotNull MouseEvent e) {
        if (UiUtil.isMetaOrCtrlKeyPressed(e)) {
            Point point = new Point(e.getX(), e.getY());
            return this.getDependencyForLocation(point);
        }
        return null;
    }

    private void addHyperlinkFunctionality() {
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PsModuleDependency hovered = DeclaredDependenciesTableView.this.getIfHyperlink(e);
                DeclaredDependenciesTableView.this.setHoveredDependency(hovered);
            }
        });
        this.myKeyEventDispatcher = e -> {
            PsModuleDependency dependency = null;
            if (e.getID() == 401) {
                if (UiUtil.isMetaOrCtrlKeyPressed(e)) {
                    dependency = this.getDependencyUnderMousePointer();
                }
                this.setHoveredDependency(dependency);
            } else if (e.getID() == 402 && UiUtil.isMetaOrCtrlKeyPressed(e)) {
                this.setHoveredDependency(null);
            }
            return false;
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.myKeyEventDispatcher);
    }

    @Nullable
    private PsModuleDependency getDependencyUnderMousePointer() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            Point location2 = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(location2, (Component)((Object)this));
            return this.getDependencyForLocation(location2);
        }
        return null;
    }

    @Nullable
    private PsModuleAndroidDependency getDependencyForLocation(@NotNull Point location2) {
        PsBaseDependency dependency;
        int row2;
        int column2 = this.columnAtPoint(location2);
        if (column2 == 0 && (row2 = this.rowAtPoint(location2)) > -1 && (dependency = (PsBaseDependency)this.getListTableModel().getItem(row2)) instanceof PsModuleAndroidDependency) {
            return (PsModuleAndroidDependency)dependency;
        }
        return null;
    }

    private void setHoveredDependency(@Nullable PsModuleDependency dependency) {
        this.getListTableModel().setHoveredDependency(dependency);
        Cursor cursor = null;
        if (dependency != null) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        this.setCursor(cursor);
        this.repaint();
    }

    public AbstractDeclaredDependenciesTableModel<T> getListTableModel() {
        return (AbstractDeclaredDependenciesTableModel)((Object)super.getModel());
    }

    public void selectFirstRow() {
        if (!this.getItems().isEmpty()) {
            this.changeSelection(0, 0, false, false);
        }
    }

    @Nullable
    public T getSelectionIfSingle() {
        Collection selection = this.getSelection();
        if (selection.size() == 1) {
            PsBaseDependency selected = (PsBaseDependency)ContainerUtil.getFirstItem((Collection)selection);
            assert (selected != null);
            return (T)selected;
        }
        return null;
    }

    public void selectDependency(@NotNull String toSelect) {
        for (PsBaseDependency dependency : this.getItems()) {
            String dependencyAsText = dependency.toText();
            if (!toSelect.equals(dependencyAsText)) continue;
            this.setSelection(Collections.singletonList(dependency));
            break;
        }
    }

    public void dispose() {
        if (this.myKeyEventDispatcher != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.myKeyEventDispatcher);
        }
    }
}

