/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.issues;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssueRenderer;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueKt;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsPathKt;
import com.android.tools.idea.gradle.structure.model.PsQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/issues/DependencyViewIssueRenderer;", "Lcom/android/tools/idea/gradle/structure/configurables/issues/IssueRenderer;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "renderDescription", "", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;Z)V", "renderIssue", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "issue", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "scope", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "intellij.android.projectSystem.gradle.psd"})
public final class DependencyViewIssueRenderer
implements IssueRenderer {
    @NotNull
    private final PsContext context;
    private final boolean renderDescription;

    public DependencyViewIssueRenderer(@NotNull PsContext context2, boolean renderDescription) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.renderDescription = renderDescription;
    }

    @Override
    public void renderIssue(@NotNull StringBuilder buffer, @NotNull PsIssue issue2, @Nullable PsPath scope2) {
        String description2;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Iterable $this$takeWhile$iv = CollectionsKt.asReversed((List)CollectionsKt.plus((Collection)PsPathKt.getParents(issue2.getPath()), (Object)issue2.getPath()));
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            PsPath it = (PsPath)item$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)scope2))) break;
            list$iv.add(item$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.asReversed((List)list$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsPath parentPath = (PsPath)element$iv;
            boolean bl = false;
            String parentPathHref = parentPath.getHyperlinkDestination(this.context);
            if (parentPathHref == null) continue;
            String parentPathText = this.makeTextWrappable(parentPath.toString());
            buffer.append("<a href=\"" + parentPathHref + "\">" + parentPathText + "</a>: ");
        }
        buffer.append(issue2.getText());
        $this$forEach$iv = issue2.getQuickFixes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsQuickFix quickFix = (PsQuickFix)element$iv;
            boolean bl = false;
            buffer.append(" <a href='" + PsIssueKt.getHyperlinkDestination(quickFix) + "'>[" + quickFix.getText() + "]</a>");
        }
        if (this.renderDescription && StringUtil.isNotEmpty((String)(description2 = issue2.getDescription()))) {
            buffer.append("<br/><br/>").append(description2);
        }
    }
}

