/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.dependencies.module;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.DependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.JarDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.ModuleDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.SingleDeclaredLibraryDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.module.DeclaredDependenciesTableModel;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.DependencySelection;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.issues.SingleModuleIssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.ui.MergingUpdateQueueUtilsKt;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.DeclaredDependenciesTableView;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDeclaredDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u00017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u0012H\u0016J\b\u0010$\u001a\u00020\"H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010&\u001a\u00020\u0016H\u0002J\u001a\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0016H\u0002J\u0010\u0010.\u001a\u00020\u00162\b\u0010/\u001a\u0004\u0018\u00010\u0012J\u0018\u00100\u001a\u00020(2\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u000102H\u0016J\b\u00103\u001a\u00020\u0016H\u0002J\u0012\u00104\u001a\u00020\u00162\b\u00105\u001a\u0004\u0018\u00010\nH\u0002J\u0006\u00106\u001a\u00020\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/dependencies/module/DeclaredDependenciesPanel;", "Lcom/android/tools/idea/gradle/structure/configurables/ui/dependencies/AbstractDependenciesPanel;", "Lcom/android/tools/idea/gradle/structure/configurables/dependencies/treeview/DependencySelection;", "module", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "(Lcom/android/tools/idea/gradle/structure/model/PsModule;Lcom/android/tools/idea/gradle/structure/configurables/PsContext;)V", "dependenciesTable", "Lcom/android/tools/idea/gradle/structure/configurables/ui/dependencies/DeclaredDependenciesTableView;", "Lcom/android/tools/idea/gradle/structure/model/PsBaseDependency;", "dependenciesTableModel", "Lcom/android/tools/idea/gradle/structure/configurables/dependencies/module/DeclaredDependenciesTableModel;", "eventDispatcher", "Lcom/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeEventDispatcher;", "getModule", "()Lcom/android/tools/idea/gradle/structure/model/PsModule;", "placeName", "", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "add", "", "listener", "Lcom/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeListener;", "createPlaceName", "moduleName", "dispose", "doSelectDependency", "toSelect", "getExtraToolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "focusComponent", "Ljavax/swing/JComponent;", "getPlaceName", "getPreferredFocusedComponent", "getSelection", "initializeDependencyDetails", "navigateTo", "Lcom/intellij/openapi/util/ActionCallback;", "place", "Lcom/intellij/ui/navigation/Place;", "requestFocus", "", "notifySelectionChanged", "selectDependency", "dependency", "setSelection", "selection", "", "updateDetailsAndIssues", "updateIssues", "selected", "updateTableColumnSizes", "RemoveDependencyAction", "intellij.android.projectSystem.gradle.psd"})
public final class DeclaredDependenciesPanel
extends AbstractDependenciesPanel
implements DependencySelection {
    @NotNull
    private final PsModule module;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    @NotNull
    private final DeclaredDependenciesTableModel dependenciesTableModel;
    @NotNull
    private final DeclaredDependenciesTableView<PsBaseDependency> dependenciesTable;
    @NotNull
    private final String placeName;
    @NotNull
    private final SelectionChangeEventDispatcher<PsBaseDependency> eventDispatcher;

    public DeclaredDependenciesPanel(@NotNull PsModule module2, @NotNull PsContext context2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super("Declared Dependencies", context2, module2);
        this.module = module2;
        this.updateQueue = MergingUpdateQueueUtilsKt.createMergingUpdateQueue("declaredDependenciesUpdates", context2, this);
        this.eventDispatcher = new SelectionChangeEventDispatcher();
        context2.getAnalyzerDaemon().onIssuesChange(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                MergingUpdateQueueUtilsKt.enqueueTagged(updateQueue, DeclaredDependenciesPanel.class, (Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        this.updateIssues(this.getSelection());
                    }
                }));
            }
        }));
        this.placeName = this.createPlaceName(this.module.getName());
        this.getContentsPanel().add((Component)this.createActionsPanel(), "North");
        this.initializeDependencyDetails();
        this.setIssuesViewer(new IssuesViewer(context2, new SingleModuleIssuesRenderer(context2)));
        this.dependenciesTableModel = new DeclaredDependenciesTableModel(this.module, context2);
        this.dependenciesTable = new DeclaredDependenciesTableView(this.dependenciesTableModel, context2);
        this.module.addDependencyChangedListener(this, (Function1<? super PsModule.DependencyChangedEvent, Unit>)((Function1)new Function1<PsModule.DependencyChangedEvent, Unit>(){

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull PsModule.DependencyChangedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                PsModule.DependencyChangedEvent dependencyChangedEvent = event;
                if (dependencyChangedEvent instanceof PsModule.DependencyAddedEvent) {
                    dependenciesTableModel.reset();
                    dependenciesTable.clearSelection();
                    dependenciesTable.setSelection(CollectionsKt.listOf((Object)((PsModule.DependencyAddedEvent)event).getDependency().getValue()));
                } else if (dependencyChangedEvent instanceof PsModule.DependencyModifiedEvent) {
                    this.updateDetails((PsBaseDependency)((PsModule.DependencyModifiedEvent)event).getDependency().getValue());
                    dependenciesTableModel.reset((PsBaseDependency)((PsModule.DependencyModifiedEvent)event).getDependency().getValue());
                } else {
                    void $this$filterTo$iv$iv;
                    void $this$mapTo$iv$iv;
                    Collection collection2 = dependenciesTable.getSelection();
                    Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"dependenciesTable.selection");
                    Iterable $this$map$iv = collection2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        PsBaseDependency psBaseDependency = (PsBaseDependency)item$iv$iv;
                        Collection collection3 = destination$iv$iv;
                        boolean bl = false;
                        collection3.add(TuplesKt.to((Object)it.toText(), (Object)it.getJoinedConfigurationNames()));
                    }
                    Set selectedKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    dependenciesTableModel.reset();
                    List list2 = dependenciesTableModel.getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"dependenciesTableModel.items");
                    Iterable $this$filter$iv = list2;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        PsBaseDependency it = (PsBaseDependency)element$iv$iv;
                        boolean bl = false;
                        if (!selectedKeys.contains(TuplesKt.to((Object)it.toText(), (Object)it.getJoinedConfigurationNames()))) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List newSelection = (List)destination$iv$iv2;
                    if (!Intrinsics.areEqual((Object)newSelection, (Object)dependenciesTable.getSelection())) {
                        dependenciesTable.setSelection(newSelection);
                    }
                }
            }
        }));
        this.dependenciesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                if (!it.getValueIsAdjusting()) {
                    this.updateDetailsAndIssues();
                    this.notifySelectionChanged();
                }
            }
        });
        this.dependenciesTable.selectFirstRow();
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.dependenciesTable)));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(dependenciesTable)");
        JScrollPane scrollPane = jScrollPane;
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        this.getContentsPanel().add((Component)scrollPane, "Center");
        this.updateTableColumnSizes();
    }

    @NotNull
    public final PsModule getModule() {
        return this.module;
    }

    private final String createPlaceName(String moduleName2) {
        return "module.dependencies.place";
    }

    private final void initializeDependencyDetails() {
        this.addDetails(new SingleDeclaredLibraryDependencyDetails(this.getContext()));
        PsContext psContext = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)psContext, (String)"context");
        this.addDetails(new JarDependencyDetails(psContext, true));
        this.addDetails(new ModuleDependencyDetails(this.getContext(), true));
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)((Object)this.dependenciesTable);
    }

    @Override
    @NotNull
    public String getPlaceName() {
        return this.placeName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<AnAction> getExtraToolbarActions(@NotNull JComponent focusComponent) {
        void $this$getExtraToolbarActions_u24lambda_u2d0;
        RemoveDependencyAction removeDependencyAction;
        Intrinsics.checkNotNullParameter((Object)focusComponent, (String)"focusComponent");
        ArrayList actions2 = Lists.newArrayList();
        RemoveDependencyAction removeDependencyAction2 = removeDependencyAction = new RemoveDependencyAction();
        ArrayList arrayList = actions2;
        boolean bl = false;
        $this$getExtraToolbarActions_u24lambda_u2d0.registerCustomShortcutSet(CommonShortcuts.getDelete(), focusComponent);
        arrayList.add(removeDependencyAction);
        Intrinsics.checkNotNullExpressionValue((Object)actions2, (String)"actions");
        return actions2;
    }

    public final void updateTableColumnSizes() {
        this.dependenciesTable.updateColumnSizes();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.dependenciesTable);
    }

    public final void add(@NotNull SelectionChangeListener<PsBaseDependency> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.eventDispatcher.addListener(listener2, this);
    }

    @Override
    @Nullable
    public PsBaseDependency getSelection() {
        return this.dependenciesTable.getSelectionIfSingle();
    }

    @NotNull
    public ActionCallback setSelection(@Nullable Collection<? extends PsBaseDependency> selection) {
        Collection<? extends PsBaseDependency> collection2 = selection;
        if (collection2 == null || collection2.isEmpty()) {
            this.dependenciesTable.clearSelection();
        } else {
            this.dependenciesTable.setSelection(CollectionsKt.toSet((Iterable)selection));
        }
        this.updateDetailsAndIssues();
        History history = this.getHistory();
        if (history != null) {
            history.pushQueryPlace();
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"DONE");
        return actionCallback;
    }

    private final void updateDetailsAndIssues() {
        PsBaseDependency selected = this.getSelection();
        super.updateDetails(selected);
        this.updateIssues(selected);
    }

    private final void notifySelectionChanged() {
        PsBaseDependency selected = this.getSelection();
        if (selected != null) {
            this.eventDispatcher.selectionChanged(selected);
        }
    }

    private final void updateIssues(PsBaseDependency selected) {
        List<PsIssue> list2;
        List<PsIssue> list3;
        DeclaredDependenciesPanel declaredDependenciesPanel = this;
        PsBaseDependency psBaseDependency = selected;
        if (psBaseDependency != null) {
            PsBaseDependency psBaseDependency2 = psBaseDependency;
            DeclaredDependenciesPanel declaredDependenciesPanel2 = declaredDependenciesPanel;
            boolean bl = false;
            list3 = this.getContext().getAnalyzerDaemon().getIssues().findIssues(selected.getPath(), null);
            declaredDependenciesPanel = declaredDependenciesPanel2;
        } else {
            list3 = list2 = null;
        }
        if (list3 == null) {
            list2 = CollectionsKt.emptyList();
        }
        PsBaseDependency psBaseDependency3 = selected;
        declaredDependenciesPanel.displayIssues((Collection<PsIssue>)list2, psBaseDependency3 != null ? psBaseDependency3.getPath() : null);
    }

    public final void selectDependency(@Nullable String dependency) {
        if (StringUtil.isEmpty((String)dependency)) {
            this.dependenciesTable.clearSelection();
            return;
        }
        String string = dependency;
        Intrinsics.checkNotNull((Object)string);
        this.doSelectDependency(string);
    }

    @NotNull
    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        String pathText;
        Object path2;
        if (place != null && (path2 = place.getPath(this.placeName)) instanceof String && !(((CharSequence)(pathText = (String)path2)).length() == 0)) {
            this.dependenciesTable.requestFocusInWindow();
            this.doSelectDependency(pathText);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"DONE");
        return actionCallback;
    }

    private final void doSelectDependency(String toSelect) {
        this.dependenciesTable.selectDependency(toSelect);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/dependencies/module/DeclaredDependenciesPanel$RemoveDependencyAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/android/tools/idea/gradle/structure/configurables/dependencies/module/DeclaredDependenciesPanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.projectSystem.gradle.psd"})
    private final class RemoveDependencyAction
    extends DumbAwareAction {
        public RemoveDependencyAction() {
            super("Remove Dependency...", "", IconUtil.getRemoveIcon());
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DependencyDetails details = DeclaredDependenciesPanel.this.getCurrentDependencyDetails();
            e.getPresentation().setEnabled(details != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PsBaseDependency dependency = DeclaredDependenciesPanel.this.getSelection();
            if (dependency != null && Messages.showYesNoDialog((Project)e.getProject(), (String)("Remove dependency '" + dependency.getJoinedConfigurationNames() + " " + dependency.getName() + "'?"), (String)"Remove Dependency", (Icon)Messages.getQuestionIcon()) == 0) {
                DeclaredDependenciesPanel.this.getModule().removeDependency((PsDeclaredDependency)dependency);
                DeclaredDependenciesPanel.this.dependenciesTable.selectFirstRow();
            }
        }
    }
}

