/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.resolve;

import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;

public class AndroidDslContributor
implements GradleMethodContextContributor {
    @NonNls
    private static final String DSL_ANDROID = "android";
    @NonNls
    private static final String ANDROID_FQCN = "com.android.build.gradle.internal.dsl.BaseAppModuleExtension";
    @NonNls
    private static final String ANDROID_LIB_FQCN = "com.android.build.gradle.LibraryExtension";
    private static final Key<PsiElement> CONTRIBUTOR_KEY = Key.create((String)"AndroidDslContributor.key");
    private static final Map<String, String> ourDslForClassMap = ImmutableMap.of((Object)"com.android.builder.DefaultProductFlavor", (Object)"com.android.build.gradle.internal.dsl.ProductFlavorDsl", (Object)"com.android.builder.DefaultBuildType", (Object)"com.android.build.gradle.internal.dsl.BuildTypeDsl", (Object)"com.android.builder.model.SigningConfig", (Object)"com.android.build.gradle.internal.dsl.SigningConfigDsl");

    @Nullable
    public DelegatesToInfo getDelegatesToInfo(@NotNull GrClosableBlock closure2) {
        GrMethodCallExpression methodCallExpression;
        PsiElement parent2 = closure2.getParent();
        if (parent2 instanceof GrMethodCallExpression && (methodCallExpression = (GrMethodCallExpression)parent2).getInvokedExpression().getText().equals("kotlinOptions")) {
            PsiClassType kotlinOptions = TypesUtil.createType((String)"org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions", (PsiElement)closure2);
            return new DelegatesToInfo((PsiType)kotlinOptions, 1);
        }
        return null;
    }

    public boolean process(@NotNull List<String> callStack, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiElement place) {
        String topLevel = (String)ContainerUtil.getLastItem(callStack, null);
        if (!DSL_ANDROID.equals(topLevel)) {
            return true;
        }
        if (callStack.size() == 1) {
            PsiClass contributorClass;
            String fqcn = AndroidDslContributor.resolveAndroidExtension(place.getContainingFile());
            PsiClass psiClass = contributorClass = fqcn == null ? null : AndroidDslContributor.findClassByName(place.getProject(), place.getResolveScope(), fqcn);
            if (contributorClass != null) {
                String qualifiedName = contributorClass.getQualifiedName();
                if (qualifiedName == null) {
                    qualifiedName = fqcn;
                }
                AndroidDslContributor.resolveToMethodWithClosure(place, (PsiElement)contributorClass, qualifiedName, processor, state2);
                AndroidDslContributor.cacheContributorInfo(place, (PsiElement)contributorClass);
            }
            return true;
        }
        PsiElement parentContributor = AndroidDslContributor.getParentContributor(place);
        if (parentContributor == null) {
            return true;
        }
        if (parentContributor instanceof PsiClass) {
            PsiMethod method2 = AndroidDslContributor.findAndProcessContributingMethod(callStack.get(0), processor, state2, place, (PsiClass)parentContributor);
            AndroidDslContributor.cacheContributorInfo(place, (PsiElement)method2);
            return true;
        }
        if (!(parentContributor instanceof PsiMethod)) {
            return true;
        }
        ParametrizedTypeExtractor typeExtractor = AndroidDslContributor.getTypeExtractor((PsiMethod)parentContributor);
        if (typeExtractor == null) {
            Logger.getInstance(AndroidDslContributor.class).info("inside the closure of a method, but unable to extract the closure parameter's type.");
            return true;
        }
        if (typeExtractor.hasNamedDomainObjectContainer()) {
            String namedDomainObject = typeExtractor.getNamedDomainObject();
            assert (namedDomainObject != null) : typeExtractor.getCanonicalType();
            PsiClass contributorClass = AndroidDslContributor.findClassByName(place.getProject(), place.getResolveScope(), namedDomainObject);
            if (contributorClass != null) {
                String qualifiedName = contributorClass.getQualifiedName();
                if (qualifiedName == null) {
                    qualifiedName = namedDomainObject;
                }
                AndroidDslContributor.resolveToMethodWithClosure(place, (PsiElement)contributorClass, qualifiedName, processor, state2);
                AndroidDslContributor.cacheContributorInfo(place, (PsiElement)contributorClass);
            }
            return true;
        }
        if (typeExtractor.isClosure()) {
            String clz = typeExtractor.getClosureType();
            assert (clz != null) : typeExtractor.getCanonicalType();
            PsiClass contributorClass = AndroidDslContributor.findClassByName(place.getProject(), place.getResolveScope(), clz);
            if (contributorClass == null) {
                return true;
            }
            PsiMethod method3 = AndroidDslContributor.findAndProcessContributingMethod(callStack.get(0), processor, state2, place, contributorClass);
            AndroidDslContributor.cacheContributorInfo(place, (PsiElement)method3);
        }
        return true;
    }

    private static void resolveToMethodWithClosure(PsiElement place, PsiElement resolveToElement, String closureTypeFqcn, PsiScopeProcessor processor, ResolveState state2) {
        if (place.getParent() instanceof GrMethodCallExpression && ResolveUtilKt.shouldProcessMethods((PsiScopeProcessor)processor)) {
            GrLightMethodBuilder methodWithClosure = GradleResolverUtil.createMethodWithClosure((String)place.getText(), (String)closureTypeFqcn, null, (PsiElement)place);
            if (methodWithClosure != null) {
                processor.execute((PsiElement)methodWithClosure, state2);
                methodWithClosure.setNavigationElement(resolveToElement);
            }
        } else if (place.getParent() instanceof GrReferenceExpression && ResolveUtilKt.shouldProcessLocals((PsiScopeProcessor)processor)) {
            GrLightVariable variable = new GrLightVariable(place.getManager(), place.getText(), closureTypeFqcn, place);
            processor.execute((PsiElement)variable, state2);
        }
    }

    @Nullable
    private static PsiMethod findAndProcessContributingMethod(String symbol, PsiScopeProcessor processor, ResolveState state2, PsiElement place, PsiClass contributorClass) {
        PsiMethod method2 = AndroidDslContributor.getContributingMethod(place, contributorClass, symbol);
        if (method2 == null) {
            return null;
        }
        ParametrizedTypeExtractor typeExtractor = AndroidDslContributor.getTypeExtractor(method2);
        if (typeExtractor != null && !typeExtractor.hasNamedDomainObjectContainer() && typeExtractor.isClosure()) {
            String clz = typeExtractor.getClosureType();
            if (clz == null) {
                clz = "java.lang.Object";
            }
            if (ourDslForClassMap.containsKey(clz)) {
                clz = ourDslForClassMap.get(clz);
            }
            AndroidDslContributor.resolveToMethodWithClosure(place, (PsiElement)method2, clz, processor, state2);
        } else if (ResolveUtilKt.shouldProcessMethods((PsiScopeProcessor)processor)) {
            GrLightMethodBuilder builder2 = new GrLightMethodBuilder(place.getManager(), method2.getName());
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)place.getManager().getProject());
            PsiArrayType type = new PsiArrayType((PsiType)factory2.createTypeByFQClassName("java.lang.Object", place.getResolveScope()));
            builder2.addParameter((GrParameter)new GrLightParameter("param", (PsiType)type, (PsiElement)builder2));
            PsiClassType retType = factory2.createTypeByFQClassName("java.lang.Object", place.getResolveScope());
            builder2.setReturnType((PsiType)retType);
            processor.execute((PsiElement)builder2, state2);
            builder2.setNavigationElement((PsiElement)method2);
        }
        return method2;
    }

    @Nullable
    private static PsiMethod getContributingMethod(PsiElement place, PsiClass contributorClass, String methodName) {
        PsiMethod[] methodsByName;
        GrMethodCall call = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethodCall.class);
        if (call == null) {
            return null;
        }
        GrArgumentList args = call.getArgumentList();
        int argsCount = GradleResolverUtil.getGrMethodArumentsCount((GrArgumentList)args);
        for (PsiMethod method2 : methodsByName = AndroidDslContributor.findMethodByName(contributorClass, methodName)) {
            if (method2.getParameterList().getParametersCount() != argsCount) continue;
            return method2;
        }
        return methodsByName.length > 0 ? methodsByName[0] : null;
    }

    @NotNull
    private static PsiMethod[] findMethodByName(PsiClass contributorClass, String methodName) {
        List<String> possibleMethods = Arrays.asList(methodName, GroovyPropertyUtils.getSetterName((String)methodName), GroovyPropertyUtils.getGetterNameNonBoolean((String)methodName), GroovyPropertyUtils.getGetterNameBoolean((String)methodName));
        for (String possibleMethod : possibleMethods) {
            PsiMethod[] methods2 = contributorClass.findMethodsByName(possibleMethod, true);
            if (methods2.length <= 0) continue;
            return methods2;
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @Nullable
    private static ParametrizedTypeExtractor getTypeExtractor(PsiMethod parentContributor) {
        PsiParameter[] parameters2 = parentContributor.getParameterList().getParameters();
        if (parameters2.length < 1) {
            return null;
        }
        PsiParameter param = parameters2[parameters2.length - 1];
        String parameterType = param.getType().getCanonicalText();
        return new ParametrizedTypeExtractor(parameterType);
    }

    @Nullable
    private static PsiElement getParentContributor(PsiElement place) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GrClosableBlock closeableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)place, GrClosableBlock.class);
        if (closeableBlock == null || !(closeableBlock.getParent() instanceof GrMethodCall)) {
            return null;
        }
        PsiElement parentContributor = (PsiElement)closeableBlock.getParent().getUserData(CONTRIBUTOR_KEY);
        if (parentContributor == null) {
            return null;
        }
        return parentContributor;
    }

    @Nullable
    public static PsiClass findClassByName(Project project, GlobalSearchScope resolveScope, @NotNull String fqcn) {
        if (ourDslForClassMap.containsKey(fqcn)) {
            fqcn = ourDslForClassMap.get(fqcn);
        }
        return JavaPsiFacade.getInstance((Project)project).findClass(fqcn, resolveScope);
    }

    private static void cacheContributorInfo(@NotNull PsiElement place, @Nullable PsiElement contributor) {
        if (contributor == null) {
            return;
        }
        if (!(place.getParent() instanceof GrMethodCall)) {
            return;
        }
        GrMethodCall method2 = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethodCall.class);
        if (method2 != null) {
            method2.putUserData(CONTRIBUTOR_KEY, (Object)contributor);
        }
    }

    @Nullable
    private static String resolveAndroidExtension(PsiFile file2) {
        GradleAndroidModel androidModuleModel;
        Module[] modules2 = ModuleManager.getInstance((Project)file2.getProject()).getModules();
        Module found = null;
        for (Module module2 : modules2) {
            GradleModuleModel gradleModuleModel;
            GradleFacet facet2 = GradleFacet.getInstance(module2);
            if (facet2 == null || (gradleModuleModel = facet2.getGradleModuleModel()) == null || !Objects.equals(gradleModuleModel.getBuildFile(), file2.getVirtualFile())) continue;
            found = module2;
            break;
        }
        if (found != null && (androidModuleModel = GradleAndroidModel.get(found)) != null) {
            if (androidModuleModel.getAndroidProject().getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_APP) {
                return ANDROID_FQCN;
            }
            if (androidModuleModel.getAndroidProject().getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_LIBRARY) {
                return ANDROID_LIB_FQCN;
            }
        }
        assert (file2 instanceof GroovyFile);
        String fileContents = file2.getText();
        if (fileContents.contains("com.android.application") || fileContents.contains(DSL_ANDROID)) {
            return ANDROID_FQCN;
        }
        if (fileContents.contains("com.android.library") || fileContents.contains("android-library")) {
            return ANDROID_LIB_FQCN;
        }
        return null;
    }

    @VisibleForTesting
    static class ParametrizedTypeExtractor {
        private static final String GRADLE_ACTION = "org.gradle.api.Action";
        private static final Pattern GRADLE_ACTION_PATTERN = Pattern.compile(Pattern.quote("org.gradle.api.Action") + "<([^<>]+)(?:<([^<>]+)>)?>");
        private static final String KOTLIN_FUNCTION1 = "kotlin.jvm.functions.Function1";
        private static final Pattern KOTLIN_FUNCTION1_PATTERN = Pattern.compile(Pattern.quote("kotlin.jvm.functions.Function1") + "<([^<>]+)(?:<([^<>]+)>)?,kotlin.Unit>");
        private static final String GRADLE_NAMED_DOMAIN_OBJECT_CONTAINER_FQCN = "org.gradle.api.NamedDomainObjectContainer";
        private final List<String> myParameterTypes;
        private final String myCanonicalType;

        public ParametrizedTypeExtractor(String canonicalType) {
            this.myCanonicalType = canonicalType;
            this.myParameterTypes = this.parseCanonicalType(canonicalType);
        }

        private ArrayList<String> parseCanonicalType(String canonicalType) {
            Pattern pattern;
            ArrayList<String> result2 = new ArrayList<String>();
            if (canonicalType.startsWith(GRADLE_ACTION)) {
                result2.add(GRADLE_ACTION);
                pattern = GRADLE_ACTION_PATTERN;
            } else if (canonicalType.startsWith(KOTLIN_FUNCTION1)) {
                result2.add(KOTLIN_FUNCTION1);
                pattern = KOTLIN_FUNCTION1_PATTERN;
            } else {
                result2.add(canonicalType);
                return result2;
            }
            Matcher matcher = pattern.matcher(canonicalType);
            if (matcher.matches()) {
                result2.add(matcher.group(1));
                if (matcher.group(2) != null) {
                    result2.add(matcher.group(2));
                }
            }
            return result2;
        }

        public String getCanonicalType() {
            return this.myCanonicalType;
        }

        public boolean isClosure() {
            return this.myParameterTypes.contains(GRADLE_ACTION) || this.myParameterTypes.contains(KOTLIN_FUNCTION1);
        }

        @Nullable
        public String getClosureType() {
            int i;
            if (!this.isClosure()) {
                return null;
            }
            StringBuilder sb = new StringBuilder(100);
            for (i = 1; i < this.myParameterTypes.size(); ++i) {
                String type = this.myParameterTypes.get(i);
                type = type.replace("? extends ", "");
                type = type.replace("? super ", "");
                sb.append(type);
                if (i == this.myParameterTypes.size() - 1) continue;
                sb.append('<');
            }
            for (i = 1; i < this.myParameterTypes.size() - 1; ++i) {
                sb.append('>');
            }
            return sb.toString();
        }

        @Nullable
        public String getNamedDomainObject() {
            return this.hasNamedDomainObjectContainer() ? (String)ContainerUtil.getLastItem(this.myParameterTypes) : null;
        }

        public boolean hasNamedDomainObjectContainer() {
            for (String type : this.myParameterTypes) {
                if (!type.contains(GRADLE_NAMED_DOMAIN_OBJECT_CONTAINER_FQCN)) continue;
                return true;
            }
            return false;
        }
    }
}

