/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.service.notification.OpenProjectJdkLocationListener;
import com.android.tools.idea.gradle.service.notification.UseJdkAsProjectJdkListener;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.utils.FileUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleJdkInvalidEvent;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.notification.GradleNotificationExtension;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/gradle/service/notification/GradleJvmNotificationExtension;", "Lorg/jetbrains/plugins/gradle/service/notification/GradleNotificationExtension;", "()V", "customize", "", "notificationData", "Lcom/intellij/openapi/externalSystem/service/notification/NotificationData;", "project", "Lcom/intellij/openapi/project/Project;", "error", "", "Companion", "InvalidJdkReasonWithMessage", "intellij.android.projectSystem.gradle"})
public final class GradleJvmNotificationExtension
extends GradleNotificationExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void customize(@NotNull NotificationData notificationData, @NotNull Project project, @Nullable Throwable error) {
        Intrinsics.checkNotNullParameter((Object)notificationData, (String)"notificationData");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.customize(notificationData, project, error);
        String expectedPrefix = GradleBundle.message((String)"gradle.jvm.is.invalid", (Object[])new Object[0]);
        String string = notificationData.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"notificationData.message");
        Intrinsics.checkNotNullExpressionValue((Object)expectedPrefix, (String)"expectedPrefix");
        if (StringsKt.startsWith$default((String)string, (String)expectedPrefix, (boolean)false, (int)2, null)) {
            InvalidJdkReasonWithMessage invalidJdkReasonWithMessage;
            ProjectSettingsService service;
            UseJdkAsProjectJdkListener listener2;
            String defaultPath;
            Sdk defaultJdk;
            String absolutePath;
            UseJdkAsProjectJdkListener listener3;
            IdeSdks ideSdks = IdeSdks.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"getInstance()");
            IdeSdks ideSdks2 = ideSdks;
            InvalidJdkReasonWithMessage errorReason = Companion.getInvalidJdkReason(project);
            Object modifiedMessage = expectedPrefix;
            if (errorReason != null) {
                modifiedMessage = (String)modifiedMessage + " " + errorReason.getMessage();
            }
            String string2 = notificationData.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"notificationData.message");
            String suffixMessage = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)string2, (CharSequence)expectedPrefix))).toString();
            if (((CharSequence)suffixMessage).length() > 0) {
                modifiedMessage = (String)modifiedMessage + "\n" + suffixMessage;
            }
            notificationData.setMessage((String)modifiedMessage + "\n");
            List registeredListeners = notificationData.getRegisteredListenerIds();
            Path embeddedJdkPath = ideSdks2.getEmbeddedJdkPath();
            if (embeddedJdkPath != null && ideSdks2.validateJdkPath(embeddedJdkPath) != null && !registeredListeners.contains((listener3 = new UseJdkAsProjectJdkListener(project, absolutePath = ((Object)embeddedJdkPath.toAbsolutePath()).toString(), ".embedded")).getId())) {
                notificationData.setMessage(notificationData.getMessage() + "<a href=\"" + listener3.getId() + "\">Use Embedded JDK (" + absolutePath + ")</a>\n");
                notificationData.setListener(listener3.getId(), (NotificationListener)listener3);
                registeredListeners = notificationData.getRegisteredListenerIds();
            }
            Sdk sdk = defaultJdk = ideSdks2.getJdk();
            String string3 = defaultPath = sdk != null ? sdk.getHomePath() : null;
            if (!(defaultPath == null || ideSdks2.validateJdkPath(Paths.get(defaultPath, new String[0])) == null || embeddedJdkPath != null && FileUtils.isSameFile((File)embeddedJdkPath.toFile(), (File)new File(defaultPath)) || registeredListeners.contains((listener2 = new UseJdkAsProjectJdkListener(project, defaultPath, null, 4, null)).getId()))) {
                notificationData.setMessage(notificationData.getMessage() + "<a href=\"" + listener2.getId() + "\">Use JDK " + defaultJdk.getName() + " (" + defaultPath + ")</a>\n");
                notificationData.setListener(listener2.getId(), (NotificationListener)listener2);
                registeredListeners = notificationData.getRegisteredListenerIds();
            }
            if (registeredListeners != null && !registeredListeners.contains("open.project.jdk.location") && (service = ProjectSettingsService.getInstance((Project)project)) instanceof AndroidProjectSettingsService) {
                OpenProjectJdkLocationListener listener4 = new OpenProjectJdkLocationListener((AndroidProjectSettingsService)service);
                notificationData.setMessage(notificationData.getMessage() + "<a href=\"open.project.jdk.location\">Change JDK location</a>\n");
                notificationData.setListener("open.project.jdk.location", (NotificationListener)listener4);
            }
            if ((invalidJdkReasonWithMessage = errorReason) == null || (invalidJdkReasonWithMessage = invalidJdkReasonWithMessage.getReason()) == null) {
                invalidJdkReasonWithMessage = GradleJdkInvalidEvent.InvalidJdkReason.INVALID_JDK_UNSPECIFIED_REASON;
            }
            Companion.reportInvalidJdkReasonToUsageTracker(project, (GradleJdkInvalidEvent.InvalidJdkReason)invalidJdkReasonWithMessage);
        }
    }

    @JvmStatic
    @Nullable
    public static final InvalidJdkReasonWithMessage getInvalidJdkReason(@NotNull Project project) {
        return Companion.getInvalidJdkReason(project);
    }

    @JvmStatic
    public static final void reportInvalidJdkReasonToUsageTracker(@NotNull Project project, @NotNull GradleJdkInvalidEvent.InvalidJdkReason reason) {
        Companion.reportInvalidJdkReasonToUsageTracker(project, reason);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/gradle/service/notification/GradleJvmNotificationExtension$Companion;", "", "()V", "getEmptyJdkPathReason", "Lcom/android/tools/idea/gradle/service/notification/GradleJvmNotificationExtension$InvalidJdkReasonWithMessage;", "project", "Lcom/intellij/openapi/project/Project;", "getInvalidJdkReason", "getReasonFromIdeSdkMessage", "ideMessage", "", "projectJdkInvalidMessage", "jdkName", "reportInvalidJdkReasonToUsageTracker", "", "reason", "Lcom/google/wireless/android/sdk/stats/GradleJdkInvalidEvent$InvalidJdkReason;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final InvalidJdkReasonWithMessage getInvalidJdkReason(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GradleInstallationManager gradleInstallationManager = GradleInstallationManager.getInstance();
            String string = project.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            String projectJdkPath = gradleInstallationManager.getGradleJvmPath(project, string);
            return projectJdkPath == null ? this.getEmptyJdkPathReason(project) : this.getReasonFromIdeSdkMessage(IdeSdks.getInstance().generateInvalidJdkReason(Paths.get(projectJdkPath, new String[0])));
        }

        @JvmStatic
        public final void reportInvalidJdkReasonToUsageTracker(@NotNull Project project, @NotNull GradleJdkInvalidEvent.InvalidJdkReason reason) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_SYSTEM).setKind(AndroidStudioEvent.EventKind.GRADLE_JDK_INVALID).setGradleJdkInvalidEvent(GradleJdkInvalidEvent.newBuilder().setReason(reason));
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n           \u2026lder().setReason(reason))");
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(builder2, project));
        }

        private final InvalidJdkReasonWithMessage getReasonFromIdeSdkMessage(String ideMessage) {
            if (ideMessage == null) {
                return null;
            }
            GradleJdkInvalidEvent.InvalidJdkReason reason = GradleJdkInvalidEvent.InvalidJdkReason.INVALID_JDK_UNSPECIFIED_REASON;
            if (StringsKt.startsWith$default((String)ideMessage, (String)"There is no bin/javac in ", (boolean)false, (int)2, null)) {
                reason = GradleJdkInvalidEvent.InvalidJdkReason.INVALID_JDK_UNSPECIFIED_REASON;
            } else if (StringsKt.startsWith$default((String)ideMessage, (String)"Required JDK files from", (boolean)false, (int)2, null)) {
                reason = GradleJdkInvalidEvent.InvalidJdkReason.INVALID_JDK_MISSING_FILES;
            }
            return new InvalidJdkReasonWithMessage(ideMessage, reason);
        }

        /*
         * Unable to fully structure code
         */
        private final InvalidJdkReasonWithMessage getEmptyJdkPathReason(Project project) {
            v0 = project.getBasePath();
            Intrinsics.checkNotNull((Object)v0);
            basePath = v0;
            settings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(basePath);
            if (settings == null) {
                v1 = ProjectRootManager.getInstance((Project)project).getProjectSdkName();
                if (v1 == null) {
                    return new InvalidJdkReasonWithMessage("Neither gradleJvm nor project-jdk-name are defined.", GradleJdkInvalidEvent.InvalidJdkReason.INVALID_JDK_UNDEFINED_JDK);
                }
                jdkName = v1;
                return this.projectJdkInvalidMessage(jdkName);
            }
            gradleJvm = settings.getGradleJvm();
            if (gradleJvm == null) ** GOTO lbl-1000
            tmp = -1;
            switch (gradleJvm.hashCode()) {
                case 1414732464: {
                    if (gradleJvm.equals("#USE_PROJECT_JDK")) {
                        tmp = 1;
                    }
                    break;
                }
                case 684858615: {
                    if (gradleJvm.equals("#JAVA_INTERNAL")) {
                        tmp = 2;
                    }
                    break;
                }
                case -610369511: {
                    if (gradleJvm.equals("#JAVA_HOME")) {
                        tmp = 3;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: lbl-1000:
                // 2 sources

                {
                    v2 = ProjectRootManager.getInstance((Project)project).getProjectSdkName();
                    if (v2 == null) {
                        return new InvalidJdkReasonWithMessage("project-jdk-name is not defined.", GradleJdkInvalidEvent.InvalidJdkReason.INVALID_JDK_PROJECT_JDK_UNDEFINED);
                    }
                    jdkName = v2;
                    return this.projectJdkInvalidMessage(jdkName);
                }
                case 3: {
                    return new InvalidJdkReasonWithMessage("Project set to use JAVA_HOME but the path is invalid.", GradleJdkInvalidEvent.InvalidJdkReason.INVALID_JDK_JAVA_HOME_INVALID);
                }
                case 2: {
                    return new InvalidJdkReasonWithMessage("SystemProperties.javaHome is not valid.", GradleJdkInvalidEvent.InvalidJdkReason.INVALID_JDK_JAVA_HOME_INVALID);
                }
            }
            return this.projectJdkInvalidMessage(gradleJvm);
        }

        private final InvalidJdkReasonWithMessage projectJdkInvalidMessage(String jdkName) {
            SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"getJavaSdkType()");
            SdkType javaSdkType = sdkType;
            Sdk sdk = ProjectJdkTable.getInstance().findJdk(jdkName, javaSdkType.getName());
            if (sdk == null) {
                return new InvalidJdkReasonWithMessage("Could not find the required " + javaSdkType.getName() + ".", GradleJdkInvalidEvent.InvalidJdkReason.INVALID_JDK_NAME_NOT_IN_TABLE);
            }
            Sdk existingJdk = sdk;
            String string = existingJdk.getHomePath();
            if (string == null) {
                return new InvalidJdkReasonWithMessage("JDK home path is not defined.", GradleJdkInvalidEvent.InvalidJdkReason.INVALID_JDK_HOME_PATH_NOT_DEFINED);
            }
            String jdkPath = string;
            return this.getReasonFromIdeSdkMessage(IdeSdks.getInstance().generateInvalidJdkReason(Paths.get(jdkPath, new String[0])));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/gradle/service/notification/GradleJvmNotificationExtension$InvalidJdkReasonWithMessage;", "", "message", "", "reason", "Lcom/google/wireless/android/sdk/stats/GradleJdkInvalidEvent$InvalidJdkReason;", "(Ljava/lang/String;Lcom/google/wireless/android/sdk/stats/GradleJdkInvalidEvent$InvalidJdkReason;)V", "getMessage", "()Ljava/lang/String;", "getReason", "()Lcom/google/wireless/android/sdk/stats/GradleJdkInvalidEvent$InvalidJdkReason;", "intellij.android.projectSystem.gradle"})
    public static final class InvalidJdkReasonWithMessage {
        @NotNull
        private final String message;
        @NotNull
        private final GradleJdkInvalidEvent.InvalidJdkReason reason;

        public InvalidJdkReasonWithMessage(@NotNull String message2, @NotNull GradleJdkInvalidEvent.InvalidJdkReason reason) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.message = message2;
            this.reason = reason;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final GradleJdkInvalidEvent.InvalidJdkReason getReason() {
            return this.reason;
        }
    }
}

