/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProvider;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MakeBeforeRunTaskProviderUtil {
    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(MakeBeforeRunTaskProviderUtil.class);
    }

    public static List<RunConfiguration> getConfigurationsMissingBeforeRunTask(@NotNull Project project) {
        if (project.isDisposed()) {
            return new ArrayList<RunConfiguration>();
        }
        return RunManagerEx.getInstanceEx((Project)project).getAllConfigurationsList().stream().filter(config2 -> MakeBeforeRunTaskProviderUtil.isBeforeRunTaskMissing(project, config2)).collect(Collectors.toList());
    }

    public static List<RunConfiguration> fixConfigurationsMissingBeforeRunTask(@NotNull Project project) {
        ArrayList<RunConfiguration> result2 = new ArrayList<RunConfiguration>();
        if (project.isDisposed()) {
            return result2;
        }
        MakeBeforeRunTaskProviderUtil.getLogger().info(String.format("Trying to fix run configurations of project \"%s\"", project.getName()));
        List<RunConfiguration> list2 = MakeBeforeRunTaskProviderUtil.getConfigurationsMissingBeforeRunTask(project);
        for (RunConfiguration config2 : list2) {
            MakeBeforeRunTaskProviderUtil.getLogger().info(String.format("Trying to fix config \"%s\"", config2.getName()));
            if (!MakeBeforeRunTaskProviderUtil.addBeforeRunTaskToConfig(project, config2)) continue;
            result2.add(config2);
        }
        return result2;
    }

    private static boolean isBeforeRunTaskMissing(@NotNull Project project, @NotNull RunConfiguration config2) {
        BeforeRunTaskProvider taskProvider = BeforeRunTaskProvider.getProvider((Project)project, MakeBeforeRunTaskProvider.ID);
        if (!(taskProvider instanceof MakeBeforeRunTaskProvider)) {
            return false;
        }
        MakeBeforeRunTaskProvider beforeRunTaskProvider = (MakeBeforeRunTaskProvider)taskProvider;
        if (!beforeRunTaskProvider.configurationTypeIsSupported(config2)) {
            return false;
        }
        if (!beforeRunTaskProvider.configurationTypeIsEnabledByDefault(config2)) {
            return false;
        }
        List tasks = RunManagerEx.getInstanceEx((Project)project).getBeforeRunTasks(config2, MakeBeforeRunTaskProvider.ID);
        return !tasks.stream().anyMatch(task2 -> task2.isEnabled());
    }

    private static boolean addBeforeRunTaskToConfig(@NotNull Project project, @NotNull RunConfiguration config2) {
        RunManagerEx runManagerEx = RunManagerEx.getInstanceEx((Project)project);
        MakeBeforeRunTaskProvider provider2 = (MakeBeforeRunTaskProvider)BeforeRunTaskProvider.getProvider((Project)project, MakeBeforeRunTaskProvider.ID);
        if (provider2 == null) {
            MakeBeforeRunTaskProviderUtil.getLogger().warn(String.format("Skipping config \"%s\" because task provider is not found", config2.getName()));
            return false;
        }
        MakeBeforeRunTask newTask = provider2.createTask(config2);
        if (newTask == null) {
            MakeBeforeRunTaskProviderUtil.getLogger().warn(String.format("Skipping config \"%s\" because provider returned a null task", config2.getName()));
            return false;
        }
        List tasks = runManagerEx.getBeforeRunTasks(config2).stream().collect(Collectors.toList());
        tasks.add(newTask);
        runManagerEx.setBeforeRunTasks(config2, tasks);
        MakeBeforeRunTaskProviderUtil.getLogger().info(String.format("Added missing task to config \"%s\"", config2.getName()));
        return true;
    }
}

