/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ddmlib.IDevice;
import com.android.ide.common.util.DeviceUtils;
import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.gradle.run.AndroidDeviceSpecImpl;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidDeviceSpec;
import com.google.common.collect.Ordering;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002\u001a,\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\rH\u0007\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u001a\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0019"}, d2={"DEVICE_SPEC_TIMEOUT_SECONDS", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "combineDeviceLanguages", "", "", "devices", "Lcom/android/tools/idea/run/AndroidDevice;", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "createSpec", "Lcom/android/tools/idea/run/AndroidDeviceSpec;", "Lcom/android/ddmlib/IDevice;", "writeJson", "", "writeLanguages", "", "out", "Ljava/io/Writer;", "writeToJsonTempFile", "Ljava/io/File;", "intellij.android.projectSystem.gradle"})
@JvmName(name="AndroidDeviceSpecUtil")
public final class AndroidDeviceSpecUtil {
    public static final long DEVICE_SPEC_TIMEOUT_SECONDS = 10L;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @Nullable
    public static final AndroidDeviceSpec createSpec(@NotNull List<? extends AndroidDevice> devices2, long timeout, @NotNull TimeUnit unit) {
        AndroidVersion androidVersion;
        AndroidVersion version2;
        Collection collection2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (devices2.isEmpty()) {
            return null;
        }
        Iterable $this$map$iv = devices2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AndroidDevice androidDevice = (AndroidDevice)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getVersion());
        }
        Set versions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean hasUnknownVersions = versions.contains(AndroidVersion.DEFAULT);
        AndroidVersion androidVersion2 = version2 = hasUnknownVersions ? null : (AndroidVersion)CollectionsKt.singleOrNull((Iterable)versions);
        if (hasUnknownVersions) {
            androidVersion = null;
        } else {
            Iterable iterable2 = versions;
            Ordering ordering = Ordering.natural();
            Intrinsics.checkNotNullExpressionValue((Object)ordering, (String)"natural()");
            Object object = CollectionsKt.minWithOrNull((Iterable)iterable2, (Comparator)((Comparator)ordering));
            Intrinsics.checkNotNull((Object)object);
            androidVersion = (AndroidVersion)object;
        }
        AndroidVersion minVersion = androidVersion;
        Density density = null;
        List abis = CollectionsKt.emptyList();
        if (devices2.size() == 1) {
            Object object;
            void $this$mapTo$iv$iv2;
            AndroidDevice device2 = devices2.get(0);
            if (device2.supportsMultipleScreenFormats()) {
                AndroidDeviceSpecUtil.getLog().info("Creating spec for resizable device");
            } else {
                density = Density.getEnum((int)device2.getDensity());
            }
            List<Abi> list2 = device2.getAbis();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"device.abis");
            Iterable $this$map$iv2 = list2;
            boolean $i$f$map2 = false;
            Iterable bl = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Abi abi = (Abi)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(it.toString());
            }
            abis = (List)destination$iv$iv2;
            Object object2 = AndroidDeviceSpecUtil.getLog();
            String string = device2.getName();
            Collection collection3 = abis;
            if (collection3.isEmpty()) {
                String string2 = string;
                collection2 = object2;
                boolean bl3 = false;
                String string3 = "<none specified>";
                object2 = collection2;
                string = string2;
                object = string3;
            } else {
                object = collection3;
            }
            object2.info("Creating spec for " + string + " with ABIs: " + object);
        } else {
            AndroidDeviceSpecUtil.getLog().info("Creating spec for multiple devices");
        }
        return new AndroidDeviceSpecImpl(version2, minVersion, density, abis, (Function0<? extends List<String>>)((Function0)new Function0<List<? extends String>>(devices2, timeout, unit){
            final /* synthetic */ List<AndroidDevice> $devices;
            final /* synthetic */ long $timeout;
            final /* synthetic */ TimeUnit $unit;
            {
                this.$devices = $devices;
                this.$timeout = $timeout;
                this.$unit = $unit;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return AndroidDeviceSpecUtil.access$combineDeviceLanguages(this.$devices, this.$timeout, this.$unit);
            }
        }));
    }

    public static /* synthetic */ AndroidDeviceSpec createSpec$default(List list2, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 2) != 0) {
            l = 10L;
        }
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return AndroidDeviceSpecUtil.createSpec(list2, l, timeUnit);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> combineDeviceLanguages(List<? extends AndroidDevice> devices2, long timeout, TimeUnit unit) {
        List list2;
        try {
            boolean bl;
            List languageSets;
            block6: {
                void $this$mapTo$iv$iv;
                long nanos = Math.max(1L, unit.toNanos(timeout));
                Duration duration2 = Duration.ofNanos(nanos);
                Iterable $this$map$iv = devices2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AndroidDevice androidDevice = (AndroidDevice)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    Object object = it.getLaunchedDevice().get(timeout, unit);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.launchedDevice.get(timeout, unit)");
                    IDevice iDevice = (IDevice)object;
                    Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"duration");
                    collection2.add(DeviceUtils.getLanguages((IDevice)iDevice, (Duration)duration2));
                }
                languageSets = (List)destination$iv$iv;
                Iterable $this$any$iv = languageSets;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Set it = (Set)element$iv;
                        boolean bl3 = false;
                        if (!it.isEmpty()) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            list2 = bl ? CollectionsKt.emptyList() : CollectionsKt.sorted((Iterable)CollectionsKt.flatten((Iterable)languageSets));
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving list of installed languages on device", e);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeJson(AndroidDeviceSpec $this$writeJson, boolean writeLanguages, Writer out) {
        Closeable closeable = (Closeable)new JsonWriter(out);
        Throwable throwable = null;
        try {
            String it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            AndroidVersion it2;
            JsonWriter writer2 = (JsonWriter)closeable;
            boolean bl = false;
            writer2.beginObject();
            AndroidVersion androidVersion = $this$writeJson.getCommonVersion();
            if (androidVersion != null) {
                String string;
                it2 = androidVersion;
                boolean bl2 = false;
                writer2.name("sdk_version").value((long)it2.getApiLevel());
                String string2 = string = it2.getCodename();
                if (string2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"codename");
                    String codename = string;
                    boolean bl3 = false;
                    writer2.name("codename").value(codename);
                }
            }
            Density density = $this$writeJson.getDensity();
            if (density != null) {
                it2 = density;
                boolean bl4 = false;
                if (it2.getDpiValue() > 0) {
                    writer2.name("screen_density").value((long)it2.getDpiValue());
                }
            }
            if (!$this$writeJson.getAbis().isEmpty()) {
                writer2.name("supported_abis");
                writer2.beginArray();
                $this$forEach$iv = $this$writeJson.getAbis();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl5 = false;
                    writer2.value(it);
                }
                writer2.endArray();
            }
            if (writeLanguages && !$this$writeJson.getLanguages().isEmpty()) {
                writer2.name("supported_locales");
                writer2.beginArray();
                $this$forEach$iv = $this$writeJson.getLanguages();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl6 = false;
                    writer2.value(it);
                }
                writer2.endArray();
            }
            JsonWriter jsonWriter = writer2.endObject();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final AndroidDeviceSpec createSpec(@NotNull IDevice $this$createSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$createSpec, (String)"<this>");
        AndroidVersion androidVersion = $this$createSpec.getVersion();
        AndroidVersion androidVersion2 = $this$createSpec.getVersion();
        Density density = Density.getEnum((int)$this$createSpec.getDensity());
        List list2 = $this$createSpec.getAbis();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"abis");
        return new AndroidDeviceSpecImpl(androidVersion, androidVersion2, density, list2, (Function0<? extends List<String>>)((Function0)new Function0<List<? extends String>>($this$createSpec){
            final /* synthetic */ IDevice $this_createSpec;
            {
                this.$this_createSpec = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                Duration duration2 = Duration.ofSeconds(10L);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(DEVICE_SPEC_TIMEOUT_SECONDS)");
                return CollectionsKt.sorted((Iterable)DeviceUtils.getLanguages((IDevice)this.$this_createSpec, (Duration)duration2));
            }
        }));
    }

    private static final Logger getLog() {
        Logger logger2 = Logger.getInstance(AndroidDeviceSpec.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(AndroidDeviceSpec::class.java)");
        return logger2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final File writeToJsonTempFile(@NotNull AndroidDeviceSpec $this$writeToJsonTempFile, boolean writeLanguages) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$writeToJsonTempFile, (String)"<this>");
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            StringWriter it = (StringWriter)closeable;
            boolean bl = false;
            AndroidDeviceSpecUtil.writeJson($this$writeToJsonTempFile, writeLanguages, it);
            it.flush();
            String string2 = it.toString();
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringWriter().use {\n   \u2026h()\n    it.toString()\n  }");
        String jsonString = string;
        AndroidDeviceSpecUtil.getLog().info("Device spec file generated: " + jsonString);
        File file2 = FileUtil.createTempFile((String)"device-spec", (String)".json", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(\"device-spec\", \".json\", true)");
        File tempFile = file2;
        FileUtil.writeToFile((File)tempFile, (String)jsonString);
        return tempFile;
    }

    @JvmOverloads
    @Nullable
    public static final AndroidDeviceSpec createSpec(@NotNull List<? extends AndroidDevice> devices2, long timeout) {
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        return AndroidDeviceSpecUtil.createSpec$default(devices2, timeout, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public static final AndroidDeviceSpec createSpec(@NotNull List<? extends AndroidDevice> devices2) {
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        return AndroidDeviceSpecUtil.createSpec$default(devices2, 0L, null, 6, null);
    }

    public static final /* synthetic */ List access$combineDeviceLanguages(List devices2, long timeout, TimeUnit unit) {
        return AndroidDeviceSpecUtil.combineDeviceLanguages(devices2, timeout, unit);
    }
}

