/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.repositories.search.JCenterRepository;
import com.android.tools.idea.gradle.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.repositories.search.SearchResult;
import com.android.tools.idea.gradle.repositories.search.SearchResultStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.wireless.android.sdk.stats.PSDEvent;
import com.intellij.util.io.HttpRequests;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/repositories/search/JCenterRepository;", "Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepository;", "()V", "isRemote", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "createRequestUrl", "request", "Lcom/android/tools/idea/gradle/repositories/search/SearchRequest;", "doSearch", "Lcom/android/tools/idea/gradle/repositories/search/SearchResult;", "parse", "response", "Ljava/io/Reader;", "intellij.android.projectSystem.gradle.repositorySearch"})
public final class JCenterRepository
extends ArtifactRepository {
    @NotNull
    public static final JCenterRepository INSTANCE = new JCenterRepository();
    @NotNull
    private static final String name = "JCenter";
    private static final boolean isRemote = true;

    private JCenterRepository() {
        super(PSDEvent.PSDRepositoryUsage.PSDRepository.PROJECT_STRUCTURE_DIALOG_REPOSITORY_JCENTER);
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    public boolean isRemote() {
        return isRemote;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request2) throws Exception {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Object object = HttpRequests.request((String)this.createRequestUrl(request2)).accept("application/json").connect((HttpRequests.RequestProcessor)doSearch.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"request(createRequestUrl\u2026nect { parse(it.reader) }");
        return (SearchResult)object;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final SearchResult parse(@NotNull Reader response2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        JsonParser parser2 = new JsonParser();
        JsonArray array = parser2.parse(response2).getAsJsonArray();
        List errors2 = new ArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)array, (String)"array");
        Iterable $this$flatMap$iv = (Iterable)array;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            JsonElement result2 = (JsonElement)element$iv$iv;
            boolean bl = false;
            JsonObject root = result2.getAsJsonObject();
            try {
                boolean bl2;
                Object element$iv$iv2;
                Object element$iv$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                JsonArray versions = root.getAsJsonArray("versions");
                JsonArray systemIds = root.getAsJsonArray("system_ids");
                Intrinsics.checkNotNullExpressionValue((Object)versions, (String)"versions");
                Iterable $this$mapNotNull$iv = (Iterable)versions;
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    GradleVersion it$iv$iv;
                    element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    bl2 = false;
                    JsonElement it = (JsonElement)element$iv$iv2;
                    boolean bl3 = false;
                    if (GradleVersion.tryParse((String)it.getAsString()) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Set availableVersions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                Intrinsics.checkNotNullExpressionValue((Object)systemIds, (String)"systemIds");
                $this$mapNotNull$iv = (Iterable)systemIds;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv2 = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FoundArtifact foundArtifact;
                    Object object;
                    element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    bl2 = false;
                    JsonElement name = (JsonElement)element$iv$iv2;
                    boolean bl5 = false;
                    String string = name.getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name\n            .asString");
                    Object object2 = new char[]{':'};
                    Object it = object2 = (Object)StringsKt.split$default((CharSequence)string, (char[])object2, (boolean)false, (int)0, (int)6, null);
                    boolean bl6 = false;
                    Object object3 = object = it.size() == 2 ? object2 : null;
                    if (object != null) {
                        it = object;
                        boolean bl7 = false;
                        foundArtifact = new FoundArtifact(INSTANCE.getName(), (String)it.get(0), (String)it.get(1), availableVersions);
                    } else {
                        foundArtifact = null;
                    }
                    if (foundArtifact == null) continue;
                    FoundArtifact it$iv$iv = foundArtifact;
                    boolean bl8 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            }
            catch (Exception ex) {
                errors2.add(ex);
                list2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List artifacts = (List)destination$iv$iv;
        return new SearchResult(artifacts, errors2, SearchResultStats.Companion.getEMPTY());
    }

    @VisibleForTesting
    @NotNull
    public final String createRequestUrl(@NotNull SearchRequest request2) {
        String artifactName;
        CharSequence charSequence;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        StringBuilder $this$createRequestUrl_u24lambda_u2d5 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createRequestUrl_u24lambda_u2d5.append("https://api.bintray.com/search/packages/maven?");
        String groupId = request2.getQuery().getGroupId();
        CharSequence charSequence2 = groupId;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            $this$createRequestUrl_u24lambda_u2d5.append("g=");
            $this$createRequestUrl_u24lambda_u2d5.append(groupId);
            $this$createRequestUrl_u24lambda_u2d5.append("&");
        }
        if (!((charSequence = (CharSequence)(artifactName = request2.getQuery().getArtifactName())) == null || charSequence.length() == 0)) {
            $this$createRequestUrl_u24lambda_u2d5.append("a=");
            $this$createRequestUrl_u24lambda_u2d5.append(artifactName);
            $this$createRequestUrl_u24lambda_u2d5.append("&");
        }
        $this$createRequestUrl_u24lambda_u2d5.append("subject=bintray&repo=jcenter");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

