/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.repositories;

import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.io.CancellableFileIo;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.android.tools.idea.gradle.repositories.OfflineIdeGoogleMavenRepository;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002B)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J8\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u001f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u0007J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007J8\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J$\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010%\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)J$\u0010*\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/gradle/repositories/RepositoryUrlManager;", "", "()V", "googleMavenRepository", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "cachedGoogleMavenRepository", "forceRepositoryChecksInTests", "", "useEmbeddedStudioRepo", "(Lcom/android/ide/common/repository/GoogleMavenRepository;Lcom/android/ide/common/repository/GoogleMavenRepository;ZZ)V", "pendingNetworkRequests", "", "", "findCompileDependencies", "", "Lcom/android/ide/common/repository/GradleCoordinate;", "groupId", "artifactId", "version", "Lcom/android/ide/common/repository/GradleVersion;", "findVersion", "filter", "Ljava/util/function/Predicate;", "includePreviews", "fileSystem", "Ljava/nio/file/FileSystem;", "getArchiveForCoordinate", "Ljava/io/File;", "gradleCoordinate", "sdkLocation", "getArtifactStringCoordinate", "Lcom/android/tools/idea/projectsystem/GoogleMavenArtifactId;", "preview", "getLibraryRevision", "refreshCacheInBackground", "", "resolveDynamicCoordinate", "coordinate", "project", "Lcom/intellij/openapi/project/Project;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "resolveDynamicCoordinateVersion", "Companion", "intellij.android.core"})
public final class RepositoryUrlManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GoogleMavenRepository googleMavenRepository;
    @NotNull
    private final GoogleMavenRepository cachedGoogleMavenRepository;
    private final boolean forceRepositoryChecksInTests;
    private final boolean useEmbeddedStudioRepo;
    @NotNull
    private final Set<String> pendingNetworkRequests;

    @NonInjectable
    @VisibleForTesting
    public RepositoryUrlManager(@NotNull GoogleMavenRepository googleMavenRepository, @NotNull GoogleMavenRepository cachedGoogleMavenRepository, boolean forceRepositoryChecksInTests, boolean useEmbeddedStudioRepo) {
        Intrinsics.checkNotNullParameter((Object)googleMavenRepository, (String)"googleMavenRepository");
        Intrinsics.checkNotNullParameter((Object)cachedGoogleMavenRepository, (String)"cachedGoogleMavenRepository");
        this.googleMavenRepository = googleMavenRepository;
        this.cachedGoogleMavenRepository = cachedGoogleMavenRepository;
        this.forceRepositoryChecksInTests = forceRepositoryChecksInTests;
        this.useEmbeddedStudioRepo = useEmbeddedStudioRepo;
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet()");
        this.pendingNetworkRequests = keySetView;
    }

    public /* synthetic */ RepositoryUrlManager(GoogleMavenRepository googleMavenRepository, GoogleMavenRepository googleMavenRepository2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        this(googleMavenRepository, googleMavenRepository2, bl, bl2);
    }

    public RepositoryUrlManager() {
        this(IdeGoogleMavenRepository.INSTANCE, OfflineIdeGoogleMavenRepository.INSTANCE, false, false, 8, null);
    }

    @Nullable
    public final String getArtifactStringCoordinate(@NotNull GoogleMavenArtifactId artifactId, boolean preview) {
        Intrinsics.checkNotNullParameter((Object)((Object)artifactId), (String)"artifactId");
        return this.getArtifactStringCoordinate(artifactId, null, preview);
    }

    @Nullable
    public final String getArtifactStringCoordinate(@NotNull GoogleMavenArtifactId artifactId, @Nullable Predicate<GradleVersion> filter2, boolean preview) {
        Intrinsics.checkNotNullParameter((Object)((Object)artifactId), (String)"artifactId");
        String string = artifactId.getMavenGroupId();
        String string2 = artifactId.getMavenArtifactId();
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault()");
        String string3 = this.getLibraryRevision(string, string2, filter2, preview, fileSystem);
        if (string3 == null) {
            return null;
        }
        String revision = string3;
        return artifactId.getCoordinate(revision).toString();
    }

    @Nullable
    public final String getLibraryRevision(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<GradleVersion> filter2, boolean includePreviews, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        GradleVersion gradleVersion2 = this.findVersion(groupId, artifactId, filter2, includePreviews, fileSystem);
        return gradleVersion2 != null ? gradleVersion2.toString() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GradleVersion findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<GradleVersion> filter2, boolean includePreviews, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        GradleVersion version2 = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            version2 = this.cachedGoogleMavenRepository.findVersion(groupId, artifactId, filter2, includePreviews);
            this.refreshCacheInBackground(groupId, artifactId);
        } else {
            version2 = this.googleMavenRepository.findVersion(groupId, artifactId, filter2, includePreviews);
        }
        if (version2 != null) {
            return version2;
        }
        if (this.useEmbeddedStudioRepo) {
            GradleCoordinate gradleCoordinate;
            block6: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                List<File> list2 = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance().findAndroi\u2026udioLocalMavenRepoPaths()");
                Iterable iterable = list2;
                boolean $i$f$filter = false;
                GradleCoordinate gradleCoordinate2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    File file2 = it;
                    boolean bl2 = file2 != null ? file2.isDirectory() : false;
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (File it : (Iterable)((List)destination$iv$iv)) {
                    boolean bl = false;
                    gradleCoordinate2 = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (Path)fileSystem.getPath(it.getPath(), new String[0]), filter2, (boolean)includePreviews);
                    if (gradleCoordinate2 == null) continue;
                    gradleCoordinate = gradleCoordinate2;
                    break block6;
                }
                gradleCoordinate = null;
            }
            GradleCoordinate gradleCoordinate3 = gradleCoordinate;
            return gradleCoordinate3 != null ? gradleCoordinate3.getVersion() : null;
        }
        return null;
    }

    @NotNull
    public final List<GradleCoordinate> findCompileDependencies(@NotNull String groupId, @NotNull String artifactId, @NotNull GradleVersion version2) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        List result2 = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            result2 = this.cachedGoogleMavenRepository.findCompileDependencies(groupId, artifactId, version2);
            this.refreshCacheInBackground(groupId, artifactId);
        } else {
            result2 = this.googleMavenRepository.findCompileDependencies(groupId, artifactId, version2);
        }
        return result2;
    }

    @Nullable
    public final File getArchiveForCoordinate(@NotNull GradleCoordinate gradleCoordinate, @NotNull File sdkLocation, @NotNull FileSystem fileSystem) {
        Path artifactDirectory;
        Intrinsics.checkNotNullParameter((Object)gradleCoordinate, (String)"gradleCoordinate");
        Intrinsics.checkNotNullParameter((Object)sdkLocation, (String)"sdkLocation");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        String groupId = gradleCoordinate.getGroupId();
        String artifactId = gradleCoordinate.getArtifactId();
        Path sdkPath = fileSystem.getPath(sdkLocation.getPath(), new String[0]);
        SdkMavenRepository sdkMavenRepository = SdkMavenRepository.find((Path)sdkPath, (String)groupId, (String)artifactId);
        if (sdkMavenRepository == null) {
            return null;
        }
        SdkMavenRepository repository2 = sdkMavenRepository;
        Path path2 = repository2.getRepositoryLocation(sdkPath, true);
        if (path2 == null) {
            return null;
        }
        Path repositoryLocation = path2;
        Path path3 = artifactDirectory = MavenRepositories.getArtifactDirectory((Path)repositoryLocation, (GradleCoordinate)gradleCoordinate);
        Intrinsics.checkNotNull((Object)path3);
        if (!CancellableFileIo.isDirectory((Path)path3, (LinkOption[])new LinkOption[0])) {
            return null;
        }
        for (GradleCoordinate.ArtifactType artifactType : ImmutableList.of((Object)GradleCoordinate.ArtifactType.JAR, (Object)GradleCoordinate.ArtifactType.AAR)) {
            Path archive = artifactDirectory.resolve(artifactId + "-" + gradleCoordinate.getRevision() + "." + artifactType);
            if (!CancellableFileIo.isRegularFile((Path)archive, (LinkOption[])new LinkOption[0])) continue;
            return archive.toFile();
        }
        return null;
    }

    @Nullable
    public final GradleCoordinate resolveDynamicCoordinate(@NotNull GradleCoordinate coordinate, @Nullable Project project, @Nullable AndroidSdkHandler sdkHandler) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        AndroidSdkHandler androidSdkHandler = sdkHandler;
        if (androidSdkHandler == null) {
            AndroidSdkHandler androidSdkHandler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
            androidSdkHandler = androidSdkHandler2;
            Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler2, (String)"getInstance().tryToChooseSdkHandler()");
        }
        String string = this.resolveDynamicCoordinateVersion(coordinate, project, androidSdkHandler);
        if (string == null) {
            return null;
        }
        String version2 = string;
        List revisions = GradleCoordinate.parseRevisionNumber((String)version2);
        Intrinsics.checkNotNullExpressionValue((Object)revisions, (String)"revisions");
        if (!((Collection)revisions).isEmpty()) {
            return new GradleCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), revisions, coordinate.getArtifactType());
        }
        return null;
    }

    @Nullable
    public final String resolveDynamicCoordinateVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project, @Nullable AndroidSdkHandler sdkHandler) {
        GradleCoordinate found;
        GradleVersion versionFound;
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        AndroidSdkHandler androidSdkHandler = sdkHandler;
        if (androidSdkHandler == null) {
            AndroidSdkHandler androidSdkHandler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
            androidSdkHandler = androidSdkHandler2;
            Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler2, (String)"getInstance().tryToChooseSdkHandler()");
        }
        AndroidSdkHandler sdkHandler2 = androidSdkHandler;
        String revision = coordinate.getRevision();
        Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"revision");
        if (!StringsKt.endsWith$default((String)revision, (String)"+", (boolean)false, (int)2, null)) {
            return revision;
        }
        String string = revision.substring(0, revision.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String versionPrefix = string;
        Predicate filter2 = new Predicate(versionPrefix){
            final /* synthetic */ String $versionPrefix;
            {
                this.$versionPrefix = $versionPrefix;
            }

            public final boolean test(@NotNull GradleVersion version2) {
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                String string = version2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version.toString()");
                return StringsKt.startsWith$default((String)string, (String)this.$versionPrefix, (boolean)false, (int)2, null);
            }
        };
        String groupId = coordinate.getGroupId();
        String artifactId = coordinate.getArtifactId();
        GoogleMavenRepository bestAvailableGoogleMavenRepo = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            bestAvailableGoogleMavenRepo = this.cachedGoogleMavenRepository;
            Intrinsics.checkNotNullExpressionValue((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullExpressionValue((Object)artifactId, (String)"artifactId");
            this.refreshCacheInBackground(groupId, artifactId);
        } else {
            bestAvailableGoogleMavenRepo = this.googleMavenRepository;
        }
        Intrinsics.checkNotNullExpressionValue((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullExpressionValue((Object)artifactId, (String)"artifactId");
        GradleVersion stable = bestAvailableGoogleMavenRepo.findVersion(groupId, artifactId, filter2, false);
        if (stable != null) {
            return stable.toString();
        }
        GradleVersion version2 = bestAvailableGoogleMavenRepo.findVersion(groupId, artifactId, filter2, true);
        if (version2 != null) {
            return version2.toString();
        }
        Path sdkLocation = sdkHandler2.getLocation();
        if (sdkLocation != null) {
            Object object = sdkHandler2.getLocation();
            if (object == null || (object = object.getFileSystem()) == null) {
                object = FileSystems.getDefault();
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sdkHandler.location?.fil\u2026 FileSystems.getDefault()");
            String libraryCoordinate = this.getLibraryRevision(groupId, artifactId, filter2, false, (FileSystem)object);
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
            Object object2 = sdkHandler2.getLocation();
            if (object2 == null || (object2 = object2.getFileSystem()) == null) {
                object2 = FileSystems.getDefault();
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sdkHandler.location?.fil\u2026 FileSystems.getDefault()");
            libraryCoordinate = this.getLibraryRevision(groupId, artifactId, filter2, true, (FileSystem)object2);
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
        }
        if ((versionFound = GradleLocalCache.getInstance().findLatestArtifactVersion(coordinate, project, revision)) != null) {
            return versionFound.toString();
        }
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
        RemotePackage sdkPackage = SdkMavenRepository.findLatestRemoteVersion((GradleCoordinate)coordinate, (AndroidSdkHandler)sdkHandler2, (Predicate)filter2, (ProgressIndicator)((ProgressIndicator)progress2));
        if (sdkPackage != null && (found = SdkMavenRepository.getCoordinateFromSdkPath((String)sdkPackage.getPath())) != null) {
            return found.getRevision();
        }
        if (project == null) {
            return null;
        }
        LintClient client2 = (LintClient)LintIdeSupport.createClient$default((LintIdeSupport)LintIdeSupport.Companion.get(), (Project)project, null, (int)2, null);
        Object object = GradleDetector.Companion.getLatestVersionFromRemoteRepo(client2, coordinate, filter2, coordinate.isPreview());
        if (object == null || (object = object.toString()) == null) {
            return null;
        }
        Object latest = object;
        if (StringsKt.startsWith$default((String)latest, (String)versionPrefix, (boolean)false, (int)2, null)) {
            return latest;
        }
        return null;
    }

    private final void refreshCacheInBackground(String groupId, String artifactId) {
        String searchKey = groupId + ":" + artifactId;
        if (this.pendingNetworkRequests.add(searchKey)) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, groupId, artifactId, searchKey){
                final /* synthetic */ RepositoryUrlManager this$0;
                final /* synthetic */ String $groupId;
                final /* synthetic */ String $artifactId;
                final /* synthetic */ String $searchKey;
                {
                    this.this$0 = $receiver;
                    this.$groupId = $groupId;
                    this.$artifactId = $artifactId;
                    this.$searchKey = $searchKey;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        RepositoryUrlManager.access$getGoogleMavenRepository$p(this.this$0).findVersion(this.$groupId, this.$artifactId, (Function1)refreshCacheInBackground.1.INSTANCE, true);
                    }
                    finally {
                        RepositoryUrlManager.access$getPendingNetworkRequests$p(this.this$0).remove(this.$searchKey);
                    }
                }
            });
        }
    }

    @JvmStatic
    @NotNull
    public static final RepositoryUrlManager get() {
        return Companion.get();
    }

    public static final /* synthetic */ GoogleMavenRepository access$getGoogleMavenRepository$p(RepositoryUrlManager $this) {
        return $this.googleMavenRepository;
    }

    public static final /* synthetic */ Set access$getPendingNetworkRequests$p(RepositoryUrlManager $this) {
        return $this.pendingNetworkRequests;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/repositories/RepositoryUrlManager$Companion;", "", "()V", "get", "Lcom/android/tools/idea/gradle/repositories/RepositoryUrlManager;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RepositoryUrlManager get() {
            Object object = ApplicationManager.getApplication().getService(RepositoryUrlManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026ryUrlManager::class.java)");
            return (RepositoryUrlManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

