/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.refactoring;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.ProcessingContext;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nullable;

public class GradleAwareSourceRootRenameValidator
implements RenameInputValidatorEx {
    private boolean myShowWarning;

    @Nullable
    public String getErrorMessage(String newName2, Project project) {
        return this.myShowWarning ? AndroidBundle.message("android.refactoring.gradle.warning.rename.source.root", new Object[0]) : null;
    }

    public ElementPattern<? extends PsiElement> getPattern() {
        return PlatformPatterns.psiElement(PsiDirectory.class);
    }

    public boolean isInputValid(String newName2, PsiElement element2, ProcessingContext context2) {
        Module[] modules2;
        this.myShowWarning = false;
        if (!(element2 instanceof PsiDirectory)) {
            assert (false);
            return true;
        }
        VirtualFile virtualFile = ((PsiDirectory)element2).getVirtualFile();
        for (Module module2 : modules2 = ModuleManager.getInstance((Project)element2.getProject()).getModules()) {
            VirtualFile[] sourceRoots;
            if (GradleUtil.getGradleBuildFile(module2) == null) continue;
            for (VirtualFile sourceRoot : sourceRoots = ModuleRootManager.getInstance((Module)module2).getSourceRoots(false)) {
                if (!sourceRoot.equals(virtualFile)) continue;
                this.myShowWarning = true;
                return true;
            }
        }
        return true;
    }
}

