/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedReminder;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/RecommendedUpgradeReminder;", "Lcom/android/tools/idea/gradle/project/sync/setup/post/TimeBasedReminder;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "doNotAskForVersion", "getDoNotAskForVersion", "()Ljava/lang/String;", "setDoNotAskForVersion", "(Ljava/lang/String;)V", "shouldAsk", "", "currentTime", "", "intellij.android.projectSystem.gradle.upgrade"})
public final class RecommendedUpgradeReminder
extends TimeBasedReminder {
    public RecommendedUpgradeReminder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, "recommended.upgrade", TimeUnit.DAYS.toMillis(1L));
    }

    @Nullable
    public final String getDoNotAskForVersion() {
        return PropertiesComponent.getInstance((Project)this.getProject()).getValue(this.getSettingsPropertyRoot() + ".do.not.ask.for.version");
    }

    public final void setDoNotAskForVersion(@Nullable String value2) {
        PropertiesComponent.getInstance((Project)this.getProject()).setValue(this.getSettingsPropertyRoot() + ".do.not.ask.for.version", value2);
    }

    @Override
    @Slow
    public boolean shouldAsk(long currentTime) {
        AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(this.getProject());
        if (androidPluginInfo == null) {
            return false;
        }
        AndroidPluginInfo pluginInfo = androidPluginInfo;
        AgpVersion agpVersion = pluginInfo.getPluginVersion();
        if (agpVersion == null) {
            return false;
        }
        AgpVersion gradleVersion2 = agpVersion;
        return !Intrinsics.areEqual((Object)this.getDoNotAskForVersion(), (Object)gradleVersion2.toString()) && super.shouldAsk(currentTime);
    }
}

