/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.tools.idea.gradle.project.upgrade.GradleBuildModelRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.GradleBuildModelUsageInfo;
import com.android.tools.idea.gradle.project.upgrade.WrappedPsiElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/NonTransitiveRClassUsageInfo;", "Lcom/android/tools/idea/gradle/project/upgrade/GradleBuildModelUsageInfo;", "wrappedElement", "Lcom/android/tools/idea/gradle/project/upgrade/WrappedPsiElement;", "(Lcom/android/tools/idea/gradle/project/upgrade/WrappedPsiElement;)V", "getTooltipText", "", "kotlin.jvm.PlatformType", "performBuildModelRefactoring", "", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/GradleBuildModelRefactoringProcessor;", "intellij.android.projectSystem.gradle.upgrade"})
public final class NonTransitiveRClassUsageInfo
extends GradleBuildModelUsageInfo {
    @NotNull
    private final WrappedPsiElement wrappedElement;

    public NonTransitiveRClassUsageInfo(@NotNull WrappedPsiElement wrappedElement) {
        Intrinsics.checkNotNullParameter((Object)wrappedElement, (String)"wrappedElement");
        super(wrappedElement);
        this.wrappedElement = wrappedElement;
    }

    @Override
    public void performBuildModelRefactoring(@NotNull GradleBuildModelRefactoringProcessor processor) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        PsiElement realElement = this.wrappedElement.getRealElement();
        if (realElement instanceof PropertiesFile) {
            PsiFile psiFile = realElement instanceof PsiFile ? (PsiFile)realElement : null;
            if (psiFile == null) {
                return;
            }
            pair = TuplesKt.to((Object)realElement, (Object)psiFile);
        } else if (realElement instanceof PsiDirectory) {
            PsiFile psiFile = ((PsiDirectory)realElement).findFile("gradle.properties");
            if (psiFile == null) {
                psiFile = ((PsiDirectory)realElement).createFile("gradle.properties");
            }
            PsiFile it = psiFile;
            boolean bl = false;
            PropertiesFile propertiesFile = it instanceof PropertiesFile ? (PropertiesFile)it : null;
            if (propertiesFile == null) {
                return;
            }
            Object object = it instanceof PsiFile ? it : null;
            if (object == null) {
                return;
            }
            pair = TuplesKt.to((Object)propertiesFile, (Object)object);
        } else {
            return;
        }
        Pair pair2 = pair;
        PropertiesFile propertiesFile = (PropertiesFile)pair2.component1();
        PsiFile psiFile = (PsiFile)pair2.component2();
        this.getOtherAffectedFiles().add(psiFile);
        propertiesFile.addProperty("android.nonTransitiveRClass", "false");
    }

    @Override
    public String getTooltipText() {
        return AndroidBundle.message("project.upgrade.nonTransitiveRClassUsageInfo.tooltipText", new Object[0]);
    }
}

