/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedReminder;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentNecessity;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessorKt;
import com.android.tools.idea.gradle.project.upgrade.AndroidGradlePluginCompatibility;
import com.android.tools.idea.gradle.project.upgrade.AndroidGradlePluginCompatibilityKt;
import com.android.tools.idea.gradle.project.upgrade.DeprecatedAgpUpgradeWarning;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgradeState;
import com.android.tools.idea.gradle.project.upgrade.ProjectUpgradeNotification;
import com.android.tools.idea.gradle.project.upgrade.Recommendation;
import com.android.tools.idea.gradle.project.upgrade.RecommendedUpgradeReminder;
import com.android.tools.idea.gradle.project.upgrade.RefactoringProcessorInstantiator;
import com.android.tools.idea.gradle.project.upgrade.UpgradeSuggestion;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.rd.util.CollectionExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0006H\u0007\u001a&\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0007\u001a\u001e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000b\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0007\u001a0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0007\u001a(\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0007\u001a\u0016\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\rH\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "computeGradlePluginUpgradeState", "Lcom/android/tools/idea/gradle/project/upgrade/GradlePluginUpgradeState;", "current", "Lcom/android/ide/common/repository/AgpVersion;", "latestKnown", "published", "", "isCleanEnoughProject", "", "project", "Lcom/intellij/openapi/project/Project;", "performForcedPluginUpgrade", "", "currentPluginVersion", "newPluginVersion", "performRecommendedPluginUpgrade", "currentVersion", "recommendPluginUpgrade", "strongly", "releaseNotesUrl", "", "v", "shouldRecommendPluginUpgrade", "Lcom/android/tools/idea/gradle/project/upgrade/Recommendation;", "shouldRecommendUpgrade", "versionsAreIncompatible", "findPluginInfo", "Lcom/android/tools/idea/gradle/plugin/AndroidPluginInfo;", "intellij.android.projectSystem.gradle.upgrade"})
@JvmName(name="GradlePluginUpgrade")
public final class GradlePluginUpgrade {
    @NotNull
    private static final Logger LOG;

    @Slow
    @NotNull
    public static final Recommendation shouldRecommendPluginUpgrade(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(project);
        if (androidPluginInfo == null || (androidPluginInfo = androidPluginInfo.getPluginVersion()) == null) {
            return new Recommendation(false, false);
        }
        AndroidPluginInfo current = androidPluginInfo;
        String string = LatestKnownPluginVersionProvider.INSTANCE.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"INSTANCE.get()");
        AgpVersion latestKnown = AgpVersion.Companion.parse(string);
        Set published = IdeGoogleMavenRepository.INSTANCE.getAgpVersions();
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade(project, (AgpVersion)current, latestKnown, published);
    }

    @JvmOverloads
    @NotNull
    public static final Recommendation shouldRecommendPluginUpgrade(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion latestKnown, @NotNull Set<AgpVersion> published) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        Intrinsics.checkNotNullParameter(published, (String)"published");
        if (SystemProperties.getBooleanProperty((String)"studio.skip.agp.upgrade", (boolean)false)) {
            return new Recommendation(false, false);
        }
        if (!TimeBasedReminder.shouldAsk$default(new RecommendedUpgradeReminder(project), 0L, 1, null)) {
            return new Recommendation(false, false);
        }
        return GradlePluginUpgrade.shouldRecommendUpgrade(current, latestKnown, published);
    }

    public static /* synthetic */ Recommendation shouldRecommendPluginUpgrade$default(Project project, AgpVersion agpVersion, AgpVersion agpVersion2, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade(project, agpVersion, agpVersion2, set);
    }

    public static final void recommendPluginUpgrade(@NotNull Project project, @NotNull AgpVersion current, boolean strongly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        ProjectUpgradeNotification[] existing2 = (ProjectUpgradeNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectUpgradeNotification.class, project);
        Intrinsics.checkNotNullExpressionValue((Object)existing2, (String)"existing");
        if (existing2.length == 0) {
            ProjectUpgradeNotification projectUpgradeNotification;
            Object[] objectArray;
            boolean bl = strongly;
            if (!bl) {
                String string = AndroidBundle.message("project.upgrade.notification.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"project.upgrade.notification.title\")");
                objectArray = new Object[]{current};
                String string2 = AndroidBundle.message("project.upgrade.notification.body", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"project.upgrade\u2026ification.body\", current)");
                projectUpgradeNotification = new UpgradeSuggestion(string, string2);
            } else if (bl) {
                String string = AndroidBundle.message("project.upgrade.deprecated.notification.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"project.upgrade\u2026ated.notification.title\")");
                objectArray = new Object[]{current, "4.0.0"};
                String string3 = AndroidBundle.message("project.upgrade.deprecated.notification.body", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"project.upgrade\u2026GIN_NEXT_MINIMUM_VERSION)");
                projectUpgradeNotification = new DeprecatedAgpUpgradeWarning(string, string3);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ProjectUpgradeNotification notification = projectUpgradeNotification;
            notification.notify(project);
        }
    }

    @Slow
    @JvmOverloads
    public static final void performRecommendedPluginUpgrade(@NotNull Project project, @Nullable AgpVersion currentVersion, @NotNull AgpVersion latestKnown) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        if (currentVersion == null) {
            return;
        }
        LOG.info("Gradle model version: " + currentVersion + ", latest known version for IDE: " + latestKnown);
        Set published = IdeGoogleMavenRepository.INSTANCE.getAgpVersions();
        GradlePluginUpgradeState state2 = GradlePluginUpgrade.computeGradlePluginUpgradeState(currentVersion, latestKnown, published);
        LOG.info("Gradle upgrade state: " + state2);
        GradlePluginUpgradeState.Importance[] importanceArray = new GradlePluginUpgradeState.Importance[]{GradlePluginUpgradeState.Importance.RECOMMEND, GradlePluginUpgradeState.Importance.STRONGLY_RECOMMEND};
        if (!SetsKt.setOf((Object[])importanceArray).contains((Object)state2.getImportance())) {
            return;
        }
        AgpUpgradeRefactoringProcessorKt.showAndInvokeAgpUpgradeRefactoringProcessor(project, currentVersion, state2.getTarget());
    }

    public static /* synthetic */ void performRecommendedPluginUpgrade$default(Project project, AgpVersion agpVersion, AgpVersion agpVersion2, int n, Object object) {
        if ((n & 2) != 0) {
            AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(project);
            Object object2 = agpVersion = androidPluginInfo != null ? androidPluginInfo.getPluginVersion() : null;
        }
        if ((n & 4) != 0) {
            String string = LatestKnownPluginVersionProvider.INSTANCE.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"INSTANCE.get()");
            agpVersion2 = AgpVersion.Companion.parse(string);
        }
        GradlePluginUpgrade.performRecommendedPluginUpgrade(project, agpVersion, agpVersion2);
    }

    public static final boolean isCleanEnoughProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getInstance(project).modules");
        Object[] $this$forEach$iv = moduleArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleFacet gradleFacet;
            Module module2 = (Module)element$iv;
            boolean bl = false;
            if (GradleFacet.getInstance(module2) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleFacet), (String)"GradleFacet.getInstance(module) ?: return@forEach");
            GradleModuleModel gradleModuleModel = gradleFacet.getGradleModuleModel();
            if (gradleModuleModel == null || (gradleModuleModel = gradleModuleModel.getBuildFile()) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)gradleModuleModel, (String)"gradleFacet.gradleModule\u2026ildFile ?: return@forEach");
            GradleModuleModel buildFile = gradleModuleModel;
            if (Intrinsics.areEqual((Object)FileStatusManager.getInstance((Project)project).getStatus((VirtualFile)buildFile), (Object)FileStatus.NOT_CHANGED)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    @JvmOverloads
    @NotNull
    public static final Recommendation shouldRecommendUpgrade(@NotNull AgpVersion current, @NotNull AgpVersion latestKnown, @NotNull Set<AgpVersion> published) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        Intrinsics.checkNotNullParameter(published, (String)"published");
        GradlePluginUpgradeState.Importance importance = GradlePluginUpgrade.computeGradlePluginUpgradeState(current, latestKnown, published).getImportance();
        boolean bl = false;
        GradlePluginUpgradeState.Importance[] importanceArray = new GradlePluginUpgradeState.Importance[]{GradlePluginUpgradeState.Importance.RECOMMEND, GradlePluginUpgradeState.Importance.STRONGLY_RECOMMEND};
        return new Recommendation(SetsKt.setOf((Object[])importanceArray).contains((Object)importance), importance == GradlePluginUpgradeState.Importance.STRONGLY_RECOMMEND);
    }

    public static /* synthetic */ Recommendation shouldRecommendUpgrade$default(AgpVersion agpVersion, AgpVersion agpVersion2, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        return GradlePluginUpgrade.shouldRecommendUpgrade(agpVersion, agpVersion2, set);
    }

    public static final boolean versionsAreIncompatible(@NotNull AgpVersion current, @NotNull AgpVersion latestKnown) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        AndroidGradlePluginCompatibility[] androidGradlePluginCompatibilityArray = new AndroidGradlePluginCompatibility[]{AndroidGradlePluginCompatibility.COMPATIBLE, AndroidGradlePluginCompatibility.DEPRECATED};
        return !SetsKt.setOf((Object[])androidGradlePluginCompatibilityArray).contains((Object)AndroidGradlePluginCompatibilityKt.computeAndroidGradlePluginCompatibility(current, latestKnown));
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    public static final void performForcedPluginUpgrade(@NotNull Project project, @NotNull AgpVersion currentPluginVersion, @NotNull AgpVersion newPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentPluginVersion, (String)"currentPluginVersion");
        Intrinsics.checkNotNullParameter((Object)newPluginVersion, (String)"newPluginVersion");
        RefactoringProcessorInstantiator refactoringProcessorInstantiator = (RefactoringProcessorInstantiator)project.getService(RefactoringProcessorInstantiator.class);
        AgpUpgradeRefactoringProcessor processor = refactoringProcessorInstantiator.createProcessor(project, currentPluginVersion, newPluginVersion);
        Iterable $this$forEach$iv = processor.getComponentRefactoringProcessors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void it;
            AgpUpgradeComponentRefactoringProcessor component2 = (AgpUpgradeComponentRefactoringProcessor)((Object)element$iv);
            boolean bl = false;
            AgpUpgradeComponentNecessity agpUpgradeComponentNecessity = component2.necessity();
            AgpUpgradeComponentRefactoringProcessor agpUpgradeComponentRefactoringProcessor = component2;
            boolean bl2 = false;
            agpUpgradeComponentRefactoringProcessor.setEnabled(it == AgpUpgradeComponentNecessity.MANDATORY_CODEPENDENT || it == AgpUpgradeComponentNecessity.MANDATORY_INDEPENDENT);
        }
        boolean runProcessor2 = refactoringProcessorInstantiator.showAndGetAgpUpgradeDialog(processor);
        if (runProcessor2) {
            DumbService.getInstance((Project)project).smartInvokeLater(new Runnable(processor){
                final /* synthetic */ AgpUpgradeRefactoringProcessor $processor;
                {
                    this.$processor = $processor;
                }

                public final void run() {
                    this.$processor.run();
                }
            });
            return;
        }
    }

    public static /* synthetic */ void performForcedPluginUpgrade$default(Project project, AgpVersion agpVersion, AgpVersion agpVersion2, int n, Object object) {
        if ((n & 4) != 0) {
            String string = LatestKnownPluginVersionProvider.INSTANCE.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"INSTANCE.get()");
            agpVersion2 = GradlePluginUpgrade.computeGradlePluginUpgradeState(agpVersion, AgpVersion.Companion.parse(string), IdeGoogleMavenRepository.INSTANCE.getAgpVersions()).getTarget();
        }
        GradlePluginUpgrade.performForcedPluginUpgrade(project, agpVersion, agpVersion2);
    }

    @NotNull
    public static final GradlePluginUpgradeState computeGradlePluginUpgradeState(@NotNull AgpVersion current, @NotNull AgpVersion latestKnown, @NotNull Set<AgpVersion> published) {
        GradlePluginUpgradeState.Importance importance;
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        Intrinsics.checkNotNullParameter(published, (String)"published");
        AndroidGradlePluginCompatibility compatibility = AndroidGradlePluginCompatibilityKt.computeAndroidGradlePluginCompatibility(current, latestKnown);
        switch (WhenMappings.$EnumSwitchMapping$0[compatibility.ordinal()]) {
            case 1: {
                Object object;
                Iterator $this$groupByTo$iv$iv;
                List $this$groupBy$iv;
                AgpVersion it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                AgpVersion minimum = AgpVersion.Companion.parse("3.2.0");
                Iterable iterable = published;
                boolean $i$f$filter = false;
                void var11_15 = $this$filter$iv;
                Object destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AgpVersion)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.isPreview())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AgpVersion)element$iv$iv;
                    boolean bl = false;
                    if (!(it.compareTo(minimum) >= 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AgpVersion)element$iv$iv;
                    boolean bl = false;
                    if (!(it.compareTo(latestKnown) <= 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$groupBy22 = false;
                $this$filterTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object object2;
                    Object element$iv$iv;
                    element$iv$iv = iterator2.next();
                    it = (AgpVersion)element$iv$iv;
                    boolean bl = false;
                    AgpVersion key$iv$iv = new AgpVersion(it.getMajor(), it.getMinor(), 0, 4, null);
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Iterable $i$f$groupBy22 = destination$iv$iv.entrySet();
                $this$groupByTo$iv$iv = $i$f$groupBy22.iterator();
                if (!$this$groupByTo$iv$iv.hasNext()) {
                    object = null;
                } else {
                    destination$iv$iv = $this$groupByTo$iv$iv.next();
                    if (!$this$groupByTo$iv$iv.hasNext()) {
                        object = destination$iv$iv;
                    } else {
                        Object it2 = (Map.Entry)destination$iv$iv;
                        boolean bl3 = false;
                        it2 = (Comparable)((AgpVersion)it2.getKey());
                        do {
                            Object bl3 = $this$groupByTo$iv$iv.next();
                            Object it3 = (Map.Entry)bl3;
                            boolean $i$a$-minByOrNull-GradlePluginUpgrade$computeGradlePluginUpgradeState$earliestStable$6 = false;
                            if (it2.compareTo(it3 = (Comparable)((AgpVersion)it3.getKey())) <= 0) continue;
                            destination$iv$iv = bl3;
                            it2 = it3;
                        } while ($this$groupByTo$iv$iv.hasNext());
                        object = destination$iv$iv;
                    }
                }
                Map.Entry entry = (Map.Entry)object;
                AgpVersion earliestStable = entry != null && ($this$groupBy$iv = (List)entry.getValue()) != null ? (AgpVersion)CollectionsKt.maxOrNull((Iterable)$this$groupBy$iv) : null;
                AgpVersion agpVersion = earliestStable;
                if (agpVersion == null) {
                    agpVersion = latestKnown;
                }
                return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.FORCE, agpVersion);
            }
            case 2: {
                AgpVersion it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable earliestStable = published;
                boolean $i$f$filter = false;
                void $this$groupBy$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AgpVersion)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.isPreview())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AgpVersion)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)new AgpVersion(it.getMajor(), it.getMinor(), 0, 4, null), (Object)new AgpVersion(current.getMajor(), current.getMinor(), 0, 4, null))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AgpVersion)element$iv$iv;
                    boolean bl = false;
                    if (!(it.compareTo(latestKnown) <= 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                AgpVersion seriesAcceptableStable = (AgpVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
                AgpVersion agpVersion = seriesAcceptableStable;
                if (agpVersion == null) {
                    agpVersion = latestKnown;
                }
                return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.FORCE, agpVersion);
            }
            case 3: {
                return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.FORCE, latestKnown);
            }
            case 4: 
            case 5: {
            }
        }
        if (current.compareTo(latestKnown) >= 0) {
            return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.NO_UPGRADE, current);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[compatibility.ordinal()]) {
            case 5: {
                importance = GradlePluginUpgradeState.Importance.STRONGLY_RECOMMEND;
                break;
            }
            case 4: {
                importance = GradlePluginUpgradeState.Importance.RECOMMEND;
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable: forced upgrade state previously handled");
            }
        }
        GradlePluginUpgradeState.Importance recommendationStrength = importance;
        if (!current.isPreview() || Intrinsics.areEqual((Object)current.getPreviewType(), (Object)"rc")) {
            List list2;
            Object v8;
            List currentSeriesCandidates;
            Map acceptableStables2;
            block46: {
                List list$iv$iv;
                List answer$iv$iv$iv;
                Object value$iv$iv$iv;
                boolean $i$f$getOrPut;
                Map $this$getOrPut$iv$iv$iv;
                Object key$iv$iv;
                Object it;
                Sequence $this$groupByTo$iv$iv;
                Sequence $this$groupBy$iv;
                Sequence seriesAcceptableStable = SequencesKt.sorted((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)published), (Function1)computeGradlePluginUpgradeState.acceptableStables.1.INSTANCE), (Function1)((Function1)new Function1<AgpVersion, Boolean>(current){
                    final /* synthetic */ AgpVersion $current;
                    {
                        this.$current = $current;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull AgpVersion it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.compareTo(this.$current) > 0;
                    }
                })), (Function1)((Function1)new Function1<AgpVersion, Boolean>(latestKnown){
                    final /* synthetic */ AgpVersion $latestKnown;
                    {
                        this.$latestKnown = $latestKnown;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull AgpVersion it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.compareTo(this.$latestKnown) <= 0;
                    }
                })));
                boolean $i$f$groupBy = false;
                void $i$f$filter = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    it = (AgpVersion)element$iv$iv;
                    boolean bl = false;
                    key$iv$iv = new AgpVersion(it.getMajor(), it.getMinor(), 0, 4, null);
                    $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    $i$f$getOrPut = false;
                    value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl4 = false;
                        answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                $this$groupBy$iv = MapsKt.asSequence((Map)destination$iv$iv);
                $i$f$groupBy = false;
                $this$groupByTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap();
                $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    it = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    key$iv$iv = ((AgpVersion)it.getKey()).getMajor();
                    $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    $i$f$getOrPut = false;
                    value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl5 = false;
                        answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                acceptableStables2 = destination$iv$iv;
                if (acceptableStables2.isEmpty()) {
                    return !latestKnown.isPreview() ? new GradlePluginUpgradeState(recommendationStrength, latestKnown) : (Intrinsics.areEqual((Object)latestKnown.getPreviewType(), (Object)"rc") ? new GradlePluginUpgradeState(recommendationStrength, latestKnown) : new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.NO_UPGRADE, current));
                }
                if (!acceptableStables2.containsKey(current.getMajor())) {
                    return new GradlePluginUpgradeState(recommendationStrength, (AgpVersion)CollectionsKt.last((List)((List)((Map.Entry)CollectionsKt.last((List)((List)CollectionExKt.first((Map)acceptableStables2).getValue()))).getValue())));
                }
                Object v = acceptableStables2.get(current.getMajor());
                Intrinsics.checkNotNull(v);
                currentSeriesCandidates = (List)v;
                Iterable $this$firstOrNull$iv = acceptableStables2.keySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    int it4 = ((Number)element$iv).intValue();
                    boolean bl = false;
                    if (!(it4 > current.getMajor())) continue;
                    v8 = element$iv;
                    break block46;
                }
                v8 = null;
            }
            Integer n = v8;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                Object v = acceptableStables2.get(it);
                Intrinsics.checkNotNull(v);
                list2 = (List)v;
            } else {
                list2 = null;
            }
            List nextSeriesCandidates = list2;
            Iterator iterator3 = ((Iterable)currentSeriesCandidates).iterator();
            if (!iterator3.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry it = (Map.Entry)iterator3.next();
            boolean bl = false;
            Comparable comparable = (Comparable)((AgpVersion)it.getKey());
            while (iterator3.hasNext()) {
                Map.Entry it5 = (Map.Entry)iterator3.next();
                $i$a$-maxOf-GradlePluginUpgrade$computeGradlePluginUpgradeState$1 = false;
                Comparable comparable2 = (Comparable)((AgpVersion)it5.getKey());
                if (comparable.compareTo(comparable2) >= 0) continue;
                comparable = comparable2;
            }
            if (Intrinsics.areEqual((Object)comparable, (Object)new AgpVersion(current.getMajor(), current.getMinor(), 0, 4, null))) {
                List list3 = nextSeriesCandidates;
                if (list3 == null) {
                    list3 = currentSeriesCandidates;
                }
                return new GradlePluginUpgradeState(recommendationStrength, (AgpVersion)CollectionsKt.last((List)((List)((Map.Entry)CollectionsKt.last((List)list3)).getValue())));
            }
            return new GradlePluginUpgradeState(recommendationStrength, (AgpVersion)CollectionsKt.last((List)((List)((Map.Entry)CollectionsKt.last((List)currentSeriesCandidates)).getValue())));
        }
        if (Intrinsics.areEqual((Object)current.getPreviewType(), (Object)"alpha") || Intrinsics.areEqual((Object)current.getPreviewType(), (Object)"beta")) {
            if (latestKnown.isSnapshot()) {
                if (latestKnown.compareIgnoringQualifiers(current) == 0) {
                    return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.NO_UPGRADE, current);
                }
                return new GradlePluginUpgradeState(recommendationStrength, latestKnown);
            }
            throw new IllegalStateException("Unreachable: forced upgrade state previously handled");
        }
        throw new IllegalStateException("Unreachable: forced upgrade state previously handled");
    }

    @Slow
    @Nullable
    public static final AndroidPluginInfo findPluginInfo(@NotNull Project $this$findPluginInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$findPluginInfo, (String)"<this>");
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find($this$findPluginInfo);
        if (pluginInfo == null) {
            LOG.warn("Unable to obtain application's Android Project");
            return null;
        }
        return pluginInfo;
    }

    @NotNull
    public static final String releaseNotesUrl(@NotNull AgpVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return v.isPreview() ? "https://developer.android.com/studio/preview/features#android_gradle_plugin_" + v.getMajor() + v.getMinor() : "https://developer.android.com/studio/releases/gradle-plugin#" + v.getMajor() + "-" + v.getMinor() + "-0";
    }

    @JvmOverloads
    @NotNull
    public static final Recommendation shouldRecommendPluginUpgrade(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion latestKnown) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade$default(project, current, latestKnown, null, 8, null);
    }

    @Slow
    @JvmOverloads
    public static final void performRecommendedPluginUpgrade(@NotNull Project project, @Nullable AgpVersion currentVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradlePluginUpgrade.performRecommendedPluginUpgrade$default(project, currentVersion, null, 4, null);
    }

    @Slow
    @JvmOverloads
    public static final void performRecommendedPluginUpgrade(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradlePluginUpgrade.performRecommendedPluginUpgrade$default(project, null, null, 6, null);
    }

    @VisibleForTesting
    @JvmOverloads
    @NotNull
    public static final Recommendation shouldRecommendUpgrade(@NotNull AgpVersion current, @NotNull AgpVersion latestKnown) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        return GradlePluginUpgrade.shouldRecommendUpgrade$default(current, latestKnown, null, 4, null);
    }

    static {
        Logger logger2 = Logger.getInstance((String)"Upgrade Assistant");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(LOG_CATEGORY)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidGradlePluginCompatibility.values().length];
            nArray[AndroidGradlePluginCompatibility.BEFORE_MINIMUM.ordinal()] = 1;
            nArray[AndroidGradlePluginCompatibility.DIFFERENT_PREVIEW.ordinal()] = 2;
            nArray[AndroidGradlePluginCompatibility.AFTER_MAXIMUM.ordinal()] = 3;
            nArray[AndroidGradlePluginCompatibility.COMPATIBLE.ordinal()] = 4;
            nArray[AndroidGradlePluginCompatibility.DEPRECATED.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

