/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessorKt;
import com.android.tools.idea.gradle.project.upgrade.GradleBuildModelUsageInfo;
import com.android.tools.idea.gradle.project.upgrade.SpoilingGradleBuildModelUsageInfo;
import com.android.tools.idea.gradle.project.upgrade.UndoHook;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010 \u001a\u00020!H\u0014J\u001d\u0010\"\u001a\u00020!2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0$H\u0014\u00a2\u0006\u0002\u0010%R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001c\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/GradleBuildModelRefactoringProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "processor", "(Lcom/android/tools/idea/gradle/project/upgrade/GradleBuildModelRefactoringProcessor;)V", "foundUsages", "", "getFoundUsages", "()Z", "setFoundUsages", "(Z)V", "otherAffectedFiles", "", "Lcom/intellij/psi/PsiFile;", "getOtherAffectedFiles", "()Ljava/util/Set;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectBuildModel", "Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "getProjectBuildModel", "()Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "psiSpoilingUsageInfos", "", "Lcom/intellij/usageView/UsageInfo;", "getPsiSpoilingUsageInfos", "()Ljava/util/List;", "undoHooks", "Lcom/android/tools/idea/gradle/project/upgrade/UndoHook;", "getUndoHooks", "performPsiSpoilingRefactoring", "", "performRefactoring", "usages", "", "([Lcom/intellij/usageView/UsageInfo;)V", "intellij.android.projectSystem.gradle.upgrade"})
public abstract class GradleBuildModelRefactoringProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectBuildModel projectBuildModel;
    @NotNull
    private final Set<PsiFile> otherAffectedFiles;
    @NotNull
    private final List<UsageInfo> psiSpoilingUsageInfos;
    @NotNull
    private final List<UndoHook> undoHooks;
    private boolean foundUsages;

    public GradleBuildModelRefactoringProcessor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.otherAffectedFiles = new LinkedHashSet();
        this.psiSpoilingUsageInfos = new ArrayList();
        this.undoHooks = new ArrayList();
        this.project = project;
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(project);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"get(project)");
        this.projectBuildModel = projectBuildModel2;
    }

    public GradleBuildModelRefactoringProcessor(@NotNull GradleBuildModelRefactoringProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        super(processor.project);
        this.otherAffectedFiles = new LinkedHashSet();
        this.psiSpoilingUsageInfos = new ArrayList();
        this.undoHooks = new ArrayList();
        this.project = processor.project;
        this.projectBuildModel = processor.projectBuildModel;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProjectBuildModel getProjectBuildModel() {
        return this.projectBuildModel;
    }

    @NotNull
    public final Set<PsiFile> getOtherAffectedFiles() {
        return this.otherAffectedFiles;
    }

    @NotNull
    public final List<UsageInfo> getPsiSpoilingUsageInfos() {
        return this.psiSpoilingUsageInfos;
    }

    @NotNull
    public final List<UndoHook> getUndoHooks() {
        return this.undoHooks;
    }

    public final boolean getFoundUsages() {
        return this.foundUsages;
    }

    public final void setFoundUsages(boolean bl) {
        this.foundUsages = bl;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        int size = usages.length;
        AgpUpgradeRefactoringProcessorKt.access$getLOG$p().info("performing refactoring \"" + this.getCommandName() + "\" with " + size + " " + StringUtil.pluralize((String)"usage", (int)size));
        UsageInfo[] $this$forEach$iv = usages;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            UsageInfo element$iv;
            UsageInfo it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (!(it instanceof GradleBuildModelUsageInfo)) continue;
            ((GradleBuildModelUsageInfo)it).performRefactoringFor(this);
            this.otherAffectedFiles.addAll((Collection<PsiFile>)((GradleBuildModelUsageInfo)it).getOtherAffectedFiles());
        }
    }

    protected void performPsiSpoilingRefactoring() {
        AgpUpgradeRefactoringProcessorKt.access$getLOG$p().info("applying changes from \"" + this.getCommandName() + "\" refactoring to build model");
        this.projectBuildModel.applyChanges();
        if (!((Collection)this.otherAffectedFiles).isEmpty()) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.project);
            Iterable $this$forEach$iv = this.otherAffectedFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Document document2;
                PsiFile psiFile = (PsiFile)element$iv;
                boolean bl = false;
                if (documentManager.getDocument(psiFile) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"documentManager.getDocum\u2026siFile) ?: return@psiFile");
                if (documentManager.isDocumentBlockedByPsi(document2)) {
                    documentManager.doPostponedOperationsAndUnblockDocument(document2);
                }
                FileDocumentManager.getInstance().saveDocument(document2);
                if (documentManager.isCommitted(document2)) continue;
                documentManager.commitDocument(document2);
            }
        }
        if (!((Collection)this.psiSpoilingUsageInfos).isEmpty()) {
            this.projectBuildModel.reparse();
        }
        Iterable $this$forEach$iv = this.psiSpoilingUsageInfos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UsageInfo it = (UsageInfo)element$iv;
            boolean bl = false;
            if (!(it instanceof SpoilingGradleBuildModelUsageInfo)) continue;
            ((SpoilingGradleBuildModelUsageInfo)it).performPsiSpoilingRefactoringFor(this);
        }
        super.performPsiSpoilingRefactoring();
    }
}

