/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.CompileRuntimeConfigurationRefactoringProcessor;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JEditorPane myEditorPane;
    @NotNull
    private AgpUpgradeRefactoringProcessor myProcessor;
    @NotNull
    private CompileRuntimeConfigurationRefactoringProcessor myCompileRuntimeProcessor;

    AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog(@NotNull AgpUpgradeRefactoringProcessor processor) {
        this(processor, (CompileRuntimeConfigurationRefactoringProcessor)processor.getComponentRefactoringProcessors().stream().filter(x -> x instanceof CompileRuntimeConfigurationRefactoringProcessor).findFirst().get());
    }

    AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog(@NotNull AgpUpgradeRefactoringProcessor processor, @NotNull CompileRuntimeConfigurationRefactoringProcessor compileRuntimeProcessor) {
        super(processor.getProject());
        this.myProcessor = processor;
        this.myCompileRuntimeProcessor = compileRuntimeProcessor;
        this.$$$setupUI$$$();
        this.setTitle("Android Gradle Plugin Upgrade Assistant");
        this.init();
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myEditorPane);
        this.myEditorPane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
        for (AgpUpgradeComponentRefactoringProcessor p : this.myProcessor.getComponentRefactoringProcessors()) {
            p.setEnabled(p == this.myCompileRuntimeProcessor);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>The following command will be executed to upgrade your project with replacements for deprecated <tt>compile</tt> and <tt>runtime</tt> configurations:</p>");
        sb.append("<br/><ul>");
        for (AgpUpgradeComponentRefactoringProcessor p : this.myProcessor.getComponentRefactoringProcessorsWithAgpVersionProcessorLast()) {
            if (!p.isEnabled() || p.isAlwaysNoOpForProject()) continue;
            sb.append("<li>").append(p.getCommandName()).append(".");
            String url = p.getReadMoreUrl();
            if (url != null) {
                sb.append(" <a href='").append(url).append("'>Read more</a>.");
            }
            sb.append("</li>");
        }
        sb.append("</ul>");
        this.myEditorPane.setText(sb.toString());
        this.myPanel.setMinimumSize((Dimension)new JBDimension(500, 99));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected Action @NotNull [] createActions() {
        PreviewRefactoringAction previewAction = new PreviewRefactoringAction();
        return (Action[])ArrayUtil.mergeArrays((Object[])super.createActions(), (Object[])new Action[]{previewAction});
    }

    public void doCancelAction() {
        if (this.myProcessor.getUsageView() != null) {
            this.myProcessor.getUsageView().close();
        }
        super.doCancelAction();
    }

    protected void doOKAction() {
        this.myProcessor.setPreviewUsages(false);
        if (this.myProcessor.getUsageView() != null) {
            this.myProcessor.getUsageView().close();
        }
        this.doOKActionWithPreviewState();
    }

    private void doOKActionWithPreviewState() {
        super.doOKAction();
    }

    @NotNull
    protected Action getOKAction() {
        Action okAction = super.getOKAction();
        okAction.putValue("Name", "Upgrade");
        return okAction;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEditorPane = jEditorPane = new JEditorPane();
        jPanel.add((Component)jEditorPane, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class PreviewRefactoringAction
    extends DialogWrapper.DialogWrapperAction {
        protected PreviewRefactoringAction() {
            super((DialogWrapper)AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog.this, "Show Usages");
        }

        protected void doAction(ActionEvent e) {
            AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog.this.myProcessor.setPreviewUsages(true);
            AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog.this.doOKActionWithPreviewState();
        }
    }
}

