/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EncodingValidationStrategy
extends AndroidProjectValidationStrategy {
    @NotNull
    private final EncodingProjectManager myEncodings;
    @NotNull
    private final Charset myProjectEncoding;
    @NotNull
    private final AgpVersion myOneDotTwoPluginVersion;
    @Nullable
    private String myMismatchingEncoding;

    EncodingValidationStrategy(@NotNull Project project) {
        this(project, EncodingProjectManager.getInstance((Project)project));
    }

    @VisibleForTesting
    EncodingValidationStrategy(@NotNull Project project, @NotNull EncodingProjectManager encodings) {
        super(project);
        this.myEncodings = encodings;
        this.myProjectEncoding = this.myEncodings.getDefaultCharset();
        this.myOneDotTwoPluginVersion = new AgpVersion(1, 2, 0);
    }

    @Override
    void validate(@NotNull Module module2, @NotNull GradleAndroidModel androidModel) {
        AgpVersion modelVersion = androidModel.getAgpVersion();
        if (modelVersion != null) {
            boolean isOneDotTwoOrNewer = modelVersion.compareIgnoringQualifiers(this.myOneDotTwoPluginVersion) >= 0;
            Charset modelEncoding = null;
            if (isOneDotTwoOrNewer) {
                try {
                    IdeAndroidProject androidProject = androidModel.getAndroidProject();
                    modelEncoding = Charset.forName(androidProject.getJavaCompileOptions().getEncoding());
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    // empty catch block
                }
            }
            if (this.myMismatchingEncoding == null && modelEncoding != null && this.myProjectEncoding.compareTo(modelEncoding) != 0) {
                this.myMismatchingEncoding = modelEncoding.displayName();
            }
        }
    }

    @Override
    void fixAndReportFoundIssues() {
        if (this.myMismatchingEncoding != null) {
            Project project = this.getProject();
            this.myEncodings.setDefaultCharsetName(this.myMismatchingEncoding);
            String line2 = String.format("The project encoding (%1$s) has been reset to the encoding specified in the Gradle build files (%2$s).", this.myEncodings.getDefaultCharset().displayName(), this.myMismatchingEncoding);
            String[] text2 = new String[]{line2, "Mismatching encodings can lead to serious bugs."};
            SyncMessage message2 = new SyncMessage("Gradle Sync Issues", MessageType.INFO, text2);
            GradleSyncMessages.getInstance(project).report(message2);
        }
    }

    @VisibleForTesting
    @Nullable
    String getMismatchingEncoding() {
        return this.myMismatchingEncoding;
    }

    @VisibleForTesting
    void setMismatchingEncoding(@Nullable String mismatchingEncoding) {
        this.myMismatchingEncoding = mismatchingEncoding;
    }
}

