/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.model.IdeDependencies;
import com.android.tools.idea.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListenerWithRoot;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.UsedFeatureRawText;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleAndroidModule;
import com.google.wireless.android.sdk.stats.GradleBuildDetails;
import com.google.wireless.android.sdk.stats.GradleLibrary;
import com.google.wireless.android.sdk.stats.GradleModule;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;

public class ProjectStructureUsageTracker
implements GradleSyncListenerWithRoot {
    private static final Logger LOG = Logger.getInstance(ProjectStructureUsageTracker.class);
    @NotNull
    private final Project myProject;

    @Override
    public void syncSucceeded(@NotNull Project project, @NotNull @SystemIndependent String rootProjectPath) {
        this.trackProjectStructure(rootProjectPath);
    }

    public ProjectStructureUsageTracker(@NotNull Project project) {
        this.myProject = project;
    }

    private void trackProjectStructure(@NotNull String linkedGradleBuildPath) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doTrackProjectStructure(linkedGradleBuildPath);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.doTrackProjectStructure(linkedGradleBuildPath);
            }
            catch (Throwable e) {
                LOG.warn("Failed to track project structure", e);
            }
        });
    }

    private void doTrackProjectStructure(@NotNull String linkedGradleBuildPath) {
        ExternalProject externalProject = ExternalProjectDataCache.getInstance((Project)this.myProject).getRootExternalProject(linkedGradleBuildPath);
        if (externalProject != null) {
            this.trackProjectStructure(externalProject);
        }
    }

    private void trackProjectStructure(@NotNull ExternalProject externalProject) {
        GradleAndroidModel model2;
        GradleAndroidModel appModel = null;
        GradleAndroidModel libModel = null;
        int appCount = 0;
        int libCount = 0;
        ArrayList<GradleLibrary> gradleLibraries = new ArrayList<GradleLibrary>();
        for (AndroidFacet facet2 : ProjectSystemUtil.getAndroidFacets(this.myProject)) {
            GradleAndroidModel androidModel = GradleAndroidModel.get(facet2);
            if (androidModel == null) continue;
            switch (androidModel.getAndroidProject().getProjectType()) {
                case PROJECT_TYPE_LIBRARY: {
                    libModel = androidModel;
                    ++libCount;
                    break;
                }
                case PROJECT_TYPE_APP: {
                    appModel = androidModel;
                    ++appCount;
                    GradleLibrary gradleLibrary = ProjectStructureUsageTracker.trackExternalDependenciesInAndroidApp(androidModel);
                    gradleLibraries.add(gradleLibrary);
                    break;
                }
            }
        }
        GradleAndroidModel gradleAndroidModel = model2 = appModel != null ? appModel : libModel;
        if (model2 != null) {
            ArrayList<GradleAndroidModule> gradleAndroidModules = new ArrayList<GradleAndroidModule>();
            ArrayList<GradleNativeAndroidModule> gradleNativeAndroidModules = new ArrayList<GradleNativeAndroidModule>();
            String appId = AnonymizerUtil.anonymizeUtf8((String)model2.getApplicationId());
            IdeAndroidProject androidProject = model2.getAndroidProject();
            String gradleVersionString = GradleVersions.getInstance().getGradleVersion(this.myProject).getVersion();
            if (gradleVersionString == null) {
                gradleVersionString = "0.0.0";
            }
            GradleModule gradleModule = GradleModule.newBuilder().setTotalModuleCount((long)ProjectStructureUsageTracker.countGradleProjects(externalProject)).setAppModuleCount((long)appCount).setLibModuleCount((long)libCount).build();
            for (AndroidFacet facet3 : ProjectSystemUtil.getAndroidFacets(this.myProject)) {
                GradleAndroidModel androidModel = GradleAndroidModel.get(facet3);
                if (androidModel != null) {
                    IdeAndroidProject moduleAndroidProject = androidModel.getAndroidProject();
                    GradleAndroidModule.Builder androidModule = GradleAndroidModule.newBuilder();
                    androidModule.setModuleName(AnonymizerUtil.anonymizeUtf8((String)facet3.getHolderModule().getName())).setSigningConfigCount((long)moduleAndroidProject.getSigningConfigs().size()).setIsLibrary(moduleAndroidProject.getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_LIBRARY).setBuildTypeCount((long)androidModel.getBuildTypeNames().size()).setFlavorCount((long)androidModel.getProductFlavorNames().size()).setFlavorDimension((long)moduleAndroidProject.getFlavorDimensions().size());
                    if (!androidModule.getIsLibrary() && this.isWatchHardwareRequired(facet3)) {
                        androidModule.setRequiredHardware("android.hardware.type.watch");
                    }
                    gradleAndroidModules.add(androidModule.build());
                }
                boolean shouldReportNative = false;
                NdkModuleModel ndkModel = NdkModuleModel.get(facet3.getHolderModule());
                GradleNativeAndroidModule.NativeBuildSystemType buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
                String moduleName2 = "";
                if (ndkModel != null) {
                    shouldReportNative = true;
                    if (ndkModel.getFeatures().isBuildSystemNameSupported()) {
                        for (String buildSystem : ndkModel.getBuildSystems()) {
                            buildSystemType = ProjectStructureUsageTracker.stringToBuildSystemType(buildSystem);
                        }
                    } else {
                        buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
                    }
                    moduleName2 = AnonymizerUtil.anonymizeUtf8((String)ndkModel.getModuleName());
                }
                if (!shouldReportNative) continue;
                GradleNativeAndroidModule.Builder nativeModule = GradleNativeAndroidModule.newBuilder();
                nativeModule.setModuleName(moduleName2).setBuildSystemType(buildSystemType);
                gradleNativeAndroidModules.add(nativeModule.build());
            }
            GradleBuildDetails.Builder gradleBuild = GradleBuildDetails.newBuilder();
            gradleBuild.setAppId(appId).setAndroidPluginVersion(androidProject.getAgpVersion()).setGradleVersion(gradleVersionString).addAllLibraries(gradleLibraries).addModules(gradleModule).addAllAndroidModules(gradleAndroidModules).addAllNativeAndroidModules(gradleNativeAndroidModules);
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_DETAILS).setGradleBuildDetails(gradleBuild);
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.myProject));
        }
    }

    private boolean isWatchHardwareRequired(AndroidFacet facet2) {
        try {
            return (Boolean)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
                Set<UsedFeatureRawText> usedFeatures = AndroidManifestIndexQueryUtils.queryUsedFeaturesFromManifestIndex(facet2);
                return usedFeatures.contains(new UsedFeatureRawText("android.hardware.type.watch", null)) || usedFeatures.contains(new UsedFeatureRawText("android.hardware.type.watch", "true"));
            });
        }
        catch (Throwable e) {
            LOG.warn("Manifest Index could not be queried", e);
            return false;
        }
    }

    @VisibleForTesting
    static GradleNativeAndroidModule.NativeBuildSystemType stringToBuildSystemType(@NotNull String buildSystem) {
        switch (buildSystem) {
            case "ndkBuild": {
                return GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD;
            }
            case "cmake": {
                return GradleNativeAndroidModule.NativeBuildSystemType.CMAKE;
            }
            case "ndkCompile": {
                return GradleNativeAndroidModule.NativeBuildSystemType.NDK_COMPILE;
            }
            case "gradle": {
                return GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
            }
        }
        return GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
    }

    private static GradleLibrary trackExternalDependenciesInAndroidApp(@NotNull GradleAndroidModel model2) {
        Ref chosenVariant = new Ref();
        model2.getVariants().forEach(variant2 -> {
            if ("release".equals(variant2.getBuildType())) {
                chosenVariant.set(variant2);
            }
        });
        if (chosenVariant.get() == null) {
            chosenVariant.set((Object)model2.getSelectedVariant());
        }
        IdeDependencies dependencies2 = ((IdeVariant)chosenVariant.get()).getMainArtifact().getCompileClasspath();
        return GradleLibrary.newBuilder().setAarDependencyCount((long)dependencies2.getAndroidLibraries().size()).setJarDependencyCount((long)dependencies2.getJavaLibraries().size()).build();
    }

    private static int countGradleProjects(@NotNull ExternalProject externalProject) {
        ArrayList<Object> projects2 = new ArrayList<Object>();
        projects2.add(externalProject);
        int count2 = 0;
        while (!projects2.isEmpty()) {
            ++count2;
            ExternalProject project = (ExternalProject)projects2.remove(0);
            projects2.addAll(project.getChildProjects().values());
        }
        return count2;
    }
}

