/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.jdk;

import com.android.tools.idea.gradle.project.AndroidStudioGradleInstallationManager;
import com.android.tools.idea.gradle.project.sync.jdk.JdkUtilsKt;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.extensions.SdkExtensions;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.jetbrains.rd.util.CollectionExKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/jdk/JdkUtils;", "", "()V", "addOrRecreateDedicatedJdkTableEntry", "", "jdkPath", "getMaxVersionJdkPathFromAllGradleRoots", "project", "Lcom/intellij/openapi/project/Project;", "updateProjectJdkWithPath", "", "intellij.android.projectSystem.gradle"})
public final class JdkUtils {
    @NotNull
    public static final JdkUtils INSTANCE = new JdkUtils();

    private JdkUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getMaxVersionJdkPathFromAllGradleRoots(@NotNull Project project) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Set set;
        Object object;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object list$iv$iv;
        Object key$iv$iv;
        String it;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection collection2 = GradleSettings.getInstance((Project)project).getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getInstance(project).linkedProjectsSettings");
        Iterable iterable = collection2;
        boolean $i$f$mapNotNull = false;
        void var7_5 = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            GradleProjectSettings it2 = (GradleProjectSettings)element$iv$iv;
            boolean bl2 = false;
            if (AndroidStudioGradleInstallationManager.getInstance().getGradleJvmPath(project, it2.getExternalProjectPath()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            it = (String)element$iv$iv;
            boolean bl = false;
            Jdks jdks = Jdks.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Path path2 = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
            key$iv$iv = jdks.findVersion(path2);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it3;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object3;
            boolean bl5 = false;
            Set set2 = CollectionsKt.toSet((Iterable)((Iterable)it3.getValue()));
            object.put(k, set2);
        }
        Object object4 = CollectionExKt.firstOrNull((Map)MapsKt.toSortedMap((Map)destination$iv$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                JavaSdkVersion it = (JavaSdkVersion)b;
                boolean bl = false;
                JavaSdkVersion javaSdkVersion = it;
                it = (JavaSdkVersion)a;
                Comparable comparable = javaSdkVersion != null ? Integer.valueOf(javaSdkVersion.ordinal()) : null;
                bl = false;
                JavaSdkVersion javaSdkVersion2 = it;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(javaSdkVersion2 != null ? Integer.valueOf(javaSdkVersion2.ordinal()) : null));
            }
        }));
        Set set3 = set = object4 != null ? (Set)object4.getValue() : null;
        if (set == null) {
            return null;
        }
        Set maxVersionJdkPaths = set;
        object4 = maxVersionJdkPaths;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$mapValuesTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            list$iv$iv = (String)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(JavaSdk.getInstance().suggestSdkName(null, it), element$iv$iv);
        }
        Collection collection3 = MapsKt.toSortedMap((Map)destination$iv$iv).values();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"maxVersionJdkPaths\n     \u2026SortedMap()\n      .values");
        return (String)CollectionsKt.firstOrNull((Iterable)CollectionsKt.toSet((Iterable)collection3));
    }

    public final void updateProjectJdkWithPath(@NotNull Project project, @NotNull String jdkPath) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)jdkPath, (String)"jdkPath");
            if (!ExternalSystemJdkUtil.isValidJdk((String)jdkPath)) {
                JdkUtilsKt.access$getLOG$p().info("Unable to update project Jdk given invalid path: " + jdkPath);
                return;
            }
            String jdkName = this.addOrRecreateDedicatedJdkTableEntry(jdkPath);
            Sdk sdk = ProjectJdkTable.getInstance().findJdk(jdkName);
            if (sdk == null) break block2;
            Sdk jdk = sdk;
            boolean bl = false;
            Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (projectSdk == null || !SdkExtensions.isEqualTo(projectSdk, jdk)) {
                JavaSdkUtil.applyJdkToProject((Project)project, (Sdk)jdk);
                JdkUtilsKt.access$getLOG$p().info("Updated project Jdk to: " + jdk.getName());
            }
        }
    }

    private final String addOrRecreateDedicatedJdkTableEntry(String jdkPath) {
        String string = JavaSdk.getInstance().suggestSdkName(null, jdkPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().suggestSdkName(null, jdkPath)");
        String suggestedJdkName = string;
        IdeSdks.getInstance().recreateOrAddJdkInTable(jdkPath, suggestedJdkName);
        return suggestedJdkName;
    }
}

