/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateHolder;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporterImplKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncIssue;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0015\u0010\u0010\u001a\u00020\r2\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/SyncIssueUsageReporterImpl;", "Lcom/android/tools/idea/gradle/project/sync/issues/SyncIssueUsageReporter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectedFailure", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$GradleSyncFailure;", "collectedIssues", "", "Lcom/google/wireless/android/sdk/stats/GradleSyncIssue;", "collectedQuickFixes", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$GradleSyncQuickFix;", "collect", "", "failure", "issue", "reportToUsageTracker", "rootProjectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "intellij.android.projectSystem.gradle"})
public final class SyncIssueUsageReporterImpl
implements SyncIssueUsageReporter {
    @NotNull
    private final Project project;
    @NotNull
    private final List<GradleSyncIssue> collectedIssues;
    @NotNull
    private final List<AndroidStudioEvent.GradleSyncQuickFix> collectedQuickFixes;
    @Nullable
    private AndroidStudioEvent.GradleSyncFailure collectedFailure;

    public SyncIssueUsageReporterImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.collectedIssues = new ArrayList();
        this.collectedQuickFixes = new ArrayList();
    }

    @Override
    public void reportToUsageTracker(@NotNull String rootProjectPath) {
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        if (!((Collection)this.collectedIssues).isEmpty()) {
            AndroidStudioEvent.Builder builder2 = GradleSyncStateHolder.Companion.getInstance(this.project).generateSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_ISSUES, rootProjectPath).addAllGradleSyncIssues((Iterable)this.collectedIssues);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"GradleSyncStateHolder\n  \u2026ncIssues(collectedIssues)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder2);
            this.collectedIssues.clear();
        }
        if (!((Collection)this.collectedQuickFixes).isEmpty() || this.collectedFailure != null) {
            AndroidStudioEvent.Builder builder3 = GradleSyncStateHolder.Companion.getInstance(this.project).generateSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE_DETAILS, rootProjectPath).addAllOfferedQuickFixes((Iterable)this.collectedQuickFixes);
            AndroidStudioEvent.GradleSyncFailure gradleSyncFailure = this.collectedFailure;
            if (gradleSyncFailure == null) {
                gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.UNKNOWN_GRADLE_FAILURE;
            }
            AndroidStudioEvent.Builder builder4 = builder3.setGradleSyncFailure(gradleSyncFailure);
            Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"GradleSyncStateHolder\n  \u2026e.UNKNOWN_GRADLE_FAILURE)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder4);
            this.collectedFailure = null;
            this.collectedQuickFixes.clear();
        }
    }

    @Override
    public void collect(@NotNull GradleSyncIssue issue2) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        this.collectedIssues.add(issue2);
    }

    @Override
    public void collect(@NotNull AndroidStudioEvent.GradleSyncFailure failure) {
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        if (this.collectedFailure != null) {
            SyncIssueUsageReporterImplKt.access$getLOG$p().warn("Multiple sync failures reported. Discarding: " + this.collectedFailure);
        }
        this.collectedFailure = failure;
    }
}

