/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.tools.idea.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileSyncMessageHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.AndroidGradleUtil;
import com.android.tools.idea.project.hyperlink.SyncMessageFragment;
import com.android.tools.idea.project.hyperlink.SyncMessageHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class SimpleDeduplicatingSyncIssueReporter
extends BaseSyncIssuesReporter {
    @TestOnly
    @NotNull
    final @NotNull List<@NotNull SyncMessage> report(@NotNull IdeSyncIssue syncIssue, @NotNull Module module2, @Nullable VirtualFile buildFile) {
        return this.reportAll((List<IdeSyncIssue>)ImmutableList.of((Object)syncIssue), (Map<IdeSyncIssue, Module>)ImmutableMap.of((Object)syncIssue, (Object)module2), (Map<Module, VirtualFile>)(buildFile == null ? ImmutableMap.of() : ImmutableMap.of((Object)module2, (Object)buildFile)));
    }

    @NotNull
    final @NotNull List<@NotNull SyncMessage> reportAll(@NotNull List<IdeSyncIssue> syncIssues2, @NotNull Map<IdeSyncIssue, Module> moduleMap, @NotNull Map<Module, VirtualFile> buildFileMap) {
        ArrayList<SyncMessage> result2 = new ArrayList<SyncMessage>();
        LinkedHashMap<Object, List> groupedIssues = new LinkedHashMap<Object, List>();
        for (IdeSyncIssue issue2 : syncIssues2) {
            groupedIssues.computeIfAbsent(this.getDeduplicationKey(issue2), config2 -> new ArrayList()).add(issue2);
        }
        for (List entry : groupedIssues.values()) {
            IdeSyncIssue issue3;
            Module module2;
            if (entry.isEmpty() || (module2 = moduleMap.get(issue3 = (IdeSyncIssue)entry.get(0))) == null) continue;
            List<Module> affectedModules = entry.stream().map(moduleMap::get).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Module::getName)).collect(Collectors.toList());
            boolean isError = entry.stream().anyMatch(i -> i.getSeverity() == 2);
            result2.add(this.createSyncMessage(module2.getProject(), entry, affectedModules, buildFileMap, isError));
        }
        return result2;
    }

    private SyncMessage createSyncMessage(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, boolean isError) {
        MessageType type;
        MessageType messageType = type = isError ? MessageType.WARNING : MessageType.INFO;
        assert (!syncIssues2.isEmpty());
        SyncMessage syncMessage = this.setupSyncMessage(project, syncIssues2, affectedModules, buildFileMap, type);
        List<SyncIssueNotificationHyperlink> customLinks = this.getCustomLinks(project, syncIssues2, affectedModules, buildFileMap);
        syncMessage.add(customLinks);
        if (this.shouldIncludeModuleLinks() && !affectedModules.isEmpty()) {
            final StringBuilder builder2 = new StringBuilder();
            final List links = affectedModules.stream().map(m -> this.doCreateModuleLink(project, (Module)m, syncIssues2, (VirtualFile)buildFileMap.get(m))).collect(Collectors.toList());
            builder2.append("Affected Modules: ");
            List linkHtmls = links.stream().map(SyncMessageHyperlink::toHtml).collect(Collectors.toList());
            builder2.append(String.join((CharSequence)", ", linkHtmls));
            syncMessage.add(new SyncMessageFragment(){

                @Override
                public void executeHandler(@NotNull Project project, @NotNull HyperlinkEvent event) {
                    for (SyncMessageHyperlink link2 : links) {
                        if (!link2.getUrls().contains(event.getDescription())) continue;
                        link2.executeHandler(project, event);
                    }
                }

                @Override
                @NotNull
                public @NotNull Collection<@NotNull String> getUrls() {
                    return ContainerUtil.flatMap((Iterable)links, it -> new ArrayList<String>(it.getUrls()));
                }

                @Override
                @NotNull
                public String toHtml() {
                    return builder2.toString();
                }

                @Override
                @NotNull
                public List<AndroidStudioEvent.GradleSyncQuickFix> getQuickFixIds() {
                    return links.stream().flatMap(it -> it.getQuickFixIds().stream()).collect(Collectors.toList());
                }
            });
        }
        return syncMessage;
    }

    @NotNull
    private SyncMessageHyperlink doCreateModuleLink(@NotNull Project project, @NotNull Module module2, @NotNull List<IdeSyncIssue> syncIssues2, @Nullable VirtualFile buildFile) {
        if (buildFile == null) {
            final String text2 = AndroidGradleUtil.getDisplayNameForModule(module2);
            return new SyncMessageHyperlink("url." + module2.getName(), text2){

                @Override
                @NotNull
                public List<AndroidStudioEvent.GradleSyncQuickFix> getQuickFixIds() {
                    return Collections.emptyList();
                }

                @Override
                protected void execute(@NotNull Project project) {
                }

                @Override
                @NotNull
                public String toHtml() {
                    return text2;
                }
            };
        }
        return this.createModuleLink(project, module2, syncIssues2, buildFile);
    }

    @NotNull
    protected OpenFileSyncMessageHyperlink createModuleLink(@NotNull Project project, @NotNull Module module2, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull VirtualFile buildFile) {
        return new OpenFileSyncMessageHyperlink(buildFile.getPath(), AndroidGradleUtil.getDisplayNameForModule(module2), -1, -1);
    }

    @NotNull
    protected Object getDeduplicationKey(@NotNull IdeSyncIssue issue2) {
        return issue2.getData() == null ? issue2 : issue2.getData();
    }

    protected boolean shouldIncludeModuleLinks() {
        return true;
    }

    @NotNull
    protected List<SyncIssueNotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        return ImmutableList.of();
    }

    @NotNull
    protected SyncMessage setupSyncMessage(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        VirtualFile file2;
        assert (!syncIssues2.isEmpty());
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        PositionInFile position = null;
        if (affectedModules.size() == 1 && (file2 = buildFileMap.get(affectedModules.get(0))) != null) {
            position = new PositionInFile(file2);
        }
        return position != null ? new SyncMessage(project, "Gradle Sync Issues", type, position, syncIssues2.get(0).getMessage()) : new SyncMessage("Gradle Sync Issues", type, syncIssues2.get(0).getMessage());
    }

    public static int getLineNumberForElement(@NotNull Project project, @Nullable PsiElement element2) {
        return (Integer)ApplicationManager.getApplication().runReadAction(() -> {
            Document document2;
            if (element2 != null && (document2 = PsiDocumentManager.getInstance((Project)project).getDocument(element2.getContainingFile())) != null) {
                return document2.getLineNumber(element2.getTextOffset());
            }
            return -1;
        });
    }
}

