/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.issues;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.idea.issues.JdkImportCheckException;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"createNewGradleJvmProjectJdk", "Lcom/intellij/openapi/projectRoots/impl/ProjectJdkImpl;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "validateAndGetErrors", "", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "validateJdk", "", "validateProjectGradleJdk", "javaHome", "intellij.android.projectSystem.gradle"})
@JvmName(name="JdkImportCheck")
public final class JdkImportCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void validateProjectGradleJdk(@NotNull String javaHome) {
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        Sdk sdk = ExternalSystemJdkProvider.getInstance().createJdk(null, javaHome);
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"getInstance().createJdk(null, javaHome)");
        Sdk jdk = sdk;
        try {
            JdkImportCheck.validateJdk(jdk);
        }
        catch (Throwable throwable) {
            Disposable disposable2 = jdk instanceof Disposable ? (Disposable)jdk : null;
            if (disposable2 != null) {
                Disposable it = disposable2;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)jdk));
            }
            throw throwable;
        }
        Disposable disposable3 = jdk instanceof Disposable ? (Disposable)jdk : null;
        if (disposable3 != null) {
            Disposable it = disposable3;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)jdk));
        }
    }

    @VisibleForTesting
    public static final void validateJdk(@NotNull Sdk jdk) {
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        String string = JdkImportCheck.validateAndGetErrors(jdk);
        if (string == null) {
            return;
        }
        String jdkValidationError = string;
        throw new JdkImportCheckException(jdkValidationError);
    }

    private static final String validateAndGetErrors(Sdk jdk) {
        String string = jdk.getHomePath();
        if (string == null) {
            return "Could not find valid Jdk home from the selected Jdk location.";
        }
        String jdkHomePath = string;
        String selectedJdkMsg = "Selected Jdk location is " + jdkHomePath + ".\n";
        JavaSdkVersion javaSdkVersion = IdeSdks.getInstance().getRunningVersionOrDefault();
        Intrinsics.checkNotNullExpressionValue((Object)javaSdkVersion, (String)"getInstance().runningVersionOrDefault");
        JavaSdkVersion runningJdkVersion = javaSdkVersion;
        if (!((Boolean)StudioFlags.ALLOW_DIFFERENT_JDK_VERSION.get()).booleanValue() && !IdeSdks.isJdkSameVersion(Paths.get(jdkHomePath, new String[0]), runningJdkVersion)) {
            return "The version of selected Jdk doesn't match the Jdk used by Studio. Please choose a valid Jdk " + runningJdkVersion.getDescription() + " directory.\n" + selectedJdkMsg;
        }
        if (!JdkUtil.checkForJdk((String)jdkHomePath)) {
            return "The Jdk installation is invalid.\n" + selectedJdkMsg;
        }
        if (Jdks.isJdkRunnableOnPlatform(jdk)) {
            IdeInfo ideInfo = IdeInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideInfo, (String)"getInstance()");
            IdeInfo ideInfo2 = ideInfo;
            if (ideInfo2.isAndroidStudio() || ideInfo2.isGameTools()) {
                Object t = StudioFlags.GRADLE_SYNC_RECREATE_JDK.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"GRADLE_SYNC_RECREATE_JDK.get()");
                if (((Boolean)t).booleanValue()) {
                    WriteAction.runAndWait((ThrowableRunnable)new ThrowableRunnable(jdkHomePath, jdk){
                        final /* synthetic */ String $jdkHomePath;
                        final /* synthetic */ Sdk $jdk;
                        {
                            this.$jdkHomePath = $jdkHomePath;
                            this.$jdk = $jdk;
                        }

                        public final void run() {
                            IdeSdks.getInstance().recreateOrAddJdkInTable(this.$jdkHomePath, this.$jdk.getName());
                        }
                    });
                }
            }
            return null;
        }
        return "The selected Jdk could not run on current OS.\nIf you are using embedded Jdk, please make sure to download Android Studio bundle compatible\nwith the current OS. For example, for x86 systems please choose a 32 bits download option.\n" + selectedJdkMsg;
    }

    @TestOnly
    @NotNull
    public static final ProjectJdkImpl createNewGradleJvmProjectJdk(@NotNull Project project, @NotNull Disposable parent2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNull((Object)externalSystemManager, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.GradleManager");
        Function function = ((GradleManager)externalSystemManager).getExecutionSettingsProvider();
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        Intrinsics.checkNotNull((Object)virtualFile);
        GradleExecutionSettings gradleExecutionSettings = (GradleExecutionSettings)function.fun((Object)new Pair((Object)project, (Object)virtualFile.getPath()));
        ExternalSystemJdkProvider externalSystemJdkProvider = ExternalSystemJdkProvider.getInstance();
        String string = gradleExecutionSettings.getJavaHome();
        Intrinsics.checkNotNull((Object)string);
        Sdk sdk = externalSystemJdkProvider.createJdk(null, string);
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"getInstance().createJdk(\u2026utionSettings.javaHome!!)");
        Sdk sdk2 = sdk;
        Disposer.register((Disposable)parent2, (Disposable)((Disposable)sdk2));
        return (ProjectJdkImpl)sdk2;
    }
}

