/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.flags.ExperimentalSettingsConfigurable;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.diagnostic.VMOptions;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f0\u000bH\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0007J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u0011\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/project/sync/idea/TraceSyncUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "defaultTraceMethods", "", "addTraceJvmArgs", "", "args", "", "Lcom/intellij/openapi/util/Pair;", "createTraceProfileFile", "traceMethods", "findAgentJar", "getTraceMethods", "updateTraceArgsInFile", "intellij.android.core"})
public final class TraceSyncUtil {
    @NotNull
    public static final TraceSyncUtil INSTANCE = new TraceSyncUtil();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String defaultTraceMethods = "# GRADLE\nTrace: com.android.build.gradle.internal.ide.DefaultAndroidProject\nTrace: com.android.build.gradle.internal.ide.ModelBuilder\nTrace: com.android.build.gradle.internal.ide.VariantImpl\nTrace: com.android.build.gradle.internal.ide.dependencies.ArtifactDependencyGraph\nTrace: com.android.build.gradle.internal.ide.dependencies.ArtifactUtils\nTrace: com.android.build.gradle.internal.tasks.factory.TaskAction\nTrace: com.android.build.gradle.internal.tasks.factory.TaskAction2\nTrace: org.gradle.api.internal.artifacts.configurations.DefaultConfiguration$ConfigurationArtifactCollection\nTrace: org.gradle.api.internal.tasks.execution.ExecuteActionsTaskExecuter::execute\nTrace: org.gradle.api.internal.tasks.execution.SkipUpToDateTaskExecuter::execute\nTrace: org.jetbrains.kotlin.gradle.model.builder.KotlinModelBuilder\nTrace: org.jetbrains.kotlin.idea.gradleTooling.model.kapt.KaptModelBuilderService\nTrace: org.jetbrains.plugins.gradle.tooling.internal.ExtraModelBuilder\nTrace: org.jetbrains.kotlin.idea.gradleTooling.KotlinGradleModelBuilder\nTrace: org.jetbrains.kotlin.idea.gradleTooling.KotlinMPPGradleModelBuilder\n\n# IDEA\nTrace: com.android.tools.idea.gradle.project.sync.GradleSyncState::syncFailed\nTrace: com.android.tools.idea.gradle.project.sync.GradleSyncState::syncStarted\nTrace: com.android.tools.idea.gradle.project.sync.GradleSyncState::syncSucceeded\nTrace: com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver::populateProjectExtraModels\nTrace: com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver::populateModuleContentRoots\nTrace: com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver::populateModuleDependencies\nTrace: com.android.tools.idea.gradle.project.sync.idea.data.service.GradleModuleModelDataService::importData\nTrace: com.android.tools.idea.gradle.project.sync.idea.data.service.NdkModuleModelDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.ContentRootDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.LibraryDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.LibraryDependencyDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.ModuleDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.ModuleDependencyDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.ProjectDataServiceImpl::importData\n";

    private TraceSyncUtil() {
    }

    @JvmStatic
    public static final void addTraceJvmArgs(@NotNull List<Pair<String, String>> args) {
        block3: {
            Object v1;
            block2: {
                Intrinsics.checkNotNullParameter(args, (String)"args");
                String expectedKey = "-javaagent:" + INSTANCE.findAgentJar();
                List<String> list2 = ManagementFactory.getRuntimeMXBean().getInputArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getRuntimeMXBean().inputArguments");
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!StringsKt.startsWith$default((String)it, (String)expectedKey, (boolean)false, (int)2, null)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            String string = v1;
            if (string == null) break block3;
            String it = string;
            boolean bl = false;
            char[] cArray = new char[]{'='};
            List optionLine = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (optionLine.size() == 2) {
                LOG.info("Launch Gradle with trace jvm option: " + it);
                args.add((Pair<String, String>)new Pair(optionLine.get(0), optionLine.get(1)));
            }
        }
    }

    @JvmStatic
    public static final void updateTraceArgsInFile() {
        String string;
        String traceArgsPrefix = "-javaagent:" + INSTANCE.findAgentJar() + "=";
        String string2 = GradleExperimentalSettings.getInstance().TRACE_GRADLE_SYNC ? INSTANCE.getTraceMethods() : null;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = INSTANCE.createTraceProfileFile(it);
        } else {
            string = null;
        }
        String traceArgsValue = string;
        try {
            VMOptions.setOption((String)traceArgsPrefix, (String)traceArgsValue);
        }
        catch (IOException e) {
            LOG.error("Unable to write to VM options file", (Throwable)e);
        }
    }

    private final String getTraceMethods() {
        String string;
        GradleExperimentalSettings gradleExperimentalSettings = GradleExperimentalSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)gradleExperimentalSettings, (String)"getInstance()");
        GradleExperimentalSettings settings = gradleExperimentalSettings;
        if (settings.TRACE_PROFILE_SELECTION == ExperimentalSettingsConfigurable.TraceProfileItem.DEFAULT) {
            return defaultTraceMethods;
        }
        File localProfile = new File(Strings.nullToEmpty((String)settings.TRACE_PROFILE_LOCATION));
        if (!localProfile.isFile()) {
            LOG.error("Unable to trace Gradle: could not load trace profile from " + localProfile.getPath() + ".");
            string = null;
        } else {
            string = FilesKt.readText$default((File)localProfile, null, (int)1, null);
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public final String findAgentJar() {
        File path2 = new File(PathManager.getHomePath(), "plugins/android/resources/trace_agent.jar");
        if (!path2.exists()) {
            path2 = new File(PathManager.getHomePath(), "../../bazel-bin/tools/base/tracer/trace_agent.jar");
        }
        String string = path2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.absolutePath");
        return string;
    }

    @VisibleForTesting
    @NotNull
    public final String createTraceProfileFile(@NotNull String traceMethods) {
        Intrinsics.checkNotNullParameter((Object)traceMethods, (String)"traceMethods");
        String outputFileName = "sync_profile_report_" + new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US).format(System.currentTimeMillis()) + ".json";
        String string = FileUtil.toSystemDependentName((String)new File(PathManager.getLogPath(), outputFileName).getAbsolutePath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(Fi\u2026utFileName).absolutePath)");
        String outputFilePath = string;
        String profileContent = "Output: " + outputFilePath + "\n" + traceMethods;
        File file2 = FileUtil.createTempFile((String)"sync.trace", (String)".profile");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(\"sync.trace\", \".profile\")");
        File traceProfile = file2;
        FileUtils.writeToFile((File)traceProfile, (String)profileContent);
        LOG.info("Trace output file: " + outputFileName);
        String string2 = traceProfile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"traceProfile.path");
        return string2;
    }

    static {
        Logger logger2 = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(this::class.java)");
        LOG = logger2;
    }
}

