/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.project.sync.idea.SdkSyncUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a:\u0010\n\u001a\u0004\u0018\u00010\u0007*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0007*\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0002\u001a\u0017\u0010\u0015\u001a\u00020\u0004*\u00020\u00162\u000b\u0010\u0017\u001a\u00070\t\u00a2\u0006\u0002\b\u0018\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "logAndroidSdkHomeNotFound", "", "logSdkFound", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "moduleName", "", "computeSdkReloadingAsNeeded", "Lcom/android/tools/idea/sdk/AndroidSdks;", "project", "Lcom/intellij/openapi/project/Project;", "moduleDisplayName", "compileTarget", "bootClasspath", "", "ideSdks", "Lcom/android/tools/idea/sdk/IdeSdks;", "findMatchingSdkForAddon", "syncAndroidSdks", "Lcom/android/tools/idea/gradle/project/sync/SdkSync;", "projectPath", "Lorg/jetbrains/annotations/SystemDependent;", "intellij.android.projectSystem.gradle"})
@JvmName(name="SdkSyncUtil")
public final class SdkSyncUtil {
    @NotNull
    private static final Logger LOG;

    public static final void syncAndroidSdks(@NotNull SdkSync $this$syncAndroidSdks, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)$this$syncAndroidSdks, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        File projectDir = new File(projectPath);
        if (!projectDir.isDirectory()) {
            throw new IllegalStateException("The project directory does not exist!");
        }
        LocalProperties localProperties = new LocalProperties(projectDir);
        $this$syncAndroidSdks.syncIdeAndProjectAndroidSdks(localProperties);
    }

    @Nullable
    public static final Sdk computeSdkReloadingAsNeeded(@NotNull AndroidSdks $this$computeSdkReloadingAsNeeded, @NotNull Project project, @NotNull String moduleDisplayName, @NotNull String compileTarget, @NotNull Collection<String> bootClasspath, @NotNull IdeSdks ideSdks) {
        Intrinsics.checkNotNullParameter((Object)$this$computeSdkReloadingAsNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleDisplayName, (String)"moduleDisplayName");
        Intrinsics.checkNotNullParameter((Object)compileTarget, (String)"compileTarget");
        Intrinsics.checkNotNullParameter(bootClasspath, (String)"bootClasspath");
        Intrinsics.checkNotNullParameter((Object)ideSdks, (String)"ideSdks");
        Sdk sdk = $this$computeSdkReloadingAsNeeded.findSuitableAndroidSdk(compileTarget);
        if (sdk != null) {
            VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"sdk.rootProvider.getFiles(CLASSES)");
            if (((Object[])virtualFileArray).length == 0) {
                Sdk sdkToRemove = sdk;
                ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(sdkToRemove){
                    final /* synthetic */ Sdk $sdkToRemove;
                    {
                        this.$sdkToRemove = $sdkToRemove;
                        super(0);
                    }

                    public final void invoke() {
                        Sdk sdk = this.$sdkToRemove;
                        boolean $i$f$runWriteAction = false;
                        ApplicationManager.getApplication().runWriteAction(new Computable(sdk){
                            final /* synthetic */ Sdk $sdkToRemove$inlined;
                            {
                                this.$sdkToRemove$inlined = sdk;
                            }

                            public final T compute() {
                                boolean bl = false;
                                ProjectJdkTable.getInstance().removeJdk(this.$sdkToRemove$inlined);
                                return (T)Unit.INSTANCE;
                            }
                        });
                    }
                }), (int)1, null);
                sdk = null;
            }
        }
        if (sdk != null) {
            SdkSyncUtil.logSdkFound(sdk, moduleDisplayName);
            return sdk;
        }
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(SdkSync.class);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable($this$computeSdkReloadingAsNeeded, progress2){
            final /* synthetic */ AndroidSdks $this_computeSdkReloadingAsNeeded;
            final /* synthetic */ StudioLoggerProgressIndicator $progress;
            {
                this.$this_computeSdkReloadingAsNeeded = $receiver;
                this.$progress = $progress;
            }

            public final void run() {
                this.$this_computeSdkReloadingAsNeeded.tryToChooseSdkHandler().getSdkManager((ProgressIndicator)this.$progress).reloadLocalIfNeeded((ProgressIndicator)this.$progress);
            }
        }, "Reloading SDKs", false, project);
        File androidSdkHomePath = ideSdks.getAndroidSdkPath();
        if (androidSdkHomePath == null) {
            SdkSyncUtil.logAndroidSdkHomeNotFound();
            return null;
        }
        Ref.ObjectRef newSdk = new Ref.ObjectRef();
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<Sdk>)newSdk, $this$computeSdkReloadingAsNeeded, androidSdkHomePath, compileTarget){
            final /* synthetic */ Ref.ObjectRef<Sdk> $newSdk;
            final /* synthetic */ AndroidSdks $this_computeSdkReloadingAsNeeded;
            final /* synthetic */ File $androidSdkHomePath;
            final /* synthetic */ String $compileTarget;
            {
                this.$newSdk = $newSdk;
                this.$this_computeSdkReloadingAsNeeded = $receiver;
                this.$androidSdkHomePath = $androidSdkHomePath;
                this.$compileTarget = $compileTarget;
                super(0);
            }

            public final void invoke() {
                AndroidSdks androidSdks = this.$this_computeSdkReloadingAsNeeded;
                File file2 = this.$androidSdkHomePath;
                String string = this.$compileTarget;
                boolean $i$f$runWriteAction = false;
                this.$newSdk.element = ApplicationManager.getApplication().runWriteAction(new Computable(androidSdks, file2, string){
                    final /* synthetic */ AndroidSdks $this_computeSdkReloadingAsNeeded$inlined;
                    final /* synthetic */ File $androidSdkHomePath$inlined;
                    final /* synthetic */ String $compileTarget$inlined;
                    {
                        this.$this_computeSdkReloadingAsNeeded$inlined = androidSdks;
                        this.$androidSdkHomePath$inlined = file2;
                        this.$compileTarget$inlined = string;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)this.$this_computeSdkReloadingAsNeeded$inlined.tryToCreate(this.$androidSdkHomePath$inlined, this.$compileTarget$inlined);
                    }
                });
            }
        }), (int)1, null);
        if (newSdk.element != null) {
            Object object = newSdk.element;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.projectRoots.Sdk");
            SdkSyncUtil.logSdkFound((Sdk)object, moduleDisplayName);
            Object object2 = newSdk.element;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.openapi.projectRoots.Sdk");
            return (Sdk)object2;
        }
        return SdkSyncUtil.findMatchingSdkForAddon($this$computeSdkReloadingAsNeeded, bootClasspath);
    }

    /*
     * WARNING - void declaration
     */
    private static final Sdk findMatchingSdkForAddon(AndroidSdks $this$findMatchingSdkForAddon, Collection<String> bootClasspath) {
        Object v5;
        File androidJarPath;
        block11: {
            Object v0;
            block9: {
                void $this$firstOrNull$iv;
                Iterator $this$mapTo$iv$iv;
                if (bootClasspath.size() <= 1) {
                    return null;
                }
                Iterable $this$map$iv = bootClasspath;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void path2;
                    Object item$iv$iv = iterator2.next();
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(new File((String)path2));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File file2 = (File)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)file2.getName(), (Object)"android.jar")) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            File file3 = v0;
            if (file3 == null) {
                AndroidSdks $this$findMatchingSdkForAddon_u24lambda_u2d2 = $this$findMatchingSdkForAddon;
                boolean bl = false;
                LOG.warn("Unable to find android.jar in bootclasspath. Bootclasspath: " + CollectionsKt.joinToString$default((Iterable)bootClasspath, null, null, null, (int)0, null, null, (int)63, null) + ".");
                return null;
            }
            androidJarPath = file3;
            List<Sdk> list2 = $this$findMatchingSdkForAddon.getAllAndroidSdks();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"allAndroidSdks");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block10: {
                    Sdk sdk = (Sdk)element$iv;
                    boolean bl2 = false;
                    VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"sdk.rootProvider.getFiles(CLASSES)");
                    Object[] $this$any$iv = virtualFileArray;
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        VirtualFile sdkFile = (VirtualFile)element$iv2;
                        boolean bl3 = false;
                        if (!FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile), (File)androidJarPath)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v5 = element$iv;
                break block11;
            }
            v5 = null;
        }
        Object var3_25 = v5;
        Sdk it = var3_25;
        boolean bl = false;
        if (it == null) {
            Object object;
            if ($this$findMatchingSdkForAddon.getAllAndroidSdks().isEmpty()) {
                object = "No available Android SDKs.";
            } else {
                List<Sdk> list3 = $this$findMatchingSdkForAddon.getAllAndroidSdks();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"allAndroidSdks");
                object = "Available Android SDKs: " + CollectionsKt.joinToString$default((Iterable)list3, null, null, null, (int)0, null, (Function1)findMatchingSdkForAddon.2.availableSdks.1.INSTANCE, (int)31, null) + ".";
            }
            String availableSdks2 = object;
            LOG.warn("Unable to find Android SDK that contains " + androidJarPath + ". " + availableSdks2);
        }
        return var3_25;
    }

    private static final void logAndroidSdkHomeNotFound() {
        LOG.warn("Path to Android SDK not set");
        List<Sdk> list2 = IdeSdks.getInstance().getEligibleAndroidSdks();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance().eligibleAndroidSdks");
        List<Sdk> sdks = list2;
        LOG.warn("# of eligible SDKs: " + sdks.size());
        Iterable $this$forEach$iv = sdks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sdk sdk = (Sdk)element$iv;
            boolean bl = false;
            LOG.info("sdk: " + sdk);
        }
    }

    private static final void logSdkFound(Sdk sdk, String moduleName2) {
        String string = sdk.getHomePath();
        if (string == null) {
            string = "<path not set>";
        }
        String sdkPath = string;
        LOG.info("Set Android SDK '" + sdk.getName() + "' (" + sdkPath + ") to module " + moduleName2);
    }

    static {
        Logger logger2 = Logger.getInstance(SdkSync.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(SdkSync::class.java)");
        LOG = logger2;
    }
}

