/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.idea.IdeaSyncPopulateProjectTask;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    @NotNull
    private final Project myProject;
    @Nullable
    private final GradleSyncListener mySyncListener;

    ProjectSetUpTask(@NotNull Project project, @Nullable GradleSyncListener syncListener) {
        this.myProject = project;
        this.mySyncListener = syncListener;
    }

    @WorkerThread
    public void onSuccess(@NotNull ExternalSystemTaskId taskId, @Nullable DataNode<ProjectData> projectInfo) {
        assert (projectInfo != null);
        this.doPopulateProject(projectInfo);
    }

    @WorkerThread
    private void doPopulateProject(@NotNull DataNode<ProjectData> projectInfo) {
        IdeaSyncPopulateProjectTask task2 = new IdeaSyncPopulateProjectTask(this.myProject);
        task2.populateProject(projectInfo, this.mySyncListener);
    }

    public void onFailure(@NotNull ExternalSystemTaskId externalTaskId, @NotNull String errorMessage, @Nullable String errorDetails) {
        if (errorMessage.contains(ExternalSystemBundle.message((String)"error.resolve.already.running", (Object[])new Object[]{""}))) {
            return;
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (!this.myProject.isDisposed()) {
                ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
            }
        });
        String exceptionMessage = errorDetails == null || errorMessage.contains(errorDetails) ? errorMessage : errorMessage + "\n" + errorDetails;
        String messageWithGuide = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{exceptionMessage});
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, messageWithGuide);
        }
    }
}

