/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.model.impl.IdeResolvedLibraryTable;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.GradleAndroidModelData;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleProjectModels;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateHolder;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateImplKt;
import com.android.tools.idea.gradle.project.sync.PsdModuleModels;
import com.android.tools.idea.gradle.project.sync.SelectedVariantCollector;
import com.android.tools.idea.gradle.project.sync.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolverKeys;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolverMarker;
import com.android.tools.idea.gradle.project.sync.idea.IdeAndroidNativeVariantsModelsWrapper;
import com.android.tools.idea.gradle.project.sync.idea.ProjectResolutionMode;
import com.android.tools.idea.gradle.project.sync.idea.ProjectSetUpTask;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssues;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;

public class GradleSyncExecutor {
    @NotNull
    private final Project myProject;
    @NotNull
    public static final com.intellij.openapi.util.Key<Boolean> ALWAYS_SKIP_SYNC = new com.intellij.openapi.util.Key("android.always.skip.sync");
    @VisibleForTesting
    @NotNull
    public static final com.intellij.openapi.util.Key<GradleSyncInvoker.Request> SKIPPED_SYNC = new com.intellij.openapi.util.Key("android.skipped.sync");

    public GradleSyncExecutor(@NotNull Project project) {
        this.myProject = project;
    }

    @UiThread
    public void sync(@NotNull GradleSyncInvoker.Request request2, @Nullable GradleSyncListener listener2) {
        if (Objects.equals(this.myProject.getUserData(ALWAYS_SKIP_SYNC), true)) {
            if (this.myProject.getUserData(SKIPPED_SYNC) != null) {
                throw new IllegalStateException("Skipped sync request already present");
            }
            this.myProject.putUserData(SKIPPED_SYNC, (Object)request2);
            GradleSyncStateHolder.getInstance(this.myProject).syncSkipped(listener2);
            return;
        }
        Collection androidProjectCandidatesPaths = GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().stream().map(ExternalProjectSettings::getExternalProjectPath).sorted().collect(Collectors.toList());
        if (androidProjectCandidatesPaths.isEmpty() && IdeInfo.getInstance().isAndroidStudio()) {
            String foundPath = GradleSyncExecutor.attemptToLinkGradleProject(this.myProject);
            if (foundPath != null) {
                androidProjectCandidatesPaths.add(foundPath);
            } else {
                GradleSyncStateHolder.getInstance(this.myProject).syncSkipped(listener2);
                return;
            }
        }
        for (String rootPath : androidProjectCandidatesPaths) {
            ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, listener2);
            ProgressExecutionMode executionMode = request2.getProgressExecutionMode();
            ImportSpecBuilder builder2 = new ImportSpecBuilder(this.myProject, GradleUtil.GRADLE_SYSTEM_ID).callback((ExternalProjectRefreshCallback)setUpTask).use(executionMode);
            if (request2.getDontFocusSyncFailureOutput()) {
                builder2.dontReportRefreshErrors();
            }
            GradleSyncStateImplKt.setProjectSyncRequest(this.myProject, rootPath, request2);
            ExternalSystemUtil.refreshProject((String)rootPath, (ImportSpec)builder2.build());
        }
    }

    @Nullable
    public static String attemptToLinkGradleProject(@NotNull Project project) {
        @SystemIndependent String projectBasePath = project.getBasePath();
        if (projectBasePath == null) {
            return null;
        }
        String externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)projectBasePath);
        VirtualFile projectRootFolder = project.getBaseDir();
        if (!GradleProjectImportUtil.canOpenGradleProject((VirtualFile)projectRootFolder)) {
            return null;
        }
        GradleProjectSettings projectSettings = new GradleProjectSettings();
        GradleProjectImportUtil.setupGradleSettings((GradleSettings)GradleSettings.getInstance((Project)project));
        GradleProjectImportUtil.setupGradleProjectSettings((GradleProjectSettings)projectSettings, (Project)project, (Path)new File(externalProjectPath).toPath());
        GradleJvmResolutionUtil.setupGradleJvm((Project)project, (GradleProjectSettings)projectSettings, (GradleVersion)projectSettings.resolveGradleVersion());
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)projectSettings);
        return externalProjectPath;
    }

    @WorkerThread
    @NotNull
    public GradleProjectModels fetchGradleModels() {
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(this.myProject);
        if (settings == null) {
            throw new IllegalStateException("Cannot obtain GradleExecutionSettings");
        }
        ExternalSystemTaskId id2 = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        settings.putUserData(AndroidGradleProjectResolverKeys.REQUESTED_PROJECT_RESOLUTION_MODE_KEY, (Object)ProjectResolutionMode.FetchAllVariantsMode.INSTANCE);
        GradleProjectResolver projectResolver = new GradleProjectResolver();
        DataNode projectDataNode = projectResolver.resolveProjectInfo(id2, projectPath, false, (ExternalSystemExecutionSettings)settings, ExternalSystemTaskNotificationListenerAdapter.NULL_OBJECT);
        ImmutableList.Builder builder2 = ImmutableList.builder();
        IdeResolvedLibraryTable libraryTable = null;
        if (projectDataNode != null) {
            DataNode rootProjectNode = ExternalSystemApiUtil.find((DataNode)projectDataNode, (Key)ExternalProjectDataCache.KEY);
            DataNode libraryTableNode = ExternalSystemApiUtil.find((DataNode)projectDataNode, AndroidProjectKeys.IDE_LIBRARY_TABLE);
            if (libraryTableNode != null) {
                libraryTable = (IdeResolvedLibraryTable)libraryTableNode.getData();
            }
            Collection moduleNodes = ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE);
            for (DataNode moduleNode : moduleNodes) {
                DataNode androidModelNode;
                DataNode gradleModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.GRADLE_MODULE_MODEL);
                if (gradleModelNode == null) continue;
                PsdModuleModels moduleModules = new PsdModuleModels(((ModuleData)moduleNode.getData()).getExternalName());
                moduleModules.addModel(GradleModuleModel.class, (GradleModuleModel)gradleModelNode.getData());
                @NotNull Collection syncIssueNodes = ExternalSystemApiUtil.findAll((DataNode)moduleNode, AndroidProjectKeys.SYNC_ISSUE);
                if (!syncIssueNodes.isEmpty()) {
                    moduleModules.addModel(SyncIssues.class, new SyncIssues(ContainerUtil.map((Collection)syncIssueNodes, DataNode::getData)));
                }
                if ((androidModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.ANDROID_MODEL)) != null) {
                    moduleModules.addModel(GradleAndroidModelData.class, (GradleAndroidModelData)androidModelNode.getData());
                    DataNode ndkModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.NDK_MODEL);
                    if (ndkModelNode != null) {
                        moduleModules.addModel(NdkModuleModel.class, (NdkModuleModel)ndkModelNode.getData());
                    }
                }
                if (rootProjectNode != null) {
                    DataNode dependenciesNode;
                    ExternalProject project = this.findExternalProjectForModule((DataNode<ExternalProject>)rootProjectNode, (DataNode<ModuleData>)moduleNode);
                    if (project != null) {
                        moduleModules.addModel(ExternalProject.class, project);
                    }
                    if ((dependenciesNode = ExternalSystemApiUtil.find((DataNode)moduleNode, (Key)ProjectKeys.DEPENDENCIES_GRAPH)) != null) {
                        moduleModules.addModel(ProjectDependencies.class, (ProjectDependencies)dependenciesNode.getData());
                    }
                }
                builder2.add((Object)moduleModules);
            }
        }
        return new GradleProjectModels((List<? extends GradleModuleModels>)builder2.build(), libraryTable);
    }

    @Nullable
    private ExternalProject findExternalProjectForModule(@NotNull DataNode<ExternalProject> rootProjectNode, @NotNull DataNode<ModuleData> moduleNode) {
        String[] moduleIdParts = ((ModuleData)moduleNode.getData()).getId().split(":");
        ExternalProject project = (ExternalProject)rootProjectNode.getData();
        for (String idPart : moduleIdParts) {
            if (idPart.isEmpty() || (project = (ExternalProject)project.getChildProjects().get(idPart)) != null) continue;
            Logger.getInstance(GradleSyncExecutor.class).warn("Could not find ExternalProject for " + ((ModuleData)moduleNode.getData()).getId(), new Throwable());
            return null;
        }
        return project;
    }

    @WorkerThread
    public void fetchAndMergeNativeVariants(@NotNull @NotNull Set<@NotNull String> requestedAbis) {
        SelectedVariantCollector variantCollector = new SelectedVariantCollector(this.myProject);
        SelectedVariants selectedVariants2 = variantCollector.collectSelectedVariants();
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(this.myProject);
        if (settings == null) {
            throw new IllegalStateException("Cannot obtain GradleExecutionSettings");
        }
        Map<String, String> variantsByNativeModule = selectedVariants2.getSelectedVariants().values().stream().filter(it -> it.getAbiName() != null).collect(Collectors.toMap(it -> it.getModuleId(), it -> it.getVariantName()));
        settings.putUserData(AndroidGradleProjectResolverKeys.REQUESTED_PROJECT_RESOLUTION_MODE_KEY, (Object)new ProjectResolutionMode.FetchNativeVariantsMode(variantsByNativeModule, requestedAbis));
        ExternalSystemTaskId id2 = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        GradleProjectResolver projectResolver = new GradleProjectResolver();
        GradlePartialResolverPolicy projectResolverPolicy = new GradlePartialResolverPolicy(it -> it instanceof AndroidGradleProjectResolverMarker);
        DataNode projectDataNode = projectResolver.resolveProjectInfo(id2, projectPath, false, settings, (ProjectResolverPolicy)projectResolverPolicy, ExternalSystemTaskNotificationListenerAdapter.NULL_OBJECT);
        if (projectDataNode == null) {
            Logger.getInstance(GradleSyncExecutor.class).warn("Failed to retrieve native variant models.");
            return;
        }
        @NotNull Collection nativeVariants = ExternalSystemApiUtil.findAll((DataNode)projectDataNode, AndroidProjectKeys.NATIVE_VARIANTS);
        Map<String, Module> moduleMap = Stream.of(ModuleManager.getInstance((Project)this.myProject).getModules()).filter(it -> ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)it)).collect(Collectors.toMap(it -> ExternalSystemApiUtil.getExternalProjectId((Module)it), it -> it));
        for (DataNode nativeVariantsWrapperNode : nativeVariants) {
            IdeAndroidNativeVariantsModelsWrapper nativeVariantsWrapper = (IdeAndroidNativeVariantsModelsWrapper)nativeVariantsWrapperNode.getData();
            String moduleId = nativeVariantsWrapper.getModuleId();
            Module module2 = moduleMap.get(moduleId);
            if (module2 == null) {
                Logger.getInstance(GradleSyncExecutor.class).error("Module not found. ModuleId: " + moduleId);
                continue;
            }
            NdkFacet ndkFacet = NdkFacet.getInstance(module2);
            if (ndkFacet == null) {
                Logger.getInstance(GradleSyncExecutor.class).error("NdkFacet not found. ModuleId: " + moduleId);
                continue;
            }
            nativeVariantsWrapper.mergeInto(ndkFacet);
        }
    }
}

