/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.hyperlink.HyperlinkUtil;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InstallPlatformHyperlink
extends SyncIssueNotificationHyperlink {
    @NotNull
    private final AndroidVersion[] myAndroidVersions;

    public InstallPlatformHyperlink(@NotNull Collection<AndroidVersion> androidVersions) {
        this(androidVersions.toArray(new AndroidVersion[0]));
    }

    public InstallPlatformHyperlink(AndroidVersion ... androidVersions) {
        super("install.android.platform", "Install missing platform(s) and sync project", AndroidStudioEvent.GradleSyncQuickFix.INSTALL_PLATFORM_HYPERLINK);
        this.myAndroidVersions = androidVersions;
    }

    @Override
    protected void execute(@NotNull Project project) {
        ArrayList<String> requested = new ArrayList<String>();
        for (AndroidVersion version2 : this.myAndroidVersions) {
            requested.add(DetailsTypes.getPlatformPath((AndroidVersion)version2));
        }
        ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, requested);
        if (dialog2 != null && dialog2.showAndGet()) {
            HyperlinkUtil.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_QF_PLATFORM_INSTALLED);
        }
    }
}

