/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.hyperlink.HyperlinkUtil;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.project.Project;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class FixGradleVersionInWrapperHyperlink
extends SyncIssueNotificationHyperlink {
    @NotNull
    private final GradleWrapper myGradleWrapper;
    @NotNull
    private final String myGradleVersion;

    @Nullable
    public static SyncIssueNotificationHyperlink createIfProjectUsesGradleWrapper(@NotNull Project project, @Nullable String gradleVersion2) {
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        if (gradleWrapper != null) {
            String version2 = gradleVersion2 != null ? gradleVersion2 : GradleWrapper.getGradleVersionToUse();
            return new FixGradleVersionInWrapperHyperlink(gradleWrapper, version2);
        }
        return null;
    }

    private FixGradleVersionInWrapperHyperlink(@NotNull GradleWrapper gradleWrapper, @NotNull String gradleVersion2) {
        super("fixGradleVersionInWrapper", "Fix Gradle wrapper and re-import project", AndroidStudioEvent.GradleSyncQuickFix.FIX_GRADLE_VERSION_IN_WRAPPER_HYPERLINK);
        this.myGradleWrapper = gradleWrapper;
        this.myGradleVersion = gradleVersion2;
    }

    @Override
    protected void execute(@NotNull Project project) {
        this.myGradleWrapper.updateDistributionUrlAndDisplayFailure(this.myGradleVersion);
        FixGradleVersionInWrapperHyperlink.setDistributionTypeAndSync(project);
    }

    @Override
    public boolean executeIfClicked(@NotNull Project project, @NotNull HyperlinkEvent event) {
        boolean updated = this.myGradleWrapper.updateDistributionUrlAndDisplayFailure(this.myGradleVersion);
        if (updated) {
            EditableNotificationMessageElement.disableLink((HyperlinkEvent)event);
            FixGradleVersionInWrapperHyperlink.setDistributionTypeAndSync(project);
        }
        return updated;
    }

    private static void setDistributionTypeAndSync(@NotNull Project project) {
        GradleProjectSettings settings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
        if (settings != null) {
            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        }
        FixGradleVersionInWrapperHyperlink.requestSync(project);
    }

    private static void requestSync(@NotNull Project project) {
        HyperlinkUtil.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_QF_WRAPPER_GRADLE_VERSION_FIXED);
    }

    @VisibleForTesting
    @NotNull
    public String getGradleVersion() {
        return this.myGradleVersion;
    }
}

