/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvokerKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.DescribedBuildIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.CreateGradleWrapperQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenFileAtLocationQuickFix;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016JD\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00170\u0016H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "UNSUPPORTED_GRADLE_VERSION_PATTERN_1", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "UNSUPPORTED_GRADLE_VERSION_PATTERN_2", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "formatMessage", "getSupportedGradleVersion", "FixGradleVersionInWrapperQuickFix", "OpenGradleSettingsQuickFix", "intellij.android.projectSystem.gradle"})
public final class UnsupportedGradleVersionIssueChecker
implements GradleIssueChecker {
    private final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN_1 = Pattern.compile("Minimum supported Gradle version is (.*)\\. Current version is.*", 32);
    private final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN_2 = Pattern.compile("Gradle version (.*) is required.*", 32);

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        String string;
        boolean isOldGradleError;
        boolean bl;
        Throwable error;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable throwable = error = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        if (throwable instanceof UnsupportedVersionException) {
            bl = true;
        } else if (throwable instanceof UnsupportedMethodException) {
            String string2 = error.getMessage();
            bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"GradleProject.getBuildScript", (boolean)false, (int)2, null) : false;
        } else if (throwable instanceof ClassNotFoundException) {
            String string3 = error.getMessage();
            if (string3 != null) {
                CharSequence charSequence = string3;
                String string4 = ToolingModelBuilderRegistry.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ToolingModelBuilderRegistry::class.java.name");
                bl = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string4, (boolean)false, (int)2, null);
            } else {
                bl = false;
            }
        } else {
            bl = isOldGradleError = false;
        }
        if ((string = this.formatMessage(error.getMessage())) == null) {
            if (isOldGradleError) {
                string = "The project is using an unsupported version of Gradle.\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
            } else {
                return null;
            }
        }
        String message2 = string;
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(issueData){
            final /* synthetic */ GradleIssueData $issueData$inlined;
            {
                this.$issueData$inlined = gradleIssueData;
            }

            public final void run() {
                boolean bl = false;
                BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
            }
        }, ModalityState.defaultModalityState());
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        Project ideaProject = BuildIssueUtilKt.fetchIdeaProjectForGradleProject(issueData.getProjectPath());
        if (ideaProject != null) {
            GradleWrapper gradleWrapper = GradleWrapper.find(ideaProject);
            String gradleVersion2 = this.getSupportedGradleVersion(message2);
            if (gradleWrapper != null) {
                buildIssueComposer.addQuickFix(new FixGradleVersionInWrapperQuickFix(gradleWrapper, gradleVersion2));
                File file2 = gradleWrapper.getPropertiesFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"gradleWrapper.propertiesFilePath");
                File propertiesFile = file2;
                if (propertiesFile.exists()) {
                    buildIssueComposer.addQuickFix("Open Gradle wrapper properties", new OpenFileAtLocationQuickFix(new FilePosition(propertiesFile, -1, -1)));
                }
            } else {
                GradleProjectSettings gradleProjectSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(ideaProject);
                if (gradleProjectSettings != null && gradleProjectSettings.getDistributionType() == DistributionType.LOCAL) {
                    buildIssueComposer.addQuickFix("Migrate to Gradle wrapper and sync project", new CreateGradleWrapperQuickFix());
                }
            }
        }
        buildIssueComposer.addQuickFix("Gradle Settings.", new OpenGradleSettingsQuickFix());
        return buildIssueComposer.composeBuildIssue();
    }

    private final String formatMessage(String message2) {
        if (message2 == null) {
            return null;
        }
        StringBuilder formattedMsg = new StringBuilder();
        if (this.UNSUPPORTED_GRADLE_VERSION_PATTERN_1.matcher(message2).matches() || this.UNSUPPORTED_GRADLE_VERSION_PATTERN_2.matcher(message2).matches()) {
            int index2 = StringsKt.indexOf$default((CharSequence)message2, (String)"If using the gradle wrapper", (int)0, (boolean)false, (int)6, null);
            if (index2 != -1) {
                String string = message2.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                formattedMsg.append(((Object)StringsKt.trim((CharSequence)string)).toString());
            } else {
                formattedMsg.append(message2);
            }
            if (((CharSequence)formattedMsg).length() > 0 && !StringsKt.endsWith$default((CharSequence)formattedMsg, (char)'.', (boolean)false, (int)2, null)) {
                formattedMsg.append('.');
            }
            formattedMsg.append("\n\nPlease fix the project's Gradle settings.");
            return formattedMsg.toString();
        }
        return null;
    }

    private final String getSupportedGradleVersion(String message2) {
        Object[] objectArray = new Pattern[]{this.UNSUPPORTED_GRADLE_VERSION_PATTERN_1, this.UNSUPPORTED_GRADLE_VERSION_PATTERN_2};
        for (Pattern pattern : CollectionsKt.listOf((Object[])objectArray)) {
            String version2;
            Matcher matcher = pattern.matcher(message2);
            if (!matcher.matches() || !StringUtil.isNotEmpty((String)(version2 = matcher.group(1)))) continue;
            return version2;
        }
        return null;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location2, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return this.UNSUPPORTED_GRADLE_VERSION_PATTERN_1.matcher(failureCause).matches() || this.UNSUPPORTED_GRADLE_VERSION_PATTERN_2.matcher(failureCause).matches();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionIssueChecker$OpenGradleSettingsQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "()V", "id", "", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
    public static final class OpenGradleSettingsQuickFix
    implements BuildIssueQuickFix {
        @NotNull
        private final String id;

        public OpenGradleSettingsQuickFix() {
            this.id = "open.gradle.settings";
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            CompletableFuture future2 = new CompletableFuture();
            ModalityState modalityState$iv = null;
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(project, future2){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ CompletableFuture $future$inlined;
                {
                    this.$project$inlined = project;
                    this.$future$inlined = completableFuture;
                }

                public final void run() {
                    boolean bl = false;
                    ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
                    boolean bl2 = manager instanceof GradleManager;
                    if (_Assertions.ENABLED && !bl2) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    Intrinsics.checkNotNull((Object)manager, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.GradleManager");
                    Configurable configurable = ((GradleManager)manager).getConfigurable(this.$project$inlined);
                    Intrinsics.checkNotNullExpressionValue((Object)configurable, (String)"manager as GradleManager).getConfigurable(project)");
                    Configurable configurable2 = configurable;
                    ShowSettingsUtil.getInstance().editConfigurable(this.$project$inlined, configurable2);
                    this.$future$inlined.complete(null);
                }
            }, ModalityState.defaultModalityState());
            return future2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionIssueChecker$FixGradleVersionInWrapperQuickFix;", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/DescribedBuildIssueQuickFix;", "gradleWrapper", "Lcom/android/tools/idea/gradle/util/GradleWrapper;", "gradleVersion", "", "(Lcom/android/tools/idea/gradle/util/GradleWrapper;Ljava/lang/String;)V", "description", "getDescription", "()Ljava/lang/String;", "getGradleVersion", "id", "getId", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
    public static final class FixGradleVersionInWrapperQuickFix
    implements DescribedBuildIssueQuickFix {
        @Nullable
        private GradleWrapper gradleWrapper;
        @NotNull
        private final String id;
        @NotNull
        private final String gradleVersion;

        public FixGradleVersionInWrapperQuickFix(@Nullable GradleWrapper gradleWrapper, @Nullable String gradleVersion2) {
            this.gradleWrapper = gradleWrapper;
            this.id = "fix.gradle.version.in.wrapper";
            String string = gradleVersion2;
            if (string == null) {
                string = "8.0";
            }
            this.gradleVersion = string;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Change Gradle version in Gradle wrapper to " + this.gradleVersion + " and re-import project";
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public final String getGradleVersion() {
            return this.gradleVersion;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            CompletableFuture future2 = new CompletableFuture();
            ModalityState modalityState$iv = null;
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(this, project, future2){
                final /* synthetic */ FixGradleVersionInWrapperQuickFix this$0;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ CompletableFuture $future$inlined;
                {
                    this.this$0 = fixGradleVersionInWrapperQuickFix;
                    this.$project$inlined = project;
                    this.$future$inlined = completableFuture;
                }

                public final void run() {
                    block5: {
                        block4: {
                            boolean bl = false;
                            if (FixGradleVersionInWrapperQuickFix.access$getGradleWrapper$p(this.this$0) != null) break block4;
                            GradleWrapper gradleWrapper = GradleWrapper.find(this.$project$inlined);
                            if (gradleWrapper == null) break block5;
                            FixGradleVersionInWrapperQuickFix.access$setGradleWrapper$p(this.this$0, gradleWrapper);
                        }
                        GradleWrapper gradleWrapper = FixGradleVersionInWrapperQuickFix.access$getGradleWrapper$p(this.this$0);
                        Intrinsics.checkNotNull((Object)gradleWrapper);
                        gradleWrapper.updateDistributionUrlAndDisplayFailure(this.this$0.getGradleVersion());
                        GradleProjectSettings settings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(this.$project$inlined);
                        if (settings != null) {
                            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
                        }
                        GradleSyncInvokerKt.requestProjectSync$default(GradleSyncInvoker.Companion.getInstance(), this.$project$inlined, GradleSyncStats.Trigger.TRIGGER_QF_WRAPPER_GRADLE_VERSION_FIXED, null, 4, null);
                        this.$future$inlined.complete(null);
                    }
                }
            }, ModalityState.defaultModalityState());
            return future2;
        }

        public static final /* synthetic */ GradleWrapper access$getGradleWrapper$p(FixGradleVersionInWrapperQuickFix $this) {
            return $this.gradleWrapper;
        }

        public static final /* synthetic */ void access$setGradleWrapper$p(FixGradleVersionInWrapperQuickFix $this, GradleWrapper gradleWrapper) {
            $this.gradleWrapper = gradleWrapper;
        }
    }
}

