/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenPluginBuildFileQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.UpgradeGradleVersionsQuickFix;
import com.android.tools.idea.gradle.util.CompatibleGradleVersion;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "tryToGetUnsupportedGradleMessage", "Companion", "intellij.android.projectSystem.gradle.upgrade"})
public final class OldAndroidPluginIssueChecker
implements GradleIssueChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN = Pattern.compile("Support for builds using Gradle versions older than (.*?) .* You are currently using Gradle version (.*?). .*", 32);
    @NotNull
    private static final AgpVersion MINIMUM_AGP_VERSION_JDK_8 = new AgpVersion(3, 1, 0);
    @NotNull
    private static final AgpVersion MINIMUM_AGP_VERSION_JDK_11 = new AgpVersion(3, 2, 0);
    @NotNull
    private static final GradleVersion MINIMUM_GRADLE_VERSION;

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        if (StringsKt.isBlank((CharSequence)message2)) {
            return null;
        }
        String parsedMessage = null;
        boolean withMinimumVersion = false;
        if (rootCause instanceof UnsupportedVersionException) {
            parsedMessage = this.tryToGetUnsupportedGradleMessage(message2);
            withMinimumVersion = true;
        }
        if (parsedMessage == null) {
            return null;
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(issueData){
            final /* synthetic */ GradleIssueData $issueData$inlined;
            {
                this.$issueData$inlined = gradleIssueData;
            }

            public final void run() {
                boolean bl = false;
                BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
            }
        }, ModalityState.defaultModalityState());
        BuildIssueComposer composer = new BuildIssueComposer(parsedMessage, null, 2, null);
        if (withMinimumVersion) {
            JavaSdkVersion javaSdkVersion;
            Sdk jdk = IdeSdks.getInstance().getJdk();
            if (jdk != null && jdk.getVersionString() != null) {
                String string2 = jdk.getVersionString();
                Intrinsics.checkNotNull((Object)string2);
                javaSdkVersion = JavaSdkVersion.fromVersionString((String)string2);
            } else {
                javaSdkVersion = null;
            }
            JavaSdkVersion jdkVersion = javaSdkVersion;
            boolean isJdk8OrOlder = jdkVersion != null && jdkVersion.compareTo((Enum)JavaSdkVersion.JDK_1_8) <= 0;
            AgpVersion minAgpToUse = isJdk8OrOlder ? MINIMUM_AGP_VERSION_JDK_8 : MINIMUM_AGP_VERSION_JDK_11;
            composer.addQuickFix(new UpgradeGradleVersionsQuickFix(CompatibleGradleVersion.Companion.getCompatibleGradleVersion(minAgpToUse).getVersion(), minAgpToUse, "minimum"));
        }
        composer.addQuickFix("Open build file", new OpenPluginBuildFileQuickFix());
        return composer.composeBuildIssue();
    }

    private final String tryToGetUnsupportedGradleMessage(String message2) {
        Matcher matcher = UNSUPPORTED_GRADLE_VERSION_PATTERN.matcher(message2);
        if (matcher.matches()) {
            Object object;
            Object object2;
            Object object3 = this;
            try {
                OldAndroidPluginIssueChecker $this$tryToGetUnsupportedGradleMessage_u24lambda_u2d1 = object3;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)GradleVersion.version((String)matcher.group(1)));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object3 = object2;
            GradleVersion gradleVersion2 = (GradleVersion)(Result.isFailure-impl((Object)object3) ? null : object3);
            if (gradleVersion2 == null) {
                return null;
            }
            GradleVersion minimumVersion = gradleVersion2;
            object2 = this;
            try {
                OldAndroidPluginIssueChecker $this$tryToGetUnsupportedGradleMessage_u24lambda_u2d2 = (OldAndroidPluginIssueChecker)object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)GradleVersion.version((String)matcher.group(2)));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            GradleVersion gradleVersion3 = (GradleVersion)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (gradleVersion3 == null) {
                return null;
            }
            GradleVersion usedVersion = gradleVersion3;
            if (minimumVersion.compareTo(MINIMUM_GRADLE_VERSION) <= 0) {
                return "This version of Android Studio requires projects to use Gradle " + MINIMUM_GRADLE_VERSION.getVersion() + " or newer. This project is using Gradle " + usedVersion.getVersion() + ".";
            }
        }
        return null;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location2, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return this.tryToGetUnsupportedGradleMessage(failureCause) != null;
    }

    static {
        GradleVersion gradleVersion2 = GradleVersion.version((String)"4.8.1");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"version(SdkConstants.GRADLE_MINIMUM_VERSION)");
        MINIMUM_GRADLE_VERSION = gradleVersion2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginIssueChecker$Companion;", "", "()V", "MINIMUM_AGP_VERSION_JDK_11", "Lcom/android/ide/common/repository/AgpVersion;", "getMINIMUM_AGP_VERSION_JDK_11", "()Lcom/android/ide/common/repository/AgpVersion;", "MINIMUM_AGP_VERSION_JDK_8", "getMINIMUM_AGP_VERSION_JDK_8", "MINIMUM_GRADLE_VERSION", "Lorg/gradle/util/GradleVersion;", "getMINIMUM_GRADLE_VERSION", "()Lorg/gradle/util/GradleVersion;", "UNSUPPORTED_GRADLE_VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "intellij.android.projectSystem.gradle.upgrade"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AgpVersion getMINIMUM_AGP_VERSION_JDK_8() {
            return MINIMUM_AGP_VERSION_JDK_8;
        }

        @NotNull
        public final AgpVersion getMINIMUM_AGP_VERSION_JDK_11() {
            return MINIMUM_AGP_VERSION_JDK_11;
        }

        @NotNull
        public final GradleVersion getMINIMUM_GRADLE_VERSION() {
            return MINIMUM_GRADLE_VERSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

